/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.adapter;

import com.vmware.license.client.cis.adapter.BaseDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BaseLicensingObjectsDataProviderAdapterImpl<T>
extends BaseDataProviderAdapterImpl {
    @Override
    protected ResultSet getResultSet(QuerySpec querySpec) {
        Object[] objects = this.getObjectsByQuerySpec(querySpec);
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet result = this.getResultSet(querySpec, objects);
        result.totalMatchedObjectCount = objects.length;
        return result;
    }

    protected abstract BasePropertyProviderBean<T> getPropertyProvider();

    protected abstract String getProvidedType();

    protected abstract URI getUri(T var1);

    protected T[] getObjectsByUris(URI[] objectUris) {
        return null;
    }

    protected T[] getRelatedObjects(Object[] objectsRefs, String relation) {
        return null;
    }

    protected T[] getObjectsByPropertyConstraint(PropertyConstraint pc) {
        return null;
    }

    protected T[] getObjectsByCompositeConstraint(CompositeConstraint cc) {
        return null;
    }

    protected T[] getAllObjects() {
        return null;
    }

    protected T[] getObjectsByRelationalConstraint(RelationalConstraint rc) {
        String relation = rc.relation;
        Object[] queriedObjectsRefs = Utils.getEnumeratedObjects((RelationalConstraint)rc);
        return this.getRelatedObjects(queriedObjectsRefs, relation);
    }

    protected final ResultSet getResultSet(QuerySpec querySpec, T[] objects) {
        Map<URI, T> uriToObject = this.groupObjectsByUri(objects);
        PropertyRequestSpec propertyRequest = new PropertyRequestSpec();
        propertyRequest.objects = uriToObject.keySet().toArray();
        propertyRequest.properties = this.filterPropertySpecsByType(querySpec.resourceSpec.propertySpecs, this.getProvidedType());
        BasePropertyProviderBean<T> propertyProvider = this.getPropertyProvider();
        propertyProvider.setUriToObjectMap(uriToObject);
        ServicePropertyProviderAdapter propertyProviderAdapter = new ServicePropertyProviderAdapter(propertyProvider);
        ResultSet result = propertyProviderAdapter.getProperties(propertyRequest);
        if (result == null) {
            result = ResultUtil.newEmptyResultSet();
        }
        return result;
    }

    private T[] getObjectsByQuerySpec(QuerySpec querySpec) {
        T[] objects = null;
        Object[] queriedObjectsRefs = Utils.getEnumeratedObjects((QuerySpec)querySpec);
        if (!ArrayUtils.isEmpty((Object[])queriedObjectsRefs)) {
            objects = this.getObjectsByRefs(queriedObjectsRefs);
            return objects;
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint pc = (PropertyConstraint)constraint;
            objects = this.getObjectsByPropertyConstraint(pc);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            objects = this.getObjectsByRelationalConstraint(rc);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            objects = this.getObjectsByCompositeConstraint(cc);
        } else {
            objects = this.getAllObjects();
        }
        return objects;
    }

    private T[] getObjectsByRefs(Object[] objectsRefs) {
        URI[] licensingObjectsUris = this.filterLicensingObjectsUris(objectsRefs);
        return this.getObjectsByUris(licensingObjectsUris);
    }

    private URI[] filterLicensingObjectsUris(Object[] objectsRefs) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (Object objectRef : objectsRefs) {
            if (!(objectRef instanceof URI) || !UriUtil.isUriOfType((URI)objectRef, this.getProvidedType())) continue;
            result.add((URI)objectRef);
        }
        return result.toArray(new URI[result.size()]);
    }

    private Map<URI, T> groupObjectsByUri(T[] objects) {
        LinkedHashMap<URI, T> result = new LinkedHashMap<URI, T>();
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return result;
        }
        for (T object : objects) {
            URI objectUri = this.getUri(object);
            result.put(objectUri, object);
        }
        return result;
    }

    private PropertySpec[] filterPropertySpecsByType(PropertySpec[] propertySpecs, String type) {
        if (type == null) {
            return new PropertySpec[0];
        }
        ArrayList<PropertySpec> result = new ArrayList<PropertySpec>();
        for (PropertySpec propertySpec : propertySpecs) {
            if (propertySpec.type != null && !type.equals(propertySpec.type)) continue;
            result.add(propertySpec);
        }
        return result.toArray(new PropertySpec[result.size()]);
    }
}

