/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.LsVmodlVersionSelector;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.license.client.cis.ls.scope.ScopeResolverException;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheLsVmodlVersionSelectorImpl
implements LsVmodlVersionSelector {
    private final Log _logger = LogFactory.getLog(CacheLsVmodlVersionSelectorImpl.class);
    private static final int LOCAL_CACHE_INITIAL_CAPACITY = 2;
    private final LsVmodlVersionSelector _lsVmodlVersionSelector;
    private final ScopeResolver _scopeResolver;
    private Cache<String, Class<?>> _localSsoDomainLsVmodlVersionCache;

    public CacheLsVmodlVersionSelectorImpl(LsVmodlVersionSelector lsVmodlVersionSelector, ScopeResolver scopeResolver) {
        this._lsVmodlVersionSelector = lsVmodlVersionSelector;
        this._scopeResolver = scopeResolver;
        this._localSsoDomainLsVmodlVersionCache = new LruCacheImpl(2);
    }

    @Override
    public Class<?> getLicenseServiceVmodlVersion(LicenseScope licenseScope) {
        String domainId = null;
        try {
            String vcId = this._scopeResolver.getVcId(licenseScope);
            VcService vcService = VimSessionUtil.getService((String)vcId);
            domainId = vcService.getSsoDomain().getId();
        }
        catch (ScopeResolverException e) {
            this._logger.error((Object)("The scope for which the LS version has to be determined, can't be resolved! Error: " + e));
        }
        Class lsVmodlVersion = null;
        if (this._localSsoDomainLsVmodlVersionCache.contains((Object)domainId)) {
            lsVmodlVersion = (Class)this._localSsoDomainLsVmodlVersionCache.get((Object)domainId);
        } else {
            lsVmodlVersion = this._lsVmodlVersionSelector.getLicenseServiceVmodlVersion(licenseScope);
            this._localSsoDomainLsVmodlVersionCache.put((Object)domainId, (Object)lsVmodlVersion);
        }
        return lsVmodlVersion;
    }
}

