/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ds.LimitEnforcementType;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.util.MathUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.vim.LicenseManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class CostUnitFactory {
    public static CostUnitFactory INSTANCE = new CostUnitFactory();

    public CostUnit[] createCostUnits(CostUnitUsage[] usages, CostUnitLimit[] limits) {
        if (ArrayUtils.isEmpty((Object[])usages) && ArrayUtils.isEmpty((Object[])limits)) {
            return new CostUnit[0];
        }
        Map<String, CostUnitUsage> idToUsage = this.createIdToUsageMap(usages);
        Map<String, CostUnitLimit> idToLimit = this.createIdToLimitMap(limits);
        return this.createCostUnits(idToUsage, idToLimit);
    }

    public CostUnit createCostUnit(CostUnitUsage usage, CostUnitLimit limit) {
        if (usage == null && limit == null) {
            return null;
        }
        String id = usage == null ? limit.getUnit().getId() : usage.getUnit().getId();
        Long usageValue = usage != null ? Long.valueOf(usage.getValue()) : null;
        Long limitValue = limit != null ? Long.valueOf(limit.getValue()) : null;
        LimitEnforcementType enforcementType = limit != null ? this.getLimitEnforcementType(limit.getEnforcementType()) : null;
        return this.createCostUnit(id, usageValue, limitValue, enforcementType);
    }

    public CostUnit createCostUnit(LicenseManager.LicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return null;
        }
        return this.createCostUnit(licenseInfo.getCostUnit(), licenseInfo.getUsed(), licenseInfo.getTotal(), LimitEnforcementType.HARD_ENFORCED);
    }

    public CostUnit createCostUnit(String id, Number usageValue, Number limitValue, LimitEnforcementType limitEnforcementType) {
        CostUnit costUnit = new CostUnit();
        costUnit.setId(id);
        Double usage = usageValue != null ? Double.valueOf(usageValue.doubleValue()) : null;
        costUnit.setUsage(usage);
        Double limit = limitValue != null ? Double.valueOf(limitValue.doubleValue()) : null;
        costUnit.setLimit(limit);
        costUnit.setLimitEnforcementType(limitEnforcementType);
        Double usagePercentage = MathUtil.calculatePercentage(usage, limit);
        costUnit.setUsagePercentage(usagePercentage);
        return costUnit;
    }

    private Map<String, CostUnitUsage> createIdToUsageMap(CostUnitUsage[] usages) {
        LinkedHashMap<String, CostUnitUsage> idToUsage = new LinkedHashMap<String, CostUnitUsage>();
        if (ArrayUtils.isEmpty((Object[])usages)) {
            return idToUsage;
        }
        for (CostUnitUsage usage : usages) {
            idToUsage.put(usage.getUnit().getId(), usage);
        }
        return idToUsage;
    }

    private Map<String, CostUnitLimit> createIdToLimitMap(CostUnitLimit[] limits) {
        LinkedHashMap<String, CostUnitLimit> idToLimit = new LinkedHashMap<String, CostUnitLimit>();
        if (ArrayUtils.isEmpty((Object[])limits)) {
            return idToLimit;
        }
        for (CostUnitLimit limit : limits) {
            idToLimit.put(limit.getUnit().getId(), limit);
        }
        return idToLimit;
    }

    private CostUnit[] createCostUnits(Map<String, CostUnitUsage> idToUsage, Map<String, CostUnitLimit> idToLimit) {
        String id;
        ArrayList<CostUnit> costUnits = new ArrayList<CostUnit>();
        for (Map.Entry<String, CostUnitUsage> entry : idToUsage.entrySet()) {
            id = entry.getKey();
            CostUnitLimit limit = idToLimit.remove(id);
            costUnits.add(this.createCostUnit(entry.getValue(), limit));
        }
        for (Map.Entry<String, CostUnitUsage> entry : idToLimit.entrySet()) {
            id = entry.getKey();
            CostUnitUsage usage = idToUsage.get(id);
            costUnits.add(this.createCostUnit(usage, (CostUnitLimit)entry.getValue()));
        }
        return costUnits.toArray(new CostUnit[costUnits.size()]);
    }

    private LimitEnforcementType getLimitEnforcementType(String enforcementTypeString) {
        LimitEnforcementType limitEnforcementType = null;
        if (com.vmware.vim.binding.cis.license.LimitEnforcementType.notEnforced.name().equals(enforcementTypeString)) {
            limitEnforcementType = LimitEnforcementType.NOT_ENFORCED;
        } else if (com.vmware.vim.binding.cis.license.LimitEnforcementType.softEnforced.name().equals(enforcementTypeString)) {
            limitEnforcementType = LimitEnforcementType.SOFT_ENFORCED;
        } else if (com.vmware.vim.binding.cis.license.LimitEnforcementType.hardEnforced.name().equals(enforcementTypeString)) {
            limitEnforcementType = LimitEnforcementType.HARD_ENFORCED;
        }
        return limitEnforcementType;
    }
}

