/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedContractDetails;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedCustomLabel;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFormattedOrderDetails;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementObjectsFormatterImpl
implements ManagementObjectsFormatter {
    private static final int FAILED_NUMBER_PARSE_ERROR_CODE = -1;
    private final Log _logger = LogFactory.getLog(ManagementObjectsFormatterImpl.class);

    @Override
    public void formatLicenses(License[] licenses) {
        this.formatLicenses(licenses, true);
    }

    @Override
    public void formatLicenses(License[] licenses, boolean stripMyVMwarePlainData) {
        if (ArrayUtils.isEmpty((Object[])licenses)) {
            return;
        }
        for (License license : licenses) {
            this.formatLicense(license, stripMyVMwarePlainData);
        }
    }

    @Override
    public void formatProductAggregations(ProductAggregation[] productAggregations) {
        if (ArrayUtils.isEmpty((Object[])productAggregations)) {
            return;
        }
        for (ProductAggregation productAggregation : productAggregations) {
            License[] licenses = productAggregation.getLicenses();
            this.formatProduct(productAggregation.getProduct());
            this.formatLicenses(licenses);
        }
    }

    @Override
    public void formatAssets(Asset[] assets) {
        if (ArrayUtils.isEmpty((Object[])assets)) {
            return;
        }
        for (Asset asset : assets) {
            this.formatFeatures(asset.getFeaturesInUse());
            this.formatLicense(asset.getEvaluationLicense());
            this.formatAssetLicense(asset);
            this.formatAssetProductName(asset);
            this.formatAssetCostUnits(asset);
        }
    }

    private void formatLicense(License license) {
        this.formatLicense(license, true);
    }

    private void formatLicense(License license, boolean stripMyVMwarePlainData) {
        if (license == null) {
            return;
        }
        if (license.getIsEvaluation()) {
            license.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        }
        String formattedExpirationDate = LicenseUtil.getLicenseFormattedExpirationDate(license.getExpirationDate(), license.getExpirationTime());
        license.setFormattedExpirationDate(formattedExpirationDate);
        this.formatLicenseProductRestrictions(license);
        this.formatMyVMwareLicenseInfo(license.getMyVMwareInfo(), stripMyVMwarePlainData);
    }

    private void formatLicenseProductRestrictions(License license) {
        Object[] productRestrictions = license.getProductRestrictions();
        if (ArrayUtils.isEmpty((Object[])productRestrictions)) {
            return;
        }
        for (Object productRestriction : productRestrictions) {
            this.formatProduct(((ProductRestriction)productRestriction).getProduct());
            Collection<ProductCapability> productCapabilities = ((ProductRestriction)productRestriction).getVersionToProductCapability().values();
            for (ProductCapability productCapability : productCapabilities) {
                productCapability.setProperties(null);
                this.formatFeatures(productCapability.getFeatures());
            }
        }
    }

    private void formatProduct(Product product) {
        CostUnit[] productCostUnits = product.getCostUnits();
        CostUnitUtil.formatCostUnits(product.getCostUnits());
        product.setFormattedName(product.getName());
        product.setCostUnits(productCostUnits);
    }

    private void formatFeatures(Feature[] features) {
        if (ArrayUtils.isEmpty((Object[])features)) {
            return;
        }
        for (Feature feature : features) {
            if (feature == null || feature.getId() == null) continue;
            String formattedId = FeatureUtil.getFeatureFormattedId(feature.getId());
            feature.setFormattedId(formattedId);
        }
    }

    private void formatMyVMwareLicenseInfo(MyVMwareLicenseInfo myVMwareLicenseInfo, boolean stripMyVMwarePlainData) {
        if (myVMwareLicenseInfo == null) {
            return;
        }
        MyVMwareSerialKeyInfo[] myVMwareSerialKeysInfo = myVMwareLicenseInfo.getSerialKeysInfo();
        if (myVMwareSerialKeysInfo == null) {
            return;
        }
        for (MyVMwareSerialKeyInfo myVMwareSerialKeyInfo : myVMwareSerialKeysInfo) {
            this.formatMyVMwareSerialKeyInfo(myVMwareSerialKeyInfo, stripMyVMwarePlainData);
        }
    }

    private void formatMyVMwareSerialKeyInfo(MyVMwareSerialKeyInfo myVMwareSerialKeyInfo, boolean stripMyVMwarePlainData) {
        if (myVMwareSerialKeyInfo == null) {
            return;
        }
        if (myVMwareSerialKeyInfo.getData() == null || myVMwareSerialKeyInfo.getVersion() == null) {
            return;
        }
        LicenseKeyDetails licenseKeyDetails = LicenseKeyDetailsDecoder.decodeLicenseKeyDetails(myVMwareSerialKeyInfo.getData(), myVMwareSerialKeyInfo.getVersion());
        if (licenseKeyDetails == null) {
            this._logger.warn((Object)"Unable to decode license metadata.");
            return;
        }
        myVMwareSerialKeyInfo.setHasActiveSupport(licenseKeyDetails.hasActiveSupport);
        myVMwareSerialKeyInfo.setFormattedAccountName(this.getFormattedAccountName(licenseKeyDetails.accountName, licenseKeyDetails.accountNumber));
        myVMwareSerialKeyInfo.setFormattedNotes(licenseKeyDetails.licenseKeyNotes);
        myVMwareSerialKeyInfo.setFormattedCustomLabels(this.getFormattedCustomLabels(licenseKeyDetails.customLabels));
        myVMwareSerialKeyInfo.setFormattedFolderLocation(licenseKeyDetails.folderLocation);
        myVMwareSerialKeyInfo.setFormattedOrdersDetails(this.getFormattedOrdersDetails(licenseKeyDetails.ordersDetails));
        myVMwareSerialKeyInfo.setFormattedContractsDetails(this.getMyVMwareFormattedContractsDetails(licenseKeyDetails.contractsDetails));
        if (stripMyVMwarePlainData) {
            myVMwareSerialKeyInfo.setVersion(null);
            myVMwareSerialKeyInfo.setData(null);
        }
    }

    private String getFormattedAccountName(String accountName, String accountNumber) {
        if (StringUtils.isEmpty((CharSequence)accountName)) {
            return accountNumber;
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountName;
        }
        return accountNumber + " - " + accountName;
    }

    private MyVMwareFormattedCustomLabel[] getFormattedCustomLabels(KeyAnyValue[] customLabels) {
        if (ArrayUtils.isEmpty((Object[])customLabels)) {
            return new MyVMwareFormattedCustomLabel[0];
        }
        MyVMwareFormattedCustomLabel[] resultFormattedCustomLabels = new MyVMwareFormattedCustomLabel[customLabels.length];
        for (int i = 0; i < resultFormattedCustomLabels.length; ++i) {
            resultFormattedCustomLabels[i] = this.buildMyVMwareFormattedCustomLabel(customLabels[i]);
        }
        return resultFormattedCustomLabels;
    }

    private MyVMwareFormattedOrderDetails[] getFormattedOrdersDetails(OrderDetails[] ordersDetails) {
        if (ArrayUtils.isEmpty((Object[])ordersDetails)) {
            return new MyVMwareFormattedOrderDetails[0];
        }
        MyVMwareFormattedOrderDetails[] resultOrdersDetails = new MyVMwareFormattedOrderDetails[ordersDetails.length];
        for (int i = 0; i < resultOrdersDetails.length; ++i) {
            resultOrdersDetails[i] = this.buildMyVMwareFormattedOrderDetails(ordersDetails[i]);
        }
        return resultOrdersDetails;
    }

    private MyVMwareFormattedContractDetails[] getMyVMwareFormattedContractsDetails(ContractDetails[] contractsDetails) {
        if (ArrayUtils.isEmpty((Object[])contractsDetails)) {
            return new MyVMwareFormattedContractDetails[0];
        }
        MyVMwareFormattedContractDetails[] resultContractsDetails = new MyVMwareFormattedContractDetails[contractsDetails.length];
        for (int i = 0; i < resultContractsDetails.length; ++i) {
            resultContractsDetails[i] = this.buildMyVMwareFormattedContractDetails(contractsDetails[i]);
        }
        return resultContractsDetails;
    }

    private MyVMwareFormattedCustomLabel buildMyVMwareFormattedCustomLabel(KeyAnyValue serviceCustomLabel) {
        MyVMwareFormattedCustomLabel result = new MyVMwareFormattedCustomLabel();
        String key = serviceCustomLabel.getKey();
        Object value = serviceCustomLabel.getValue();
        String formattedKey = key;
        String formattedValue = null;
        String formattedKeyValue = key;
        if (value != null) {
            formattedValue = value.toString();
            formattedKeyValue = formattedKeyValue + ": " + value;
        }
        result.setKey(formattedKey);
        result.setValue(formattedValue);
        result.setKeyValue(formattedKeyValue);
        return result;
    }

    private MyVMwareFormattedOrderDetails buildMyVMwareFormattedOrderDetails(OrderDetails orderDetails) {
        MyVMwareFormattedOrderDetails result = new MyVMwareFormattedOrderDetails();
        Date formattedDate = DateUtil.getDate(orderDetails.date);
        String formattedQuantity = this.getFormattedLongValue(orderDetails.quantity);
        result.setNumber(orderDetails.number);
        result.setDate(formattedDate);
        result.setQuantity(formattedQuantity);
        result.setPoNumber(orderDetails.poNumber);
        return result;
    }

    private MyVMwareFormattedContractDetails buildMyVMwareFormattedContractDetails(ContractDetails contractDetails) {
        MyVMwareFormattedContractDetails result = new MyVMwareFormattedContractDetails();
        Date formattedStartDate = DateUtil.getDate(contractDetails.startDate);
        Date formattedEndDate = DateUtil.getDate(contractDetails.endDate);
        result.setSupportLevel(contractDetails.supportLevel);
        result.setStartDate(formattedStartDate);
        result.setEndDate(formattedEndDate);
        result.setNumber(contractDetails.number);
        result.setElaFlag(contractDetails.elaFlag);
        return result;
    }

    private String getFormattedLongValue(long value) {
        if (value == -1L) {
            return null;
        }
        return Long.toString(value);
    }

    private void formatAssetLicense(Asset asset) {
        License assetLicense = asset.getLicense();
        this.formatLicense(assetLicense);
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        if (AssetLicenseState.EVALUATION.equals((Object)assetLicenseState)) {
            assetLicense.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        } else if (AssetLicenseState.UNLICENSED.equals((Object)assetLicenseState)) {
            License license = new License();
            license.setName(ManagementUtil.getLocalizedString("asset.unlicensed.license.name"));
            asset.setLicense(license);
        }
    }

    private void formatAssetProductName(Asset asset) {
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        String formattedProductName = null;
        if (AssetLicenseState.LICENSED.equals((Object)assetLicenseState)) {
            ProductRestriction assetProductRestriction = AssetUtil.getAssetProductRestriction(asset);
            formattedProductName = assetProductRestriction.getProduct().getFormattedName();
        } else {
            formattedProductName = AssetLicenseState.EVALUATION.equals((Object)assetLicenseState) ? ManagementUtil.getLocalizedString("product.evaluation.name") : ManagementUtil.getLocalizedString("asset.unlicensed.product.name");
        }
        asset.setFormattedProductName(formattedProductName);
    }

    private void formatAssetCostUnits(Asset asset) {
        CostUnit[] resultCostUnitsUsage = null;
        resultCostUnitsUsage = AssetLicenseState.UNLICENSED.equals((Object)asset.getLicenseState()) ? new CostUnit[]{} : this.getAssetLicenseCostUnitsUsage(asset);
        CostUnitUtil.formatCostUnits(resultCostUnitsUsage);
        asset.setCostUnitUsage(resultCostUnitsUsage);
    }

    private static String getEvaluationLicenseName() {
        return ManagementUtil.getLocalizedString("license.evaluation.name");
    }

    private CostUnit[] getAssetLicenseCostUnitsUsage(Asset asset) {
        ArrayList<CostUnit> costUnitsUsages = new ArrayList<CostUnit>();
        ProductRestriction assetProductRestriction = AssetUtil.getAssetProductRestriction(asset);
        Set<String> licensedCostUnitsIds = CostUnitUtil.getCostUnitIds(assetProductRestriction.getProduct().getCostUnits());
        for (CostUnit costUnitUsage : asset.getCostUnitUsage()) {
            if (!licensedCostUnitsIds.contains(costUnitUsage.getId())) continue;
            costUnitsUsages.add(costUnitUsage);
        }
        CostUnit[] resultCostUnitsUsages = costUnitsUsages.toArray(new CostUnit[costUnitsUsages.size()]);
        return resultCostUnitsUsages;
    }

    private static class ContractDetails {
        public String number;
        public Calendar startDate;
        public Calendar endDate;
        public String supportLevel;
        public String elaFlag;

        private ContractDetails() {
        }
    }

    private static class OrderDetails {
        public String number;
        public Calendar date;
        public long quantity;
        private String poNumber;

        private OrderDetails() {
        }
    }

    private static class LicenseKeyDetails {
        public String accountName;
        public String accountNumber;
        public String folderLocation;
        public String licenseKeyNotes;
        public KeyAnyValue[] customLabels;
        public OrderDetails[] ordersDetails;
        public ContractDetails[] contractsDetails;
        public boolean hasActiveSupport;

        private LicenseKeyDetails() {
        }
    }

    private static class LicenseKeyDetailsDecoder {
        private static final String LICENSE_METADATA_PROP_NOTES = "licenseKeyNotes";
        private static final String LICENSE_METADATA_PROP_CUSTOM_LABELS = "customLabels";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NAME = "accountName";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NUMBER = "accountNumber";
        private static final String LICENSE_METADATA_RPOP_FOLDER_LOCATION = "folderLocation";
        private static final String LICENSE_METADATA_PROP_ORDER_DETAILS = "orderDetails";
        private static final String LICENSE_METADATA_PROP_ORDER_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_ORDER_QUANTITY = "orderQuantity";
        private static final String LICENSE_METADATA_PROP_ORDER_DATE = "orderDate";
        private static final String LICENSE_METADATA_PROP_ORDER_PO_NUMBER = "poNumber";
        private static final String LICENSE_METADATA_PROP_CONTRACT_DETAILS = "contractDetails";
        private static final String LICENSE_METADATA_PROP_CONTRACT_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE = "licenseCoverageStartDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE = "licenseCoverageEndDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL = "supportLevel";
        private static final String LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG = "ELAFlag";

        private LicenseKeyDetailsDecoder() {
        }

        private static LicenseKeyDetails decodeLicenseKeyDetails(byte[] data, String version) {
            Object[] myVMwareProperties = MyVMwareUtil.decodeLicenseMetadata((byte[])data, (String)version);
            if (ArrayUtils.isEmpty((Object[])myVMwareProperties)) {
                return null;
            }
            LicenseKeyDetails result = new LicenseKeyDetails();
            result.hasActiveSupport = MyVMwareUtil.isLicenseWithActiveSupport((KeyAnyValue[])myVMwareProperties);
            ArrayList<OrderDetails> ordersDetails = new ArrayList<OrderDetails>();
            ArrayList<ContractDetails> contractsDetails = new ArrayList<ContractDetails>();
            for (Object myVMwareProperty : myVMwareProperties) {
                String propertyKey = myVMwareProperty.getKey();
                if (LICENSE_METADATA_PROP_ACCOUNT_NAME.equals(propertyKey)) {
                    result.accountName = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ACCOUNT_NUMBER.equals(propertyKey)) {
                    result.accountNumber = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_RPOP_FOLDER_LOCATION.equals(propertyKey)) {
                    result.folderLocation = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_NOTES.equals(propertyKey)) {
                    result.licenseKeyNotes = (String)myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CUSTOM_LABELS.equals(propertyKey)) {
                    result.customLabels = (KeyAnyValue[])myVMwareProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DETAILS.equals(propertyKey)) {
                    KeyAnyValue[] orderProperties = (KeyAnyValue[])myVMwareProperty.getValue();
                    OrderDetails orderDetails = LicenseKeyDetailsDecoder.buildUiOrderDetails(orderProperties);
                    ordersDetails.add(orderDetails);
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_DETAILS.equals(propertyKey)) continue;
                KeyAnyValue[] contractProperties = (KeyAnyValue[])myVMwareProperty.getValue();
                ContractDetails contractDetails = LicenseKeyDetailsDecoder.buildUiContractDetails(contractProperties);
                contractsDetails.add(contractDetails);
            }
            result.ordersDetails = ordersDetails.toArray(new OrderDetails[ordersDetails.size()]);
            result.contractsDetails = contractsDetails.toArray(new ContractDetails[contractsDetails.size()]);
            return result;
        }

        private static OrderDetails buildUiOrderDetails(KeyAnyValue[] serviceOrderProperties) {
            OrderDetails orderDetails = new OrderDetails();
            for (KeyAnyValue orderProperty : serviceOrderProperties) {
                String propKey = orderProperty.getKey();
                if ("number".equals(propKey)) {
                    orderDetails.number = (String)orderProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_QUANTITY.equals(propKey)) {
                    orderDetails.quantity = (Long)orderProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DATE.equals(propKey)) {
                    orderDetails.date = (Calendar)orderProperty.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_ORDER_PO_NUMBER.equals(propKey)) continue;
                orderDetails.poNumber = (String)orderProperty.getValue();
            }
            return orderDetails;
        }

        private static ContractDetails buildUiContractDetails(KeyAnyValue[] serviceContractProperties) {
            ContractDetails contractDetails = new ContractDetails();
            for (KeyAnyValue contractProperty : serviceContractProperties) {
                String propKey = contractProperty.getKey();
                if ("number".equals(propKey)) {
                    contractDetails.number = (String)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE.equals(propKey)) {
                    contractDetails.startDate = (Calendar)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE.equals(propKey)) {
                    contractDetails.endDate = (Calendar)contractProperty.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL.equals(propKey)) {
                    contractDetails.supportLevel = (String)contractProperty.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG.equals(propKey)) continue;
                contractDetails.elaFlag = (String)contractProperty.getValue();
            }
            return contractDetails;
        }
    }
}

