/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedCostUnitUsage;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedLicenseUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedProductUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedUsages;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class AssignLicenseUsageCalculationUtil {
    public static AssignLicenseAggregatedUsages createAssignLicenseAggregatedUsages(Asset[] assets, License[] licenses) {
        if (ArrayUtils.isEmpty((Object[])assets) || ArrayUtils.isEmpty((Object[])licenses)) {
            return null;
        }
        HashMap<URI, AssignLicenseAggregatedLicenseUsages> licenseRefToLicenseUsages = new HashMap<URI, AssignLicenseAggregatedLicenseUsages>();
        AssetsAggregation assetsAggregation = AssignLicenseUsageCalculationUtil.getAssetsAggregation(assets);
        Map<URI, Map<String, AggregatedUsage>> licenseRefToCostUnitKeyToAggregatedUsage = AssignLicenseUsageCalculationUtil.createLicenseRefToCostUnitKeyToAggregatedUsage(assets);
        Map<String, AggregatedUsage> productCostUnitKeyToAggregatedUsage = AssignLicenseUsageCalculationUtil.createCostUnitKeyToAggregatedUsage(licenseRefToCostUnitKeyToAggregatedUsage);
        for (License license : licenses) {
            Map<String, AggregatedUsage> licenseCostUnitKeyToAggregatedUsage = licenseRefToCostUnitKeyToAggregatedUsage.get(license.getUri());
            AssignLicenseAggregatedLicenseUsages assignLicenseAggregatedLicenseUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedLicenseUsages(license, licenseCostUnitKeyToAggregatedUsage, productCostUnitKeyToAggregatedUsage, assetsAggregation);
            licenseRefToLicenseUsages.put(license.getUri(), assignLicenseAggregatedLicenseUsages);
        }
        AssignLicenseAggregatedUsages result = new AssignLicenseAggregatedUsages();
        result.setLicenseRefToLicenseUsages(licenseRefToLicenseUsages);
        return result;
    }

    private static Map<URI, Map<String, AggregatedUsage>> createLicenseRefToCostUnitKeyToAggregatedUsage(Asset[] assets) {
        HashMap<URI, Map<String, AggregatedUsage>> result = new HashMap<URI, Map<String, AggregatedUsage>>();
        for (Asset asset : assets) {
            if (AssetLicenseState.UNLICENSED.equals((Object)asset.getLicenseState())) continue;
            URI licenseUri = AssetLicenseState.EVALUATION.equals((Object)asset.getLicenseState()) ? LicenseUtil.EVALUATION_LICENSE_URI : asset.getLicense().getUri();
            HashMap costUnitKeyToAggregatedUsage = (HashMap)result.get(licenseUri);
            if (costUnitKeyToAggregatedUsage == null) {
                costUnitKeyToAggregatedUsage = new HashMap();
                result.put(licenseUri, costUnitKeyToAggregatedUsage);
            }
            AggregatedUsageUtil.addAssetCostUnitUsages(asset, costUnitKeyToAggregatedUsage);
        }
        return result;
    }

    private static Map<String, AggregatedUsage> createCostUnitKeyToAggregatedUsage(Map<URI, Map<String, AggregatedUsage>> licenseRefToCostUnitKeyToAggregatedUsage) {
        HashMap<String, AggregatedUsage> result = new HashMap<String, AggregatedUsage>();
        for (Map<String, AggregatedUsage> costUnitKeyToAggregatedUsage : licenseRefToCostUnitKeyToAggregatedUsage.values()) {
            AggregatedUsageUtil.addAggregatedUsages(result, costUnitKeyToAggregatedUsage);
        }
        return result;
    }

    private static AssetsAggregation getAssetsAggregation(Asset[] assets) {
        HashMap<String, List<Asset>> productFamilyKeyToAssets = new HashMap<String, List<Asset>>();
        HashMap<String, Double> costUnitKeyToMaxAssetUsage = new HashMap<String, Double>();
        for (Asset asset : assets) {
            String productFamilyKey = AssignLicenseUsageCalculationUtil.getProductFamilyKey(asset.getProductFamily());
            List<Asset> productAssets = productFamilyKeyToAssets.get(productFamilyKey);
            if (productAssets == null) {
                productAssets = new ArrayList<Asset>();
                productFamilyKeyToAssets.put(productFamilyKey, productAssets);
            }
            productAssets.add(asset);
            for (CostUnit costUnit : asset.getCostUnitUsage()) {
                String costUnitKey = AggregatedUsageUtil.getCostUnitKey(asset.getProductFamily(), costUnit);
                Double maxAssetUsage = costUnitKeyToMaxAssetUsage.get(costUnitKey);
                if (maxAssetUsage == null || maxAssetUsage < costUnit.getUsage()) {
                    maxAssetUsage = costUnit.getUsage();
                }
                costUnitKeyToMaxAssetUsage.put(costUnitKey, maxAssetUsage);
            }
        }
        AssetsAggregation resultAssetsAggregation = new AssetsAggregation(productFamilyKeyToAssets, costUnitKeyToMaxAssetUsage);
        return resultAssetsAggregation;
    }

    private static String getProductFamilyKey(ProductFamily productFamily) {
        return productFamily.getName();
    }

    private static AssignLicenseAggregatedLicenseUsages createAssignLicenseAggregatedLicenseUsages(License license, Map<String, AggregatedUsage> licenseCostUnitKeyToAggregatedUsage, Map<String, AggregatedUsage> productCostUnitKeyToAggregatedUsage, AssetsAggregation assetsAggregation) {
        AssignLicenseAggregatedLicenseUsages result = new AssignLicenseAggregatedLicenseUsages();
        HashMap<URI, AssignLicenseAggregatedProductUsages> productRefToProductUsage = new HashMap<URI, AssignLicenseAggregatedProductUsages>();
        Object[] productRestrictions = license.getProductRestrictions();
        if (ArrayUtils.isEmpty((Object[])productRestrictions)) {
            return result;
        }
        for (Object productRestriction : productRestrictions) {
            Product product = ((ProductRestriction)productRestriction).getProduct();
            AssignLicenseAggregatedProductUsages assignLicenseAggregatedProductUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedProductUsages(product, licenseCostUnitKeyToAggregatedUsage, productCostUnitKeyToAggregatedUsage, assetsAggregation);
            productRefToProductUsage.put(product.getUri(), assignLicenseAggregatedProductUsages);
        }
        result.setProductRefToProductUsages(productRefToProductUsage);
        return result;
    }

    private static AssignLicenseAggregatedProductUsages createAssignLicenseAggregatedProductUsages(Product product, Map<String, AggregatedUsage> licenseCostUnitKeyToAggregatedUsage, Map<String, AggregatedUsage> productCostUnitKeyToAggregatedUsage, AssetsAggregation assetsAggregation) {
        AssignLicenseAggregatedProductUsages result = new AssignLicenseAggregatedProductUsages();
        HashMap<String, AssignLicenseAggregatedCostUnitUsage> costUnitIdToCostUnitUsage = new HashMap<String, AssignLicenseAggregatedCostUnitUsage>();
        for (CostUnit costUnit : product.getCostUnits()) {
            String productFamilyKey;
            List<Asset> productAssets;
            AggregatedUsage licenseAggregatedUsage = AggregatedUsageUtil.getAggregatedUsage(licenseCostUnitKeyToAggregatedUsage, product.getFamily(), costUnit);
            AggregatedUsage productAggregatedUsage = AggregatedUsageUtil.getAggregatedUsage(productCostUnitKeyToAggregatedUsage, product.getFamily(), costUnit);
            ProductFamily productFamily = product.getFamily();
            String costUnitKey = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
            Double maxAssetCostUnitUsage = assetsAggregation.costUnitKeyToMaxAssetUsage.get(costUnitKey);
            if (maxAssetCostUnitUsage == null) {
                maxAssetCostUnitUsage = 0.0;
            }
            int assetsCount = (productAssets = assetsAggregation.productFamilyKeyToAssets.get(productFamilyKey = AssignLicenseUsageCalculationUtil.getProductFamilyKey(productFamily))) == null ? 0 : productAssets.size();
            boolean isAggregationComplete = productAggregatedUsage.usagesCount == assetsCount;
            double costUnitUsage = costUnit.getUsage() != null ? costUnit.getUsage() : 0.0;
            double usageWithoutAggregatedAssetUsage = Math.round(costUnitUsage - licenseAggregatedUsage.usage);
            double usageWithAggregatedAssetUsage = Math.round(usageWithoutAggregatedAssetUsage + productAggregatedUsage.usage);
            AssignLicenseAggregatedCostUnitUsage assignLicenseAggregatedCostUnitUsage = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedCostUnitUsage(costUnit, isAggregationComplete, usageWithAggregatedAssetUsage, usageWithoutAggregatedAssetUsage, maxAssetCostUnitUsage);
            costUnitIdToCostUnitUsage.put(costUnit.getId(), assignLicenseAggregatedCostUnitUsage);
        }
        result.setCostUnitIdToCostUnitUsage(costUnitIdToCostUnitUsage);
        return result;
    }

    private static AssignLicenseAggregatedCostUnitUsage createAssignLicenseAggregatedCostUnitUsage(CostUnit costUnit, boolean isAggregationComplete, Double usageWithAggregatedAssetUsage, Double usageWithoutAggregatedAssetUsage, Double maxAssetUsage) {
        AssignLicenseAggregatedCostUnitUsage assignLicenseAggregatedCostUnitUsage = new AssignLicenseAggregatedCostUnitUsage();
        assignLicenseAggregatedCostUnitUsage.setCostUnit(costUnit);
        assignLicenseAggregatedCostUnitUsage.setAggregationComplete(isAggregationComplete);
        assignLicenseAggregatedCostUnitUsage.setUsageWithAggregatedAssetUsage(usageWithAggregatedAssetUsage);
        assignLicenseAggregatedCostUnitUsage.setUsageWithoutAggregatedAssetUsage(usageWithoutAggregatedAssetUsage);
        assignLicenseAggregatedCostUnitUsage.setMaxAssetUsage(maxAssetUsage);
        return assignLicenseAggregatedCostUnitUsage;
    }

    private static class AssetsAggregation {
        Map<String, List<Asset>> productFamilyKeyToAssets;
        Map<String, Double> costUnitKeyToMaxAssetUsage;

        public AssetsAggregation(Map<String, List<Asset>> productFamilyKeyToAssets, Map<String, Double> costUnitKeyToMaxAssetUsage) {
            this.productFamilyKeyToAssets = productFamilyKeyToAssets;
            this.costUnitKeyToMaxAssetUsage = costUnitKeyToMaxAssetUsage;
        }
    }

    private static class AggregatedUsage {
        Double usage = 0.0;
        int usagesCount = 0;

        private AggregatedUsage() {
        }
    }

    private static class AggregatedUsageUtil {
        private static final String COST_UNIT_KEY_DELIM = "~";

        private AggregatedUsageUtil() {
        }

        private static void addAssetCostUnitUsages(Asset asset, Map<String, AggregatedUsage> costUnitKeyToAggregatedUsage) {
            ProductFamily productFamily = asset.getProductFamily();
            for (CostUnit costUnit : asset.getCostUnitUsage()) {
                AggregatedUsage aggregatedUsage;
                if (costUnit.getUsage() == null) continue;
                String costUnitKey = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
                AggregatedUsage aggregatedUsage2 = aggregatedUsage = AggregatedUsageUtil.getAndInitAggregatedUsage(costUnitKeyToAggregatedUsage, costUnitKey);
                Double.valueOf(aggregatedUsage2.usage + costUnit.getUsage());
                aggregatedUsage2.usage = aggregatedUsage2.usage;
                ++aggregatedUsage.usagesCount;
            }
        }

        private static String getCostUnitKey(ProductFamily productFamily, CostUnit costUnit) {
            String productFamilyKey = AssignLicenseUsageCalculationUtil.getProductFamilyKey(productFamily);
            return productFamilyKey + COST_UNIT_KEY_DELIM + costUnit.getId();
        }

        private static void addAggregatedUsages(Map<String, AggregatedUsage> destinationAggregatedUsage, Map<String, AggregatedUsage> sourceAggregatedUsage) {
            for (Map.Entry<String, AggregatedUsage> entry : sourceAggregatedUsage.entrySet()) {
                AggregatedUsage aggregatedUsage = AggregatedUsageUtil.getAndInitAggregatedUsage(destinationAggregatedUsage, entry.getKey());
                AggregatedUsage aggregatedUsageToAdd = entry.getValue();
                AggregatedUsage aggregatedUsage2 = aggregatedUsage;
                Double.valueOf(aggregatedUsage2.usage + aggregatedUsageToAdd.usage);
                aggregatedUsage2.usage = aggregatedUsage2.usage;
                aggregatedUsage.usagesCount += aggregatedUsageToAdd.usagesCount;
            }
        }

        private static AggregatedUsage getAndInitAggregatedUsage(Map<String, AggregatedUsage> costUnitKeyToAggregatedUsage, String costUnitKey) {
            AggregatedUsage result = costUnitKeyToAggregatedUsage.get(costUnitKey);
            if (result == null) {
                result = new AggregatedUsage();
                costUnitKeyToAggregatedUsage.put(costUnitKey, result);
            }
            return result;
        }

        private static AggregatedUsage getAggregatedUsage(Map<String, AggregatedUsage> costUnitKeyToAggregatedUsage, ProductFamily productFamily, CostUnit costUnit) {
            if (costUnitKeyToAggregatedUsage == null) {
                return new AggregatedUsage();
            }
            String costUnitKey = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
            AggregatedUsage aggregatedUsage = costUnitKeyToAggregatedUsage.get(costUnitKey);
            return aggregatedUsage == null ? new AggregatedUsage() : aggregatedUsage;
        }
    }
}

