/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.ProductFamily;
import java.net.URI;

public class ProductUtil {
    public static final String HOST_PRODUCT_FAMILY_NAME = "VMware ESX Server";
    public static final String VC_PRODUCT_FAMILY_NAME = "VMware VirtualCenter Server";
    public static final String VSAN_CLUSTER_PRODUCT_FAMILY_NAME = "VMware VSAN";
    public static final String WCP_CLUSTER_PRODUCT_FAMILY_NAME = "VMware Tanzu";
    private static final String LICENSE_DECODE_FAILED_ERROR = "DecodeError";
    private static final String LICENSE_NOT_FOUND_ERROR = "NotFoundError";

    public static Product createProduct(com.vmware.vim.binding.cis.license.Product serviceProduct, CostUnitUsage[] costUnitsUsage, CostUnitLimit[] costUnitsLimit, LicenseScope scope) {
        if (ProductUtil.isProductCorrupted(serviceProduct)) {
            return null;
        }
        URI uri = scope == null ? null : UriUtil.buildProductUri(serviceProduct.getId(), scope);
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = ProductUtil.createProductFamily(serviceProduct.getFamily());
        CostUnit[] costUnits = CostUnitFactory.INSTANCE.createCostUnits(costUnitsUsage, costUnitsLimit);
        return ProductUtil.createProduct(uri, serviceProduct.getName(), serviceProduct.getSuiteName(), productFamily, costUnits);
    }

    public static Product createProduct(URI uri, String name, String suiteName, com.vmware.license.client.cis.management.ds.ProductFamily family, CostUnit[] costUnits) {
        Product product = new Product();
        product.setUri(uri);
        product.setName(name);
        product.setSuiteName(suiteName);
        product.setFamily(family);
        product.setCostUnits(costUnits == null ? new CostUnit[]{} : costUnits);
        if (family != null) {
            AssetType assetsType = ProductUtil.getAssetsTypeByProductFamilyName(family.getName());
            product.setAssetsType(assetsType);
        }
        return product;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(ProductFamily serviceProductFamily) {
        if (serviceProductFamily == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = ProductUtil.createProductFamily(serviceProductFamily.getName(), serviceProductFamily.getVersion());
        return productFamily;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(String name, String version) {
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = new com.vmware.license.client.cis.management.ds.ProductFamily();
        productFamily.setName(name);
        productFamily.setVersion(version);
        return productFamily;
    }

    public static AssetType getAssetsTypeByProductFamilyName(String productFamilyName) {
        if (productFamilyName == null) {
            return AssetType.UNKNOWN;
        }
        switch (productFamilyName) {
            case "VMware ESX Server": {
                return AssetType.HOST;
            }
            case "VMware VirtualCenter Server": {
                return AssetType.VC;
            }
            case "VMware VSAN": {
                return AssetType.CLUSTER;
            }
            case "VMware Tanzu": {
                return AssetType.WCP_CLUSTER;
            }
        }
        return AssetType.SOLUTION;
    }

    public static String getProductFamilyName(AssetType assetType) {
        if (assetType == null) {
            return null;
        }
        switch (assetType) {
            case HOST: {
                return HOST_PRODUCT_FAMILY_NAME;
            }
            case VC: {
                return VC_PRODUCT_FAMILY_NAME;
            }
            case CLUSTER: {
                return VSAN_CLUSTER_PRODUCT_FAMILY_NAME;
            }
            case WCP_CLUSTER: {
                return WCP_CLUSTER_PRODUCT_FAMILY_NAME;
            }
        }
        return null;
    }

    public static boolean areProductFamiliesEqual(com.vmware.license.client.cis.management.ds.ProductFamily productFamily1, com.vmware.license.client.cis.management.ds.ProductFamily productFamily2, boolean skipVersionCheck) {
        if (productFamily1 == null || productFamily2 == null) {
            return false;
        }
        return productFamily1.getName().equals(productFamily2.getName()) && (skipVersionCheck || productFamily1.getVersion().equals(productFamily2.getVersion()));
    }

    public static boolean isProductCorrupted(com.vmware.vim.binding.cis.license.Product serviceProduct) {
        if (serviceProduct == null) {
            return false;
        }
        String serviceProductId = serviceProduct.getId();
        return LICENSE_DECODE_FAILED_ERROR.equals(serviceProductId) || LICENSE_NOT_FOUND_ERROR.equals(serviceProductId);
    }
}

