/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.util;

import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareApiLocalizedException;
import com.vmware.license.myvmware.client.MyVMwareClientException;
import com.vmware.vim.binding.cis.license.fault.MyVMwareSyncPreviewFault;
import java.util.concurrent.TimeoutException;

public class MyVMwareApiExceptionUtil {
    private static final String SYNC_PREVIEW_FAULT_REASON_REPORT_PARSE_ERROR = "invalidReport";

    public static Exception convertToLocalizedException(Throwable inputException) {
        MyVMwareClientException myVMwareAPIException = MyVMwareApiExceptionUtil.getSpecificExceptionFromThrowableExceptionChain(inputException, MyVMwareClientException.class);
        if (myVMwareAPIException != null) {
            return MyVMwareApiExceptionUtil.convertToMyVMwareLocalizedException(myVMwareAPIException);
        }
        MyVMwareSyncPreviewFault myVMwareSyncPreviewFault = MyVMwareApiExceptionUtil.getSpecificExceptionFromThrowableExceptionChain(inputException, MyVMwareSyncPreviewFault.class);
        if (myVMwareSyncPreviewFault != null && myVMwareSyncPreviewFault.getReason().equals(MyVMwareSyncPreviewFault.ReasonType.invalidReport.name())) {
            String localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.report");
            return new MyVMwareApiLocalizedException(MyVMwareApiLocalizedException.ApiErrorId.REPORT_ERROR, localizedExceptionMessage);
        }
        TimeoutException timeoutException = MyVMwareApiExceptionUtil.getSpecificExceptionFromThrowableExceptionChain(inputException, TimeoutException.class);
        if (timeoutException != null) {
            String localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.timeout");
            return new MyVMwareApiLocalizedException(MyVMwareApiLocalizedException.ApiErrorId.TIMEOUT, localizedExceptionMessage);
        }
        String localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.other");
        return new MyVMwareApiLocalizedException(MyVMwareApiLocalizedException.ApiErrorId.OTHER, localizedExceptionMessage);
    }

    private static MyVMwareApiLocalizedException convertToMyVMwareLocalizedException(MyVMwareClientException myVMwareClientException) {
        String localizedExceptionMessage;
        MyVMwareApiLocalizedException.ApiErrorId apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.OTHER;
        switch (myVMwareClientException.getReasonType()) {
            case ACCESS_FORBIDDEN: {
                localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.accessForbidden");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.EXPIRED_AUTHENTICATION_TOKEN;
                break;
            }
            case ACCESS_UNAUTHORIZED: {
                localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.accessUnauthorized");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.INVALID_CREDENTIALS;
                break;
            }
            case RESOURCE_NOT_FOUND: 
            case OTHER: {
                localizedExceptionMessage = ManagementUtil.getLocalizedString("myVMwareOnlineSync.apiError.other");
                apiErrorId = MyVMwareApiLocalizedException.ApiErrorId.OTHER;
                break;
            }
            default: {
                localizedExceptionMessage = myVMwareClientException.getLocalizedMessage();
            }
        }
        return new MyVMwareApiLocalizedException(apiErrorId, localizedExceptionMessage);
    }

    private static <T> T getSpecificExceptionFromThrowableExceptionChain(Throwable throwable, Class<T> specificExceptionClass) {
        for (Throwable currentException = throwable; currentException != null; currentException = currentException.getCause()) {
            if (specificExceptionClass.isInstance(currentException)) {
                return specificExceptionClass.cast(currentException);
            }
            if (currentException.getCause() != currentException) continue;
            return null;
        }
        return null;
    }
}

