/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.Formatter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class ErrorMessageBuilder {
    private ArrayList<String> _errorGroupsMessages = new ArrayList();

    public <T> void buildErrorGroup(String groupLocalizationKey, Collection<T> objects, Formatter<T> formatter) {
        if (ManagementUtil.isNullOrEmpty(objects)) {
            return;
        }
        StringBuilder errorGroupMessageBuilder = new StringBuilder();
        for (T object : objects) {
            String formattedObject = formatter.format(object);
            errorGroupMessageBuilder.append(formattedObject);
        }
        String errorGroupMessage = ManagementUtil.getLocalizedString(groupLocalizationKey, errorGroupMessageBuilder.toString());
        this._errorGroupsMessages.add(errorGroupMessage);
    }

    public String getErrorMessage(String messageLocalizationKey) {
        String defaultErrorGroupSeparator = ManagementUtil.getLocalizedString("errorMessageBuilder.defaultErrorGroupSeparator");
        return this.getErrorMessage(messageLocalizationKey, defaultErrorGroupSeparator);
    }

    public String getErrorMessage(String messageLocalizationKey, String errorGroupSeparator) {
        if (messageLocalizationKey == null || errorGroupSeparator == null) {
            throw new IllegalArgumentException("messageLocalizationKey and errorGroupSeparator should not be null");
        }
        if (this._errorGroupsMessages.isEmpty()) {
            return null;
        }
        String errorGroupsMessage = StringUtils.join(this._errorGroupsMessages, (String)errorGroupSeparator);
        return ManagementUtil.getLocalizedString(messageLocalizationKey, errorGroupsMessage);
    }
}

