/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.vmomi.CompletionFuture;
import com.vmware.opsmgmt.client.commons.vmomi.FutureCompletionService;
import com.vmware.opsmgmt.client.event.impl.EventFilter;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vim.event.EventHistoryCollector;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventProvider {
    private static final String VIRTUAL_CENTER_TYPE = "Folder";
    private static final String VIRTUAL_CENTER_VALUE = "group-d1";
    private static final Log _logger = LogFactory.getLog(EventProvider.class);
    private final EventFilter filter;
    private final List<VcService> services;
    final FutureCompletionService<ManagedObjectReference, ManagedObjectReference> completionCollectorService = new FutureCompletionService();
    final FutureCompletionService<Event[], EventHistoryCollector> completionEventService = new FutureCompletionService();
    private Map<EventHistoryCollector, CollectorState> collectors;

    public EventProvider(List<VcService> services, EventFilter filter) {
        this.filter = filter;
        this.services = services;
    }

    public ConsolidatedEvents collect() {
        this.callServicesAsync();
        return this.handleServicesAsync();
    }

    private void callServicesAsync() {
        CompletionFuture createCollectorTask = null;
        for (VcService service : this.services) {
            try {
                ServiceInstanceContent content = service.getServiceInstanceContent();
                createCollectorTask = this.completionCollectorService.create((Object)content.eventManager);
                EventManager eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.eventManager);
                EventFilterSpec spec = this.removeVcNameFromUserList(this.filter.eventFilterSpec, service);
                eventManager.createCollector(spec, (Future)createCollectorTask);
            }
            catch (Exception ex) {
                if (createCollectorTask == null) {
                    ManagedObjectReference moRef = new ManagedObjectReference();
                    moRef.setValue(VIRTUAL_CENTER_VALUE);
                    moRef.setType(VIRTUAL_CENTER_TYPE);
                    moRef.setServerGuid(service.getServiceGuid());
                    createCollectorTask = this.completionCollectorService.create((Object)moRef);
                }
                createCollectorTask.setException(ex);
            }
        }
    }

    private ConsolidatedEvents handleServicesAsync() {
        CompletionFuture createCollectorTask = null;
        this.collectors = new IdentityHashMap<EventHistoryCollector, CollectorState>();
        HashMap<ManagedObjectReference, Exception> errors = new HashMap<ManagedObjectReference, Exception>();
        while (this.completionCollectorService.hasNext()) {
            try {
                createCollectorTask = this.completionCollectorService.next();
                ManagedObjectReference collectorMor = (ManagedObjectReference)createCollectorTask.get();
                EventHistoryCollector collector = (EventHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)collectorMor);
                this.collectors.put(collector, new CollectorState(this.filter.count, this.filter.requestedPage));
                this.callCollectorAsync(collector);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                errors.put((ManagedObjectReference)createCollectorTask.getContext(), (Exception)ex.getCause());
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                errors.put((ManagedObjectReference)createCollectorTask.getContext(), ex);
            }
        }
        ConsolidatedEvents consolidatedEvents = this.handleCollectorAsync();
        consolidatedEvents.errors.putAll(errors);
        return new ConsolidatedEvents(consolidatedEvents.events, consolidatedEvents.errors);
    }

    private void callCollectorAsync(EventHistoryCollector collector) {
        CompletionFuture extractEventsTask = null;
        try {
            CollectorState state = this.collectors.get(collector);
            collector.setLatestPageSize(state.getPageSize());
            extractEventsTask = this.completionEventService.create((Object)collector);
            collector.reset();
            collector.getLatestPage((Future)extractEventsTask);
        }
        catch (RuntimeException ex) {
            extractEventsTask.setException((Exception)ex);
        }
    }

    private ConsolidatedEvents handleCollectorAsync() {
        HashMap<ManagedObjectReference, Exception> errors = new HashMap<ManagedObjectReference, Exception>();
        while (this.completionEventService.hasNext()) {
            CompletionFuture extractEventTask = this.completionEventService.next();
            EventHistoryCollector collector = (EventHistoryCollector)extractEventTask.getContext();
            CollectorState collectorState = this.collectors.get(collector);
            try {
                Event[] events = (Event[])extractEventTask.get();
                boolean hasNextPage = collectorState.update(events);
                if (!hasNextPage) continue;
                extractEventTask = this.completionEventService.create((Object)collector);
                collector.readPrev(collectorState.getPageSize(), (Future)extractEventTask);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                errors.put(collector._getRef(), (Exception)ex.getCause());
            }
        }
        ConsolidatedEvents consolidatedEvents = this.getConsolidatedEvents();
        consolidatedEvents.errors.putAll(errors);
        this.releaseCollectors();
        return consolidatedEvents;
    }

    private void releaseCollectors() {
        for (EventHistoryCollector collector : this.collectors.keySet()) {
            try {
                collector.remove();
            }
            catch (Exception ex) {
                _logger.error((Object)("Error removing history collector: " + ex.getMessage()));
            }
        }
        this.collectors.clear();
    }

    private ConsolidatedEvents getConsolidatedEvents() {
        HashMap<ManagedObjectReference, List<Event>> allEvents = new HashMap<ManagedObjectReference, List<Event>>();
        HashMap<ManagedObjectReference, Exception> allErrors = new HashMap<ManagedObjectReference, Exception>();
        for (Map.Entry<EventHistoryCollector, CollectorState> entry : this.collectors.entrySet()) {
            EventHistoryCollector collector = entry.getKey();
            CollectorState collectorState = entry.getValue();
            if (!collectorState.getEvents().isEmpty()) {
                allEvents.put(collector._getRef(), collectorState.getEvents());
            }
            if (collectorState.getException() == null) continue;
            allErrors.put(collector._getRef(), collectorState.getException());
        }
        return new ConsolidatedEvents(allEvents, allErrors);
    }

    private EventFilterSpec removeVcNameFromUserList(EventFilterSpec filterSpec, VcService vcService) {
        EventFilterSpec result = filterSpec;
        if (filterSpec.userName != null && filterSpec.userName.userList != null && filterSpec.userName.userList.length != 0) {
            result = (EventFilterSpec)SerializationUtils.clone((Serializable)filterSpec);
            String vcName = VcServiceUtil.getServiceName((String)vcService.getServiceGuid()) + "\\";
            for (int index = 0; index < result.userName.userList.length; ++index) {
                String username = result.userName.userList[index];
                if (!username.startsWith(vcName)) continue;
                result.userName.userList[index] = username.substring(vcName.length());
            }
        }
        return result;
    }

    private static class CollectorState {
        private static final int MAX_PAGE_SIZE = 1000;
        private final int maxResults;
        private final int requestedPage;
        private int loadedPages;
        private List<Event> loadedEvents;
        private Exception exception;

        public CollectorState(int maxResults, int requestedPage) {
            if (maxResults == -1 && requestedPage != 0) {
                throw new IllegalArgumentException("Max number of events requested with a non zero currentPage argument.");
            }
            this.maxResults = maxResults == -1 ? Integer.MAX_VALUE : maxResults;
            this.requestedPage = requestedPage;
            this.loadedPages = 0;
            this.loadedEvents = new ArrayList<Event>();
        }

        public boolean update(Event[] events) {
            if (events == null) {
                return false;
            }
            if (this.requestedPage > this.loadedPages) {
                ++this.loadedPages;
                return true;
            }
            int previousPageSize = this.getPageSize();
            this.loadedEvents.addAll(Arrays.asList(events));
            if (this.loadedEvents.size() > this.maxResults) {
                this.loadedEvents = this.loadedEvents.subList(0, this.maxResults);
            }
            if (this.loadedEvents.size() == this.maxResults) {
                return false;
            }
            return events.length >= previousPageSize;
        }

        public void setException(Exception ex) {
            this.exception = ex;
        }

        public Exception getException() {
            return this.exception;
        }

        public int getPageSize() {
            int eventsToLoad = this.maxResults - this.loadedEvents.size();
            return Math.min(eventsToLoad, 1000);
        }

        public List<Event> getEvents() {
            return this.loadedEvents;
        }
    }

    static class ConsolidatedEvents {
        final Map<ManagedObjectReference, List<Event>> events;
        final Map<ManagedObjectReference, Exception> errors;

        ConsolidatedEvents(Map<ManagedObjectReference, List<Event>> events, Map<ManagedObjectReference, Exception> errors) {
            this.events = events;
            this.errors = errors;
        }
    }
}

