/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.h5.specs.AssetsTotalCountSpec;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import java.net.URI;
import org.apache.commons.lang3.Validate;

public class AssetsTotalCountSpecDataPropertyProvider
implements PropertyProviderBean {
    private final ManagementEditor _managementEditor;

    public AssetsTotalCountSpecDataPropertyProvider(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @ModelMetadata(type={"License"}, property="totalAssetsCount")
    public Integer getTotalAssetsCountForLicense(URI licenseUri, AssetsTotalCountSpec assetsTotalCountSpec) {
        Validate.notNull((Object)assetsTotalCountSpec);
        AssetSearchProperties assetSearchProperties = new AssetSearchProperties();
        assetSearchProperties.setType(AssetType.valueOf((String)assetsTotalCountSpec.type));
        return this._managementEditor.getTotalAssetsCountForLicense(licenseUri, assetSearchProperties);
    }

    @ModelMetadata(type={"Product"}, property="totalAssetsCount")
    public Integer getTotalAssetsCountForProduct(URI productUri, AssetsTotalCountSpec assetsTotalCountSpec) {
        Validate.notNull((Object)assetsTotalCountSpec);
        AssetSearchProperties assetSearchProperties = new AssetSearchProperties();
        assetSearchProperties.setType(AssetType.valueOf((String)assetsTotalCountSpec.type));
        return this._managementEditor.getTotalAssetsCountForProduct(productUri, assetSearchProperties);
    }

    @ModelMetadata(type={"LicensingGlobalData"}, property="totalAssetsCount")
    public Integer getTotalAssetsCountForScope(URI globalDataUri, AssetsTotalCountSpec assetsTotalCountSpec) {
        Validate.notNull((Object)assetsTotalCountSpec);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri((URI)globalDataUri);
        AssetSearchProperties assetSearchProperties = new AssetSearchProperties();
        assetSearchProperties.setType(AssetType.valueOf((String)assetsTotalCountSpec.type));
        return this._managementEditor.getTotalAssetsCount(scope, assetSearchProperties);
    }
}

