/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha.vmcp;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vsphere.client.cluster.ha.ClusterDataModel;
import com.vmware.vsphere.client.cluster.ha.HostDataModel;
import com.vmware.vsphere.client.cluster.ha.vmcp.DatastoreDataModel;
import com.vmware.vsphere.client.cluster.ha.vmcp.InaccessibleDatastoreInfo;
import com.vmware.vsphere.client.cluster.ha.vmcp.InaccessibleDatastoreInfoRetriever;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InaccessibleDatastoreInfoRetrieverImpl
implements InaccessibleDatastoreInfoRetriever {
    private final DataFetchCommand _dataFetchCommand;

    public InaccessibleDatastoreInfoRetrieverImpl(DataFetchCommand dataFetchCommand) {
        Validate.notNull((Object)dataFetchCommand);
        this._dataFetchCommand = dataFetchCommand;
    }

    @Override
    public InaccessibleDatastoreInfo[] getInaccessibleDatastoreInfo(ManagedObjectReference clusterRef) {
        Collection datastoresData;
        Validate.notNull((Object)clusterRef);
        InaccessibleDatastoreInfo[] result = new InaccessibleDatastoreInfo[]{};
        ClusterDataModel clusterData = Util.getDataModel(ClusterDataModel.class, clusterRef, this._dataFetchCommand);
        if (clusterData != null && !ArrayUtils.isEmpty((Object[])clusterData.datastores) && (datastoresData = this._dataFetchCommand.execute(DatastoreDataModel.class, (Object[])clusterData.datastores)) != null) {
            List<InaccessibleDatastoreInfo> inaccessibleInfos = this.retrieveInaccessbleDsInfos(datastoresData);
            this.populateHostNames(inaccessibleInfos);
            if (CollectionUtils.isNotEmpty(inaccessibleInfos)) {
                result = inaccessibleInfos.toArray(new InaccessibleDatastoreInfo[inaccessibleInfos.size()]);
            }
        }
        return result;
    }

    private void populateHostNames(List<InaccessibleDatastoreInfo> inaccessibleInfos) {
        if (CollectionUtils.isNotEmpty(inaccessibleInfos)) {
            Object[] hostRefs = new ManagedObjectReference[inaccessibleInfos.size()];
            int i = 0;
            for (InaccessibleDatastoreInfo inaccessibleInfo : inaccessibleInfos) {
                hostRefs[i++] = inaccessibleInfo.hostRef;
            }
            Collection hostsData = this._dataFetchCommand.execute(HostDataModel.class, hostRefs);
            for (HostDataModel hostData : hostsData) {
                for (InaccessibleDatastoreInfo inaccessibleInfo : inaccessibleInfos) {
                    if (!hostData.provider.equals(inaccessibleInfo.hostRef)) continue;
                    inaccessibleInfo.hostName = hostData.name;
                }
            }
        }
    }

    private List<InaccessibleDatastoreInfo> retrieveInaccessbleDsInfos(Collection<DatastoreDataModel> datastoresData) {
        LinkedList<InaccessibleDatastoreInfo> inaccessibleInfos = new LinkedList<InaccessibleDatastoreInfo>();
        for (DatastoreDataModel datastoreData : datastoresData) {
            if (datastoreData.hostMounts == null) continue;
            for (Datastore.HostMount hostMount : datastoreData.hostMounts) {
                boolean hostMountNotAccessible = hostMount.mountInfo.getAccessible() == false;
                String inaccessibleReason = hostMount.getMountInfo().getInaccessibleReason();
                boolean hostMountInaccessibleReasonIsPresented = StringUtils.isNotEmpty((CharSequence)inaccessibleReason);
                if (!hostMountNotAccessible || !hostMountInaccessibleReasonIsPresented) continue;
                inaccessibleInfos.add(this.newInaccessibleDatastoreInfo(datastoreData, hostMount));
            }
        }
        return inaccessibleInfos;
    }

    private InaccessibleDatastoreInfo newInaccessibleDatastoreInfo(DatastoreDataModel datastoreData, Datastore.HostMount hostMount) {
        InaccessibleDatastoreInfo inaccessibleInfo = new InaccessibleDatastoreInfo();
        inaccessibleInfo.hostRef = hostMount.key;
        inaccessibleInfo.datastoreName = datastoreData.name;
        inaccessibleInfo.datastoreRef = (ManagedObjectReference)datastoreData.provider;
        inaccessibleInfo.dsClusterName = datastoreData.dsClusterName;
        inaccessibleInfo.dsClusterRef = datastoreData.dsClusterRef;
        inaccessibleInfo.reason = this.getInaccessibleReason(hostMount.getMountInfo());
        return inaccessibleInfo;
    }

    private InaccessibleDatastoreInfo.InaccessibleReason getInaccessibleReason(MountInfo mountInfo) {
        InaccessibleDatastoreInfo.InaccessibleReason reason = null;
        String inaccessibleReason = mountInfo.getInaccessibleReason();
        if (inaccessibleReason != null && !"".equals(inaccessibleReason)) {
            MountInfo.InaccessibleReason mountInfoInaccessibleReason = Enum.valueOf(MountInfo.InaccessibleReason.class, mountInfo.getInaccessibleReason());
            switch (mountInfoInaccessibleReason) {
                case AllPathsDown_Start: {
                    reason = InaccessibleDatastoreInfo.InaccessibleReason.APD_DETECTED;
                    break;
                }
                case AllPathsDown_Timeout: {
                    reason = InaccessibleDatastoreInfo.InaccessibleReason.APD_TIMEOUT;
                    break;
                }
                case PermanentDeviceLoss: {
                    reason = InaccessibleDatastoreInfo.InaccessibleReason.PDL;
                }
            }
        }
        return reason;
    }
}

