/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.rp.RpTreeObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.Validate;

public class RpTreeSerDes {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(MorTree<ManagedObjectReference, RpInfo> rpTree) throws Exception {
        Validate.notNull(rpTree);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(byteOutputStream);){
            outputStream.writeObject(rpTree);
        }
        byte[] rpTreeBytes = byteOutputStream.toByteArray();
        return rpTreeBytes;
    }

    public MorTree<ManagedObjectReference, RpInfo> deserialize(byte[] rpTreeBytes) throws Exception {
        MorTree rpTree;
        if (rpTreeBytes == null || rpTreeBytes.length == 0) {
            throw new IllegalArgumentException("rpTreeBytes must not be null or empty");
        }
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(rpTreeBytes);
        try (RpTreeObjectInputStream inputStream = new RpTreeObjectInputStream(byteInputStream);){
            rpTree = (MorTree)inputStream.readObject();
        }
        return rpTree;
    }
}

