/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.create;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.GroupInfo;
import com.vmware.vim.binding.vim.cluster.HostGroup;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.cluster.VmGroup;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vsphere.client.cluster.rules.RuleInfoEx;
import com.vmware.vsphere.client.cluster.rules.RuleMemberInfo;
import com.vmware.vsphere.client.cluster.rules.RulesData;
import com.vmware.vsphere.client.cluster.rules.impl.ClusterRuleSpecValidator;
import com.vmware.vsphere.client.clusterui.model.VcCapability;
import com.vmware.vsphere.client.clusterui.model.create.CreateClusterConfig;
import com.vmware.vsphere.client.clusterui.model.create.EvcData;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.clusterui.util.VcCapabilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;

public class ClusterPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ClusterPropertyProvider.class);
    private static final String NEW_UNIQUE_CLUSTER_NAME = "newUniqueClusterName";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String QUICKSTART_EXTENSION_POINT_ID = "vsphere.core.cluster.quickstart";
    static final String GROUPS = "ClusterComputeResource/configurationEx/group";
    private static final String[] VIRTUAL_MACHINES = new String[]{VirtualMachine.class.getSimpleName()};
    private static final String[] HOSTS = new String[]{HostSystem.class.getSimpleName()};
    private static final String[] CLUSTERS = new String[]{ClusterComputeResource.class.getSimpleName()};
    private final QueryExecutor _queryExecutor;
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;
    private final ExtensionService _extensionService;

    public ClusterPropertyProvider(DataService dataService, ObjectReferenceService objectReferenceService, QueryExecutor queryExecutor, QueryServiceFactory queryServiceFactory, ExtensionService extensionService) {
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
        this._queryExecutor = queryExecutor;
        this._queryService = queryServiceFactory.getQueryService();
        this._extensionService = extensionService;
    }

    @type(value="ClusterComputeResource")
    public GroupInfo[] getGroupsData(ManagedObjectReference clusterRef, String filterText) {
        LinkedMultiValueMap vmMembers = new LinkedMultiValueMap();
        LinkedMultiValueMap hostMembers = new LinkedMultiValueMap();
        GroupInfo[] groups = this.getGroupInfos(clusterRef);
        if (StringUtils.isNotEmpty((CharSequence)filterText)) {
            HashSet<GroupInfo> filteredGroups = new HashSet<GroupInfo>();
            for (GroupInfo group : groups) {
                VmGroup vmGroup;
                ManagedObjectReference[] vms;
                if (StringUtils.containsIgnoreCase((CharSequence)group.name, (CharSequence)filterText)) {
                    filteredGroups.add(group);
                    continue;
                }
                if (group instanceof HostGroup) {
                    HostGroup hostGroup = (HostGroup)group;
                    ManagedObjectReference[] hosts = hostGroup.getHost();
                    if (hosts == null) continue;
                    for (ManagedObjectReference host : hosts) {
                        hostMembers.add((Object)host, (Object)group);
                    }
                    continue;
                }
                if (!(group instanceof VmGroup) || (vms = (vmGroup = (VmGroup)group).getVm()) == null) continue;
                for (ManagedObjectReference vm : vms) {
                    vmMembers.add((Object)vm, (Object)group);
                }
            }
            if (!vmMembers.isEmpty()) {
                List<ManagedObjectReference> filteredVms = this.filterByName(filterText, vmMembers.keySet(), VIRTUAL_MACHINES);
                for (ManagedObjectReference vm : filteredVms) {
                    filteredGroups.addAll((Collection)vmMembers.get((Object)vm));
                }
            }
            if (!hostMembers.isEmpty()) {
                List<ManagedObjectReference> filteredHosts = this.filterByName(filterText, hostMembers.keySet(), HOSTS);
                for (ManagedObjectReference host : filteredHosts) {
                    filteredGroups.addAll((Collection)hostMembers.get((Object)host));
                }
            }
            groups = filteredGroups.toArray(new GroupInfo[0]);
        }
        return groups;
    }

    private GroupInfo[] getGroupInfos(ManagedObjectReference clusterRef) {
        ResultSet groupsResultSet = this._queryService.select(new String[]{GROUPS}).from(CLUSTERS).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef)}).opId("get-cluster-groups").fetch();
        List resourceItem = groupsResultSet.getItems();
        GroupInfo[] result = CollectionUtils.isNotEmpty((Collection)resourceItem) ? (GroupInfo[])((ResourceItem)resourceItem.get(0)).get(GROUPS) : new GroupInfo[]{};
        return result;
    }

    private List<ManagedObjectReference> filterByName(String filterText, Set<ManagedObjectReference> objects, String[] targetTypes) {
        ResultSet filteredVmsResultSet;
        List resourceItems;
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        if (CollectionUtils.isNotEmpty(objects) && !(resourceItems = (filteredVmsResultSet = this._queryService.select(new String[]{"@modelKey"}).from(targetTypes).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects), PropertyPredicate.containsIgnoreCase((String)"name", (String)filterText)}).opId("search-groups-by-member-names").fetch()).getItems()).isEmpty()) {
            for (ResourceItem vmItem : resourceItems) {
                filteredObjects.add((ManagedObjectReference)vmItem.get("@modelKey"));
            }
        }
        return filteredObjects;
    }

    @type(value="Folder,Datacenter")
    public CreateClusterConfig getCreateClusterConfig(ManagedObjectReference mor) {
        CreateClusterConfig config = new CreateClusterConfig();
        config.uniqueName = this.getClusterUniqueName(mor);
        VcCapability vcCapability = VcCapabilityUtil.getCapability(this._queryService, mor.getServerGuid());
        if (vcCapability != null) {
            config.evcModes = this.getEvcModes(vcCapability.capability);
            config.hciWorkflowSupported = vcCapability.capability.hciWorkflowSupported;
            config.vsanMaxSupported = vcCapability.vsanMaxSupported;
        }
        return config;
    }

    @type(value="Folder,Datacenter")
    public CreateClusterConfig getCreateClusterWizardConfig(ManagedObjectReference mor) {
        CreateClusterConfig config = new CreateClusterConfig();
        config.uniqueName = this.getClusterUniqueName(mor);
        VcCapability vcCapability = VcCapabilityUtil.getCapability(this._queryService, mor.getServerGuid());
        if (vcCapability != null) {
            config.hciWorkflowSupported = vcCapability.capability.hciWorkflowSupported;
            config.lifecycleManagementSupported = vcCapability.capability.lifecycleManagementSupported;
            config.hostSeedingSupported = vcCapability.capability.hostSeedingSupported;
            config.configManagerSupported = vcCapability.capability.configMgmtSupported;
            config.vsanMaxSupported = vcCapability.vsanMaxSupported;
        }
        return config;
    }

    @type(value="ClusterComputeResource")
    public RulesData getRulesData(ManagedObjectReference clusterRef) throws Exception {
        ClusterRuleSpecValidator validator = new ClusterRuleSpecValidator(this._dataService, this._objectReferenceService, clusterRef, null);
        RuleInfoEx[] ruleInfoExes = validator.getConflictsForExistingRules();
        ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>(ruleInfoExes.length);
        for (RuleInfoEx ruleInfoEx : ruleInfoExes) {
            ruleInfos.add(ruleInfoEx.rule);
        }
        RulesData rulesData = new RulesData(ruleInfoExes, ruleInfos.toArray(new RuleInfo[0]), validator.getRuleMemberInfo().values().toArray(new RuleMemberInfo[0]));
        return rulesData;
    }

    @type(value="ClusterComputeResource")
    public boolean getHciWorkflowEnabled(ManagedObjectReference clusterRef) {
        Map<String, Object[]> filterContext = Collections.singletonMap(CONTEXT_OBJECTS, new Object[]{clusterRef});
        List hostExtensionObjects = this._extensionService.getExtensionObjects(QUICKSTART_EXTENSION_POINT_ID, filterContext, false);
        return hostExtensionObjects != null && !hostExtensionObjects.isEmpty();
    }

    private String getClusterUniqueName(ManagedObjectReference mor) {
        try {
            return (String)this._queryExecutor.getProperty((Object)mor, NEW_UNIQUE_CLUSTER_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Can't return cluster unique name.", (Throwable)e);
            return "";
        }
    }

    private EvcData[] getEvcModes(Capability capability) {
        ArrayList<EvcData> amdEvcData = new ArrayList<EvcData>();
        ArrayList<EvcData> intelEvcData = new ArrayList<EvcData>();
        Object[] evcModes = capability.supportedEVCMode;
        if (ArrayUtils.isEmpty((Object[])evcModes)) {
            return new EvcData[0];
        }
        for (Object mode : evcModes) {
            EvcData evcData = this.createEvcData((EVCMode)mode);
            if (CpuPackage.Vendor.amd.toString().equals(((EVCMode)mode).vendor)) {
                amdEvcData.add(evcData);
                continue;
            }
            if (!CpuPackage.Vendor.intel.toString().equals(((EVCMode)mode).vendor)) continue;
            intelEvcData.add(evcData);
        }
        ArrayList<EvcData> result = new ArrayList<EvcData>();
        result.addAll(amdEvcData);
        result.addAll(intelEvcData);
        return result.toArray(new EvcData[0]);
    }

    private EvcData createEvcData(EVCMode mode) {
        EvcData data = new EvcData();
        data.key = mode.key;
        data.description = mode.summary;
        data.label = mode.label;
        if (CpuPackage.Vendor.amd.toString().equals(mode.vendor)) {
            data.category = Util.getLocalizedString("evc.config.enableEvcAmdLabel", new String[0]);
        } else if (CpuPackage.Vendor.intel.toString().equals(mode.vendor)) {
            data.category = Util.getLocalizedString("evc.config.enableEvcIntelLabel", new String[0]);
        }
        return data;
    }
}

