/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.configuration;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.configuration.EvcConfigData;
import com.vmware.vsphere.client.clusterui.model.configuration.HostNameData;
import com.vmware.vsphere.client.clusterui.util.VmOverridesUtil;
import java.util.ArrayList;

@QueryBinding(value="ClusterComputeResource")
public class EditEvcConfigData
extends EvcConfigData {
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/host"})
    public HostNameData[] hosts;

    public EVCMode[] getSupportedAmdEvcMode() {
        return this.getSupportedEvcModeForVendor(CpuPackage.Vendor.amd);
    }

    public EVCMode[] getSupportedIntelEvcMode() {
        return this.getSupportedEvcModeForVendor(CpuPackage.Vendor.intel);
    }

    private EVCMode[] getSupportedEvcModeForVendor(CpuPackage.Vendor vendor) {
        ArrayList<EVCMode> result = new ArrayList<EVCMode>();
        if (this.supportedEvcModes != null) {
            for (EVCMode mode : this.supportedEvcModes) {
                if (!vendor.name().equalsIgnoreCase(mode.vendor)) continue;
                result.add(mode);
            }
        }
        return result.toArray(new EVCMode[0]);
    }

    public boolean getFtDrsWithoutEvcSupported() {
        ManagedObjectReference mor = (ManagedObjectReference)this.provider;
        return VmOverridesUtil.getFtDrsWithoutEvcSupported(mor);
    }
}

