/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.cluster.ResourceUsageSummary;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.ResourcePoolCpuQuickStats;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterCpuUtilizationData {
    @Property(value="ClusterComputeResource/isVclsEnabled")
    public boolean isVclsEnabled;
    @Property(value="ClusterComputeResource/resourceUsage")
    ResourceUsageSummary resourceUsage;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/resourcePool"})
    ResourcePoolCpuQuickStats resourcePool;
    @Property(value="ClusterComputeResource/systemVmCpuConsumptionMhz")
    protected long systemVmCpuConsumptionMhz;

    public String getVmConsumptionFormatted() {
        return Util.getCpuFrequencyFormatted(this.systemVmCpuConsumptionMhz);
    }

    public double getVclsCpuConsumedPercentage() {
        return Util.getPercentageValue(this.systemVmCpuConsumptionMhz, this.resourceUsage.cpuCapacityMHz);
    }

    public String getCpuCapacityFormatted() {
        return Util.getCpuFrequencyFormatted(Long.valueOf(this.resourceUsage.cpuCapacityMHz));
    }

    public String getCpuConsumedFormatted() {
        return Util.getCpuFrequencyFormatted(this.resourcePool.consumedCpu);
    }

    public String getCpuActiveFormatted() {
        return Util.getCpuFrequencyFormatted(this.resourcePool.activeCpu);
    }

    public double getCpuConsumedPercentage() {
        return this.resourcePool != null && this.resourceUsage != null && this.resourcePool.consumedCpu != null ? Util.getPercentageValue(this.resourcePool.consumedCpu, this.resourceUsage.cpuCapacityMHz) : 0.0;
    }

    public double getCpuActivePercentage() {
        return this.resourcePool != null && this.resourceUsage != null && this.resourcePool.activeCpu != null ? Util.getPercentageValue(this.resourcePool.activeCpu, this.resourceUsage.cpuCapacityMHz) : 0.0;
    }
}

