/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.cluster.ResourceUsageSummary;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.ResourcePoolMemoryQuickStats;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterMemoryUtilizationData {
    @Property(value="ClusterComputeResource/isVclsEnabled")
    public boolean isVclsEnabled;
    @Property(value="ClusterComputeResource/resourceUsage")
    protected ResourceUsageSummary resourceUsage;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/resourcePool"})
    protected ResourcePoolMemoryQuickStats resourcePool;
    @Property(value="ClusterComputeResource/systemVmMemConsumptionMb")
    protected long systemVmMemConsumptionMb;

    public String getVmConsumptionFormatted() {
        return Util.getMbMemoryFormatted(this.systemVmMemConsumptionMb);
    }

    public double getVclsMemoryConsumedPercentage() {
        return Util.getPercentageValue(this.systemVmMemConsumptionMb, this.resourceUsage.memCapacityMB);
    }

    public String getMemoryCapacityFormatted() {
        return Util.getMbMemoryFormatted(Long.valueOf(this.resourceUsage.memCapacityMB));
    }

    public String getMemoryOverheadFormatted() {
        return Util.getMbMemoryFormatted(this.resourcePool.overheadMemory);
    }

    public String getMemoryConsumedFormatted() {
        return Util.getMbMemoryFormatted(this.resourcePool.consumedMemory);
    }

    public double getMemoryOverheadPercentage() {
        return Util.getPercentageValue(this.resourcePool.overheadMemory, this.resourceUsage.memCapacityMB);
    }

    public double getMemoryConsumedPercentage() {
        return Util.getPercentageValue(this.resourcePool.consumedMemory, this.resourceUsage.memCapacityMB);
    }
}

