/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.ResourcePoolCpuQuickStats;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="HostSystem")
public class HostCpuUtilizationData {
    @Property(value="HostSystem/totalCpuCapacity")
    long totalCpuCapacity;
    @NestedQueryBinding
    @Relationship(value={"HostSystem/rootRp"})
    ResourcePoolCpuQuickStats resourcePool;

    public String getCpuCapacityFormatted() {
        return Util.getCpuFrequencyFormatted(this.totalCpuCapacity);
    }

    public String getCpuConsumedFormatted() {
        return this.resourcePool != null && this.resourcePool.consumedCpu != null ? Util.getCpuFrequencyFormatted(this.resourcePool.consumedCpu) : "";
    }

    public String getCpuActiveFormatted() {
        return this.resourcePool != null && this.resourcePool.activeCpu != null ? Util.getCpuFrequencyFormatted(this.resourcePool.activeCpu) : "";
    }

    public double getCpuConsumedPercentage() {
        return this.resourcePool != null && this.resourcePool.consumedCpu != null ? Util.getPercentageValue(this.resourcePool.consumedCpu, this.totalCpuCapacity) : 0.0;
    }

    public double getCpuActivePercentage() {
        return this.resourcePool != null && this.resourcePool.activeCpu != null ? Util.getPercentageValue(this.resourcePool.activeCpu, this.totalCpuCapacity) : 0.0;
    }
}

