/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.ResourcePoolMemoryQuickStats;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="HostSystem")
public class HostMemoryUtilizationData {
    @Property(value="HostSystem/summary/hardware/memorySize")
    protected long memorySize;
    @NestedQueryBinding
    @Relationship(value={"HostSystem/rootRp"})
    protected ResourcePoolMemoryQuickStats resourcePool;

    public String getMemoryCapacityFormatted() {
        return Util.getMbMemoryFormatted(this.getMemorySizeMb());
    }

    public String getMemoryOverheadFormatted() {
        return Util.getMbMemoryFormatted(this.resourcePool.overheadMemory);
    }

    public String getMemoryConsumedFormatted() {
        return Util.getMbMemoryFormatted(this.resourcePool.consumedMemory);
    }

    public double getMemoryOverheadPercentage() {
        return Util.getPercentageValue(this.resourcePool.overheadMemory, this.getMemorySizeMb());
    }

    public double getMemoryConsumedPercentage() {
        return Util.getPercentageValue(this.resourcePool.consumedMemory, this.getMemorySizeMb());
    }

    private long getMemorySizeMb() {
        return this.memorySize / 0x100000L;
    }
}

