/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateConfigProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(CertificateConfigProvider.class);
    private final DataService _dataService;
    private LegacyAuthorizationService _authService;
    private static final String CERTIFICATE_STATUS = "certificateStatus";
    private static final String CERTIFICATE_SUBJECT = "certificateSubject";
    private static final String CERTIFICATE_ISSUER = "certificateIssuer";
    private static final String CERTIFICATE_START = "certificateValidFrom";
    private static final String CERTIFICATE_EXPIRY = "certificateValidTo";
    private final String[] CERT_PROPS = new String[]{"certificateSubject", "certificateIssuer", "certificateValidFrom", "certificateValidTo", "certificateStatus"};

    public CertificateConfigProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public void setAuthorizationService(LegacyAuthorizationService authService) {
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getCertificateConfig(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] propValues;
        if (hostRef == null) {
            _logger.error((Object)"Hostref cannot be null.");
            return null;
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        ManagedObjectReference certRef = hs.getConfigManager().getCertificateManager();
        if (certRef != null && (propValues = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])this.CERT_PROPS)) != null && propValues.length > 0) {
            for (PropertyValue pv : propValues) {
                if ((!(pv.value instanceof String) || !StringUtils.isNotEmpty((CharSequence)((String)pv.value))) && !(pv.value instanceof Date) && !(pv.value instanceof Calendar)) continue;
                list.add(new NameValuePair(pv.propertyName, pv.value));
            }
        }
        DynamicObject result = new DynamicObject();
        result.properties = new NameValuePair[list.size()];
        result.properties = list.toArray(result.properties);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="certificateConfig.@info.immutable")
    public boolean getPowerConfigHardwareImmutable(ManagedObjectReference hostRef) {
        return !this.isHostConnected(hostRef) || !this.hasCertificateMgmtPermission(hostRef);
    }

    private boolean isHostConnected(ManagedObjectReference hostRef) {
        boolean connected = false;
        try {
            HostSystem.ConnectionState connectionState = Util.getConnectionStateForHost(hostRef, this._dataService);
            connected = connectionState == HostSystem.ConnectionState.connected;
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception caught when getting host connection state of " + hostRef.getValue()), (Throwable)ex);
        }
        return connected;
    }

    private boolean hasCertificateMgmtPermission(ManagedObjectReference hostRef) {
        boolean permitted = false;
        VcService vcService = VimSessionUtil.getService((String)hostRef.getServerGuid());
        ManagedObjectReference siRef = vcService.getServiceInstance()._getRef();
        try {
            permitted = this._authService.checkPrivileges(new ManagedObjectReference[]{siRef}, new String[]{"Certificate.Manage"});
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception caught when checking certificate permissions for " + hostRef.getValue()), (Throwable)ex);
        }
        return permitted;
    }
}

