/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.AssignableHardwareConfig;
import com.vmware.vim.binding.vim.host.AssignableHardwareManager;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.PciPassthruConfig;
import com.vmware.vim.binding.vim.host.PciPassthruSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.config.AssignableHardwareData;
import com.vmware.vsphere.client.host.config.PciPassthruUpdateSpec;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PciPassthruMutationProvider
implements MutationProvider {
    private static final String PASSTROUGH_INSTANCE_ID = "pcipassthru-%s-%s-%s";
    private static final String CUSTOM_LABEL = "customLabel";
    private static final Log _logger = LogFactory.getLog(PciPassthruMutationProvider.class);

    public OperationResult apply(ManagedObjectReference hostSystemRef, PciPassthruUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostSystemRef;
        try {
            PciPassthruSystem system;
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            if (host == null) {
                throw new NullPointerException("Host could not be found");
            }
            ConfigManager configMgr = host.getConfigManager();
            if (configMgr == null) {
                throw new NullPointerException("Config manager was null");
            }
            Object[] assignableHardwareData = spec.assignableHardwareData;
            if (ArrayUtils.isNotEmpty((Object[])assignableHardwareData)) {
                if (spec.assignHwPciConfigSupported) {
                    this.setHardwareLabel(spec.configs, (AssignableHardwareData[])assignableHardwareData);
                } else {
                    ManagedObjectReference assignableHwMgrMor = configMgr.getAssignableHardwareManager();
                    if (assignableHwMgrMor == null) {
                        throw new NullPointerException("AssignableHardwareManager mor could not be null");
                    }
                    AssignableHardwareManager assignableHwMgr = (AssignableHardwareManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)assignableHwMgrMor);
                    if (assignableHwMgr == null) {
                        throw new NullPointerException("AssignableHardwareManager could not be null");
                    }
                    ArrayList<AssignableHardwareConfig.AttributeOverride> attributeOverrideValues = new ArrayList<AssignableHardwareConfig.AttributeOverride>(assignableHardwareData.length);
                    for (Object assignableHwData : assignableHardwareData) {
                        if (assignableHwData == null) continue;
                        AssignableHardwareConfig.AttributeOverride attribute = new AssignableHardwareConfig.AttributeOverride();
                        attribute.setInstanceId(PciPassthruMutationProvider.getInstanceId((AssignableHardwareData)assignableHwData));
                        attribute.setName(CUSTOM_LABEL);
                        String assHardwareValueTrimmed = ((AssignableHardwareData)assignableHwData).assignableHwValue.trim().replaceAll("\\s+", " ");
                        String assHardwareValue = assHardwareValueTrimmed.isEmpty() ? null : assHardwareValueTrimmed;
                        attribute.setValue((Object)assHardwareValue);
                        attributeOverrideValues.add(attribute);
                    }
                    AssignableHardwareConfig assignableHwConfig = new AssignableHardwareConfig();
                    assignableHwConfig.setAttributeOverride(attributeOverrideValues.toArray(new AssignableHardwareConfig.AttributeOverride[0]));
                    assignableHwMgr.updateConfig(assignableHwConfig);
                }
            }
            if ((system = (PciPassthruSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configMgr.getPciPassthruSystem())) == null) {
                throw new NullPointerException("PciPassthruSystem was null");
            }
            if (spec == null || spec.configs == null) {
                throw new NullPointerException("PciPassthuUpdateSpec or member was null");
            }
            system.updatePassthruConfig(spec.configs);
            system.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception when trying to update the PciConfiguration.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private static String getInstanceId(AssignableHardwareData assignableHwData) {
        return String.format(PASSTROUGH_INSTANCE_ID, PciPassthruMutationProvider.addLeadingZeroesToHexString(assignableHwData.vendorId), PciPassthruMutationProvider.addLeadingZeroesToHexString(assignableHwData.deviceId), assignableHwData.id).toLowerCase();
    }

    private static String addLeadingZeroesToHexString(String str) {
        if (str.length() == 6) {
            return str;
        }
        String leadingZeroes = null;
        switch (str.length()) {
            case 5: {
                leadingZeroes = "0";
                break;
            }
            case 4: {
                leadingZeroes = "0x";
                break;
            }
            case 3: {
                leadingZeroes = "0x0";
                break;
            }
            case 2: {
                leadingZeroes = "0x00";
                break;
            }
            case 1: {
                leadingZeroes = "0x000";
                break;
            }
        }
        return leadingZeroes.concat(str);
    }

    private void setHardwareLabel(PciPassthruConfig[] configs, AssignableHardwareData[] assignableHardwareData) {
        if (assignableHardwareData != null) {
            block0: for (AssignableHardwareData item : assignableHardwareData) {
                if (item == null) continue;
                for (int i = 0; i < configs.length; ++i) {
                    PciPassthruConfig pciConfig = configs[i];
                    if (!pciConfig.getId().equals(item.id)) continue;
                    pciConfig.setHardwareLabel(item.assignableHwValue);
                    continue block0;
                }
            }
        }
    }
}

