/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.SgxRegistrationInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.host.model.HostHardwareData;
import org.apache.commons.lang.StringUtils;

@QueryBinding(value="HostSystem")
public class HostSgxData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/hardware/sgxInfo/totalEpcMemory")
    public Long sgxTotalEpcMemory;
    @Property(value="HostSystem/hardware/sgxInfo/flcMode")
    public String sgxFlcMode;
    @Property(value="HostSystem/hardware/sgxInfo/lePubKeyHash")
    public String sgxKey;
    @Property(value="HostSystem/hardware/sgxInfo/registrationInfo")
    public SgxRegistrationInfo registrationInfo;

    public String getSgxUsedEpcMemory() throws Exception {
        ManagedObjectReference hostSystemRef = (ManagedObjectReference)this.provider;
        if (hostSystemRef == null) {
            return null;
        }
        HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
        long freeEpcSize = hs.retrieveFreeEpcMemory();
        long usedEpcSize = this.sgxTotalEpcMemory - freeEpcSize;
        return HostHardwareData.formatDataSize(usedEpcSize, 1L);
    }

    public String getSgxTotalEpcMemoryText() {
        if (this.sgxTotalEpcMemory == null) {
            return HostHardwareData.formatDataSize(0, 0x100000L);
        }
        return HostHardwareData.formatDataSize(this.sgxTotalEpcMemory, 1L);
    }

    public String getSgxFlcModeText() {
        return StringUtils.capitalize((String)this.sgxFlcMode);
    }
}

