/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class DatastoreListDerivedPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String DATASTORE_CONGESTION_THRESHOLD_MODE = "congestionThresholdModeLabel";
    private static final String DATASTORE_PROVISIONED_SPACE_FORMATTED = "provisionedSpaceFormatted";
    private static final String ACCESS_FORMATTED = "accessFormatted";
    private static final String SUMMARY = "summary";
    private static final String STORAGE_IORM_SUPPORTED = "capability.storageIORMSupported";
    private static final String IORM_CONFIG = "iormConfiguration";
    private static final String ACCESSIBLE_HOSTS_COUNT = "host._length";

    public DatastoreListDerivedPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{DATASTORE_CONGESTION_THRESHOLD_MODE, DATASTORE_PROVISIONED_SPACE_FORMATTED, ACCESS_FORMATTED};
        ti.derivedProperties = new DerivedPropertyInfo[]{DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_CONGESTION_THRESHOLD_MODE, new String[]{STORAGE_IORM_SUPPORTED, IORM_CONFIG}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(DATASTORE_PROVISIONED_SPACE_FORMATTED, new String[]{SUMMARY}), DatastoreListDerivedPropertyProviderAdapter.newDerivedPropertyInfo(ACCESS_FORMATTED, new String[]{ACCESSIBLE_HOSTS_COUNT})};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = obj;
            resultItem.properties = this.computePropertyValues(reqPropSet, sourcePropertyValuesMap, obj);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computePropertyValues(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD_MODE)) {
            this.processCongestionThresholdMode(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE_FORMATTED)) {
            this.processProvisionedSpace(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(ACCESS_FORMATTED)) {
            this.processAccessFormatted(propertyValuesMap, result, resourceObject);
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private void processCongestionThresholdMode(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Boolean siocSupported = (Boolean)propertyValuesMap.get(STORAGE_IORM_SUPPORTED);
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)propertyValuesMap.get(IORM_CONFIG);
        if (!siocSupported.booleanValue() || config != null && !config.enabled) {
            String na = I18nUtil.getLocalizedString("congestionThresholdMode.na");
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, na, resourceObject));
            return;
        }
        if (StorageResourceManager.CongestionThresholdMode.automatic.name().equals(config.congestionThresholdMode)) {
            String percentOfPeakThroughput = config.percentOfPeakThroughput.toString();
            String automatic = I18nUtil.getLocalizedString("congestionThresholdMode.automatic", new String[]{percentOfPeakThroughput});
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, automatic, resourceObject));
            return;
        }
        String manual = I18nUtil.getLocalizedString("congestionThresholdMode.manual");
        propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, manual, resourceObject));
    }

    private void processProvisionedSpace(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Datastore.Summary summary = (Datastore.Summary)propertyValuesMap.get(SUMMARY);
        long provisionedSpace = summary.capacity - summary.freeSpace;
        if (summary.accessible && summary.uncommitted != null) {
            provisionedSpace += summary.uncommitted.longValue();
        }
        String provisionedSpaceFormatted = FormatUtil.getStorageFormatted((Long)provisionedSpace, (long)1L, (long)-1L);
        propValues.add(this.createPropValue(DATASTORE_PROVISIONED_SPACE_FORMATTED, provisionedSpaceFormatted, resourceObject));
    }

    private void processAccessFormatted(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        int accessableHostsCount = (Integer)propertyValuesMap.get(ACCESSIBLE_HOSTS_COUNT);
        String accessFormatted = accessableHostsCount > 1 ? I18nUtil.getLocalizedString("datastore.access.multiple") : I18nUtil.getLocalizedString("datastore.access.single");
        propValues.add(this.createPropValue(ACCESS_FORMATTED, accessFormatted, resourceObject));
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String propertyName, String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = propertyName;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }
}

