/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.storage.PathCountInfo;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class DatastorePathsPropertyProvider
implements PropertyProviderBean {
    private static final String RESOURCE_BUNDLE_NAME = "StorageService";
    private static final int INVALID_NUMBER_OF_PATHS = -1;

    @type(value="Datastore")
    public PathCountInfo getPathCount(ManagedObjectReference dsRef, ManagedObjectReference hostRef) throws Exception {
        PathCountInfo result = new PathCountInfo();
        DatastorePathsPropertyProvider.initializePathCount(result, -1);
        VmfsVolume vmfs = this.getVmfsVolume(dsRef);
        if (vmfs == null) {
            return result;
        }
        StorageSystem storageSystem = this.getStorageSystem(hostRef);
        StorageDeviceInfo storageDeviceInfo = storageSystem.getStorageDeviceInfo();
        MultipathStateInfo multipathStateInfo = null;
        HashSet<String> pathsSet = new HashSet<String>();
        Hashtable<String, ScsiLun> scsiLuns = new Hashtable<String, ScsiLun>();
        for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
            scsiLuns.put(scsiLun.key, scsiLun);
        }
        DatastorePathsPropertyProvider.initializePathCount(result, 0);
        for (ScsiLun scsiLun : vmfs.extent) {
            MultipathInfo.LogicalUnit lu = DatastorePathsPropertyProvider.getMPLogicalUnit(storageDeviceInfo, scsiLun.diskName, scsiLuns);
            if (lu == null) {
                if (multipathStateInfo == null && (multipathStateInfo = storageSystem.getMultipathStateInfo()) == null) continue;
                DatastorePathsPropertyProvider.addNonNmpExtentPaths(result, pathsSet, storageDeviceInfo, (ScsiDisk.Partition)scsiLun, multipathStateInfo, scsiLuns);
                continue;
            }
            DatastorePathsPropertyProvider.addNmpExtentPaths(lu, result, pathsSet);
        }
        return result;
    }

    private static void updatePathsCount(PathCountInfo pathCountInfo, Set<String> pathsSet, String pathKey, String state) {
        if (pathsSet.contains(pathKey)) {
            return;
        }
        pathsSet.add(pathKey);
        ++pathCountInfo.totalNumberOfPaths;
        if (state.equals(MultipathInfo.PathState.dead.toString())) {
            ++pathCountInfo.brokenNumberOfPaths;
        } else if (state.equals(MultipathInfo.PathState.disabled.toString())) {
            ++pathCountInfo.disabledNumberOfPaths;
        }
    }

    private VmfsVolume getVmfsVolume(ManagedObjectReference dsRef) throws Exception {
        Datastore ds = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsRef);
        if (ds == null) {
            String errorMessage = this.getLocalizedString("error.invalidDatastore");
            throw new IllegalArgumentException(errorMessage);
        }
        Datastore.Info dsInfo = ds.getInfo();
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            return null;
        }
        return ((VmfsDatastoreInfo)dsInfo).vmfs;
    }

    private StorageSystem getStorageSystem(ManagedObjectReference hostRef) throws Exception {
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        if (host == null) {
            String errorMessage = this.getLocalizedString("error.invalidHost");
            throw new IllegalArgumentException(errorMessage);
        }
        ConfigManager cfgManager = host.getConfigManager();
        ManagedObjectReference storageSystemRef = cfgManager.getStorageSystem();
        return (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)storageSystemRef);
    }

    private static void addNonNmpExtentPaths(PathCountInfo pathCountInfo, Set<String> pathsSet, StorageDeviceInfo storageDeviceInfo, ScsiDisk.Partition partition, MultipathStateInfo multipathStateInfo, Map<String, ScsiLun> scsiLuns) {
        PlugStoreTopology.Device pstDevice = null;
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.device) {
            ScsiLun lun = scsiLuns.get(device.lun);
            if (lun == null || !lun.canonicalName.equals(partition.diskName)) continue;
            pstDevice = device;
            break;
        }
        if (pstDevice == null) {
            return;
        }
        block1: for (String string : pstDevice.path) {
            for (PlugStoreTopology.Path plugPath : storageDeviceInfo.plugStoreTopology.path) {
                if (!string.equals(plugPath.key)) continue;
                MultipathStateInfo.Path multiPath = DatastorePathsPropertyProvider.findMultipath(multipathStateInfo, plugPath.name);
                if (multiPath == null) continue block1;
                DatastorePathsPropertyProvider.updatePathsCount(pathCountInfo, pathsSet, plugPath.key, multiPath.pathState);
                continue block1;
            }
        }
    }

    private static void addNmpExtentPaths(MultipathInfo.LogicalUnit lu, PathCountInfo pathCountInfo, Set<String> pathsSet) {
        for (MultipathInfo.Path path : lu.path) {
            if (path.state != null) {
                DatastorePathsPropertyProvider.updatePathsCount(pathCountInfo, pathsSet, path.key, path.state);
                continue;
            }
            if (path.pathState == null) continue;
            DatastorePathsPropertyProvider.updatePathsCount(pathCountInfo, pathsSet, path.key, path.pathState);
        }
    }

    private static MultipathStateInfo.Path findMultipath(MultipathStateInfo multiPathStateInfo, String pathName) {
        for (MultipathStateInfo.Path path : multiPathStateInfo.path) {
            if (!path.name.equals(pathName)) continue;
            return path;
        }
        return null;
    }

    private static void initializePathCount(PathCountInfo pathCountInfo, int initialValue) {
        pathCountInfo.totalNumberOfPaths = initialValue;
        pathCountInfo.brokenNumberOfPaths = initialValue;
        pathCountInfo.disabledNumberOfPaths = initialValue;
    }

    private static MultipathInfo.LogicalUnit getMPLogicalUnit(StorageDeviceInfo deviceInfo, String scsiDiskName, Map<String, ScsiLun> scsiLuns) {
        if (scsiDiskName != null && deviceInfo.multipathInfo != null && deviceInfo.multipathInfo.lun != null) {
            for (MultipathInfo.LogicalUnit lu : deviceInfo.multipathInfo.lun) {
                ScsiLun lun = scsiLuns.get(lu.lun);
                if (lun == null || !scsiDiskName.equals(lun.canonicalName)) continue;
                return lu;
            }
        }
        return null;
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

