/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.maintenance.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import com.vmware.vsphere.client.storage.maintenance.DatastoreMaintenanceSpec;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreMaintenanceOpUtil {
    private static final Log _logger = LogFactory.getLog(DatastoreMaintenanceOpUtil.class);

    public static OperationResult applyMaintenanceOperation(ManagedObjectReference datastoreRef, DatastoreMaintenanceSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = datastoreRef;
        try {
            Datastore datastoreObj = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreRef);
            switch (spec.maintenanceOpType) {
                case enter: {
                    StoragePlacementResult storagePlacementResult = datastoreObj.enterMaintenanceMode();
                    result.result = storagePlacementResult;
                    result.task = storagePlacementResult.task;
                    break;
                }
                case exit: {
                    result.task = datastoreObj.exitMaintenanceMode();
                    break;
                }
                case applyRecommendations: {
                    if (spec.keys == null || spec.keys.length == 0) {
                        throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.noRecKeysToApply"));
                    }
                    StorageResourceManager storageManager = StorageUtil.getStorageManager((ManagedObjectReference)datastoreRef);
                    result.task = storageManager.applyRecommendation(spec.keys);
                    break;
                }
                default: {
                    _logger.error((Object)("Unknown datastore maintenance operation: " + spec.maintenanceOpType.toString()));
                    break;
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Couldn't perform a maintenance operation for a datastore", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

