/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.impl;

import com.vmware.vim.binding.vim.BoolPolicy;
import com.vmware.vim.binding.vim.IntPolicy;
import com.vmware.vim.binding.vim.LongPolicy;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvpg.api.DvPortgroupPortProperties;
import com.vmware.vsphere.client.dvpg.api.DvPortgroupProperties;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.NumericRangeUtil;
import com.vmware.vsphere.client.h5.network.VlanUtil;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupPropertiesData;
import com.vmware.vsphere.client.h5.network.dvportgroup.model.DvPortgroupPropertiesDvsData;
import com.vmware.vsphere.client.h5.network.dvs.ports.model.DvsPortPoliciesData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupParser {
    private static final Log _logger = LogFactory.getLog(DvPortgroupParser.class);
    private static final String LIMIT_POLICY = "allow";
    private static final int LIMIT = 4096;

    private DvPortgroupParser() {
    }

    public static DvPortgroupData getDistributedPortGroupData(String key, String switchUuid, DvPortgroupData[] dvPortgroupData) {
        if (key == null || switchUuid == null || dvPortgroupData == null || dvPortgroupData.length == 0) {
            return null;
        }
        for (DvPortgroupData portgroupData : dvPortgroupData) {
            if (!portgroupData.key.equals(key) || portgroupData.dvsPolicyData == null || !switchUuid.equals(portgroupData.dvsPolicyData.dvsUuid)) continue;
            return portgroupData;
        }
        return null;
    }

    public static DvPortgroupProperties getPortgroupProperties(DvPortgroupPropertiesData dvPortgroupPropertiesData) {
        boolean isNetIormAvailable;
        boolean isAutoExpandAvailable;
        DvPortgroupProperties dvPortgroupProperties = new DvPortgroupProperties();
        if (dvPortgroupPropertiesData == null) {
            return dvPortgroupProperties;
        }
        boolean isUplink = dvPortgroupPropertiesData.isUplink != null && dvPortgroupPropertiesData.isUplink != false;
        int niocVersion = dvPortgroupPropertiesData.niocVersion == null ? 0 : dvPortgroupPropertiesData.niocVersion;
        boolean isNetworkOffloadEnabled = dvPortgroupPropertiesData.isDvsNetworkOffloadEnabled != null && dvPortgroupPropertiesData.isDvsNetworkOffloadEnabled != false;
        dvPortgroupProperties.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)dvPortgroupPropertiesData.name);
        dvPortgroupProperties.description = dvPortgroupPropertiesData.description;
        dvPortgroupProperties.portBinding = dvPortgroupPropertiesData.type;
        boolean isPortBindingStatic = dvPortgroupPropertiesData.type != null && dvPortgroupPropertiesData.type.equals(DistributedVirtualPortgroup.PortgroupType.earlyBinding.name());
        boolean bl = isAutoExpandAvailable = isPortBindingStatic && !isUplink;
        if (isAutoExpandAvailable) {
            dvPortgroupProperties.portAllocation = dvPortgroupPropertiesData.autoExpand;
        }
        dvPortgroupProperties.numberOfPorts = dvPortgroupPropertiesData.numPorts;
        DvPortgroupPropertiesDvsData dvPortGroupDvsRelatedData = dvPortgroupPropertiesData.dvPortGroupDvsRelatedData != null ? dvPortgroupPropertiesData.dvPortGroupDvsRelatedData : new DvPortgroupPropertiesDvsData();
        boolean isVmVnicResourcePoolAvailable = !isUplink && !isNetworkOffloadEnabled && niocVersion == 3;
        boolean bl2 = isNetIormAvailable = !isUplink && !isNetworkOffloadEnabled && niocVersion == 2;
        if (isVmVnicResourcePoolAvailable) {
            dvPortgroupProperties.vmVnicResourcePoolName = DvPortgroupParser.getVmVnicNetworkResourcePoolNameForNiocV3(dvPortgroupPropertiesData.vmVnicNetworkResourcePoolKey, dvPortGroupDvsRelatedData.vmVnicNetworkResourcePool);
        } else if (isNetIormAvailable && dvPortgroupPropertiesData.policy != null) {
            dvPortgroupProperties.vmVnicResourcePoolName = DvPortgroupParser.getVmVnicNetworkResourcePoolNameForNiocV2(dvPortgroupPropertiesData.networkResourcePoolKey, dvPortGroupDvsRelatedData.networkResourcePool);
        }
        dvPortgroupProperties.isNsxPortgroup = dvPortgroupPropertiesData.isNsxPortgroup;
        dvPortgroupProperties.isDvsNetworkOffloadEnabled = isNetworkOffloadEnabled;
        if (dvPortgroupPropertiesData.isNsxPortgroup) {
            dvPortgroupProperties.transportZone = dvPortgroupPropertiesData.transportZoneName;
            dvPortgroupProperties.logicalSwitchId = dvPortgroupPropertiesData.logicalSwitchUuid;
            dvPortgroupProperties.segmentId = dvPortgroupPropertiesData.segmentId;
            if (dvPortgroupPropertiesData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
                VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfigPolicy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortgroupPropertiesData.defaultPortConfig;
                dvPortgroupProperties.vlan = DvPortgroupParser.getVlan(vmwarePortConfigPolicy, dvPortgroupPropertiesData.pvlanConfig);
                IntPolicy vni = vmwarePortConfigPolicy.getVNI();
                if (vni != null && vni.value != null && vni.value > 0) {
                    dvPortgroupProperties.vni = vni.value;
                }
            }
        }
        DvPortgroupPolicyParser.setAdvancedPortPolicies(dvPortgroupPropertiesData.policy, isUplink, isNetworkOffloadEnabled, dvPortGroupDvsRelatedData.dvsCapability, niocVersion, (DvPortgroupPortProperties)dvPortgroupProperties);
        return dvPortgroupProperties;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(DvPortgroupData dvPortGroupData) {
        if (dvPortGroupData == null || dvPortGroupData.defaultPortConfig == null) {
            return null;
        }
        HostNetworkDetailsData.PortPolicy resultPortPolicy = new HostNetworkDetailsData.PortPolicy();
        boolean isNetworkOffloadEnabled = dvPortGroupData.isDvsNetworkOffloadEnabled != null && dvPortGroupData.isDvsNetworkOffloadEnabled != false;
        resultPortPolicy.inTrafficShaping = dvPortGroupData.isUplink || isNetworkOffloadEnabled ? null : DvPortgroupParser.getTrafficShaping(dvPortGroupData.defaultPortConfig.inShapingPolicy);
        resultPortPolicy.outTrafficShaping = dvPortGroupData.isUplink || isNetworkOffloadEnabled ? null : DvPortgroupParser.getTrafficShaping(dvPortGroupData.defaultPortConfig.outShapingPolicy);
        resultPortPolicy.blocked = DvPortgroupParser.getBooleanPolicyValue(dvPortGroupData.defaultPortConfig.blocked);
        if (dvPortGroupData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortGroupData.defaultPortConfig;
            if (!dvPortGroupData.isUplink) {
                boolean isMacLearningSupported = dvPortGroupData.dvsPolicyData != null && dvPortGroupData.dvsPolicyData.macLearningSupported != null && dvPortGroupData.dvsPolicyData.macLearningSupported != false;
                resultPortPolicy.security = DvPortgroupParser.getSecurityPolicy(vmwarePortConfig, isMacLearningSupported);
                if (isMacLearningSupported) {
                    resultPortPolicy.macLearning = DvPortgroupParser.getMacLearningPolicy(vmwarePortConfig, isMacLearningSupported);
                }
            }
            VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfig = dvPortGroupData.dvsPolicyData != null ? dvPortGroupData.dvsPolicyData.pvlanMapEntry : new VmwareDistributedVirtualSwitch.PvlanMapEntry[]{};
            resultPortPolicy.vlan = DvPortgroupParser.getVlan(vmwarePortConfig, pvlanConfig);
            resultPortPolicy.monitoring = DvPortgroupParser.getBooleanPolicyValue(vmwarePortConfig.ipfixEnabled);
            String[] uplinkNames = dvPortGroupData.dvsPolicyData != null ? dvPortGroupData.dvsPolicyData.uplinkNames : null;
            String[] lags = dvPortGroupData.dvsPolicyData != null ? DvPortgroupParser.getLagNames(dvPortGroupData.dvsPolicyData.lags) : null;
            resultPortPolicy.teamingAndFailover = dvPortGroupData.isUplink ? null : DvPortgroupParser.getTeamingAndFailover(vmwarePortConfig.uplinkTeamingPolicy, uplinkNames, lags);
            VmwareDistributedVirtualSwitch.LacpFeatureCapability lacpFeatureCapability = dvPortGroupData.dvsPolicyData != null ? dvPortGroupData.dvsPolicyData.lacpCapability : null;
            resultPortPolicy.basicLacpAvailable = dvPortGroupData.isUplink && lacpFeatureCapability != null && lacpFeatureCapability.lacpSupported != false && "singleLag".equals(dvPortGroupData.dvsPolicyData.lacpVersion);
            if (resultPortPolicy.basicLacpAvailable.booleanValue()) {
                resultPortPolicy.lacp = new HostNetworkDetailsData.PortPolicy.Lacp();
                resultPortPolicy.lacp.mode = ((VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortGroupData.defaultPortConfig).lacpPolicy.mode.getValue();
                resultPortPolicy.lacp.enable = ((VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortGroupData.defaultPortConfig).lacpPolicy.enable.getValue();
            }
            resultPortPolicy.isNsxPortgroup = dvPortGroupData.isNsxPortgroup;
            if (dvPortGroupData.isNsxPortgroup && vmwarePortConfig.VNI != null && vmwarePortConfig.VNI.value != null && vmwarePortConfig.VNI.value > 0) {
                resultPortPolicy.vni = vmwarePortConfig.VNI.value;
            }
        }
        return resultPortPolicy;
    }

    public static HostNetworkDetailsData.PortPolicy getPortPolicy(DvsPortPoliciesData dvPortGroupData) {
        if (dvPortGroupData == null || dvPortGroupData.portSetting == null) {
            return null;
        }
        HostNetworkDetailsData.PortPolicy resultPortPolicy = new HostNetworkDetailsData.PortPolicy();
        resultPortPolicy.inTrafficShaping = dvPortGroupData.isUplink ? null : DvPortgroupParser.getTrafficShaping(dvPortGroupData.portSetting.inShapingPolicy);
        resultPortPolicy.outTrafficShaping = dvPortGroupData.isUplink ? null : DvPortgroupParser.getTrafficShaping(dvPortGroupData.portSetting.outShapingPolicy);
        resultPortPolicy.blocked = DvPortgroupParser.getBooleanPolicyValue(dvPortGroupData.portSetting.blocked);
        if (dvPortGroupData.portSetting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPortGroupData.portSetting;
            if (!dvPortGroupData.isUplink) {
                boolean isMacLearningSupported = dvPortGroupData.dvsPolicyData != null && dvPortGroupData.dvsPolicyData.macLearningSupported != null && dvPortGroupData.dvsPolicyData.macLearningSupported != false;
                resultPortPolicy.security = DvPortgroupParser.getSecurityPolicy(vmwarePortConfig, isMacLearningSupported);
                if (isMacLearningSupported) {
                    resultPortPolicy.macLearning = DvPortgroupParser.getMacLearningPolicy(vmwarePortConfig, isMacLearningSupported);
                }
            }
            VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfig = dvPortGroupData.dvsPolicyData != null ? dvPortGroupData.dvsPolicyData.pvlanMapEntry : new VmwareDistributedVirtualSwitch.PvlanMapEntry[]{};
            resultPortPolicy.vlan = DvPortgroupParser.getVlan(vmwarePortConfig, pvlanConfig);
            resultPortPolicy.monitoring = DvPortgroupParser.getBooleanPolicyValue(vmwarePortConfig.ipfixEnabled);
            resultPortPolicy.teamingAndFailover = dvPortGroupData.isUplink ? null : DvPortgroupParser.getTeamingAndFailover(vmwarePortConfig.uplinkTeamingPolicy, dvPortGroupData.dvsPolicyData.uplinkNames, DvPortgroupParser.getLagNames(dvPortGroupData.dvsPolicyData.lags));
        }
        return resultPortPolicy;
    }

    private static HostNetworkDetailsData.PortPolicy.TeamingAndFailover getTeamingAndFailover(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy uplinkTeamingPolicy, String[] uplinkNames, String[] lagNames) {
        HostNetworkDetailsData.PortPolicy.TeamingAndFailover teamingAndFailover = null;
        if (uplinkTeamingPolicy != null) {
            teamingAndFailover = new HostNetworkDetailsData.PortPolicy.TeamingAndFailover();
            teamingAndFailover.notifySwitches = DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.notifySwitches, false);
            boolean bl = teamingAndFailover.failback = !DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.rollingOrder, true);
            if (uplinkTeamingPolicy.failureCriteria != null) {
                teamingAndFailover.failureDetection = DvPortgroupParser.getBooleanPolicyValue(uplinkTeamingPolicy.failureCriteria.checkBeacon, false);
            }
            String string = teamingAndFailover.loadBalancing = uplinkTeamingPolicy.policy != null ? uplinkTeamingPolicy.policy.value : null;
            if (uplinkTeamingPolicy.uplinkPortOrder != null) {
                if (uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort != null) {
                    teamingAndFailover.activeAdapters = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort);
                }
                if (uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort != null) {
                    teamingAndFailover.standByAdapters = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort);
                }
            }
            List<String> uplinkNamesList = uplinkNames == null ? null : Arrays.asList(uplinkNames);
            List<String> lagNamesList = lagNames == null ? null : Arrays.asList(lagNames);
            teamingAndFailover.unusedAdapters = DvPortgroupParser.getUnusedUplinkNames(teamingAndFailover.activeAdapters, teamingAndFailover.standByAdapters, uplinkNamesList, lagNamesList);
        }
        return teamingAndFailover;
    }

    private static List<String> getUnusedUplinkNames(List<String> activeAdapters, List<String> standByAdapters, List<String> uplinkNames, List<String> lagNames) {
        ArrayList<String> unusedUplinks = new ArrayList<String>();
        ArrayList<String> allUplinkNames = new ArrayList<String>();
        if (uplinkNames != null) {
            allUplinkNames.addAll(uplinkNames);
        }
        if (lagNames != null) {
            allUplinkNames.addAll(lagNames);
        }
        for (String uplink : allUplinkNames) {
            if (activeAdapters.contains(uplink) || standByAdapters.contains(uplink)) continue;
            unusedUplinks.add(uplink);
        }
        return unusedUplinks;
    }

    public static String getVmVnicNetworkResourcePoolNameForNiocV2(String key, NetworkResourcePool[] poolsArray) {
        if (key == null || key.equals("-1")) {
            return NetworkStringUtil.getString("dvpg.policy.iorm.pool.none");
        }
        if (poolsArray != null) {
            for (NetworkResourcePool pool : poolsArray) {
                if (pool == null || pool.key == null || pool.name == null || !pool.key.equals(key)) continue;
                return pool.name;
            }
        }
        return null;
    }

    private static HostNetworkDetailsData.PortPolicy.TrafficShaping getTrafficShaping(DistributedVirtualPort.TrafficShapingPolicy shapingPolicy) {
        HostNetworkDetailsData.PortPolicy.TrafficShaping trafficShaping = null;
        if (shapingPolicy != null) {
            trafficShaping = new HostNetworkDetailsData.PortPolicy.TrafficShaping();
            trafficShaping.enabled = shapingPolicy.enabled != null && shapingPolicy.enabled.value != null ? shapingPolicy.enabled.value : false;
            if (trafficShaping.enabled.booleanValue()) {
                trafficShaping.averageBandwidthSummary = FormatUtil.getBitRateFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.averageBandwidth, 100000000L), (int)0, (long)1L, (long)1000L, (boolean)true);
                trafficShaping.burstSizeSummary = FormatUtil.getDataSizeFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.burstSize, 102400000L), (int)0, (long)1L, (long)1024L, (boolean)true);
                trafficShaping.peakBandwidthSummary = FormatUtil.getBitRateFormatted((Number)DvPortgroupParser.getLongValue(shapingPolicy.peakBandwidth, 100000000L), (int)0, (long)1L, (long)1000L, (boolean)true);
            }
        }
        return trafficShaping;
    }

    private static HostNetworkDetailsData.PortPolicy.Security getSecurityPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig, boolean isMacLearningSupported) {
        HostNetworkDetailsData.PortPolicy.Security security = new HostNetworkDetailsData.PortPolicy.Security();
        if (vmwarePortConfig == null) {
            return null;
        }
        if (isMacLearningSupported) {
            if (vmwarePortConfig.macManagementPolicy != null) {
                security.allowPromiscuous = vmwarePortConfig.macManagementPolicy.allowPromiscuous != null && vmwarePortConfig.macManagementPolicy.allowPromiscuous != false;
                security.forgedTransmits = vmwarePortConfig.macManagementPolicy.forgedTransmits != null && vmwarePortConfig.macManagementPolicy.forgedTransmits != false;
                security.macChanges = vmwarePortConfig.macManagementPolicy.macChanges != null && vmwarePortConfig.macManagementPolicy.macChanges != false;
            }
        } else if (vmwarePortConfig.securityPolicy != null) {
            security.allowPromiscuous = vmwarePortConfig.securityPolicy.allowPromiscuous != null && vmwarePortConfig.securityPolicy.allowPromiscuous.value != null && vmwarePortConfig.securityPolicy.allowPromiscuous.value != false;
            security.forgedTransmits = vmwarePortConfig.securityPolicy.forgedTransmits != null && vmwarePortConfig.securityPolicy.forgedTransmits.value != null && vmwarePortConfig.securityPolicy.forgedTransmits.value != false;
            security.macChanges = vmwarePortConfig.securityPolicy.macChanges != null && vmwarePortConfig.securityPolicy.macChanges.value != null && vmwarePortConfig.securityPolicy.macChanges.value != false;
        }
        return security;
    }

    private static HostNetworkDetailsData.PortPolicy.MacLearning getMacLearningPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig, boolean isMacLearningSupported) {
        if (vmwarePortConfig == null && vmwarePortConfig.macManagementPolicy == null && vmwarePortConfig.macManagementPolicy.macLearningPolicy == null) {
            return null;
        }
        HostNetworkDetailsData.PortPolicy.MacLearning macLearning = new HostNetworkDetailsData.PortPolicy.MacLearning();
        macLearning.macLearningSupported = isMacLearningSupported;
        macLearning.macLearningEnabled = vmwarePortConfig.macManagementPolicy.macLearningPolicy.enabled;
        macLearning.allowUnicastFlooding = vmwarePortConfig.macManagementPolicy.macLearningPolicy.allowUnicastFlooding != null ? vmwarePortConfig.macManagementPolicy.macLearningPolicy.allowUnicastFlooding : true;
        macLearning.limit = vmwarePortConfig.macManagementPolicy.macLearningPolicy.limit != null ? vmwarePortConfig.macManagementPolicy.macLearningPolicy.limit : 4096;
        macLearning.limitPolicy = vmwarePortConfig.macManagementPolicy.macLearningPolicy.limitPolicy != null ? vmwarePortConfig.macManagementPolicy.macLearningPolicy.limitPolicy : LIMIT_POLICY;
        return macLearning;
    }

    private static HostNetworkDetailsData.PortPolicy.Vlan getVlan(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePortConfig, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfig) {
        HostNetworkDetailsData.PortPolicy.Vlan vlan = new HostNetworkDetailsData.PortPolicy.Vlan();
        if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vmwarePortConfig.vlan;
            if (vlanIdSpec.vlanId == 0) {
                vlan.type = "none";
            } else {
                vlan.type = "vlan";
                vlan.value = String.valueOf(vlanIdSpec.vlanId);
            }
        } else if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            vlan.type = "trunk";
            vlan.value = NumericRangeUtil.asString((NumericRange[])((VmwareDistributedVirtualSwitch.TrunkVlanSpec)vmwarePortConfig.vlan).vlanId);
        } else if (vmwarePortConfig.vlan instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry = DvPortgroupParser.findPvlanMapEntry(pvlanConfig, ((VmwareDistributedVirtualSwitch.PvlanSpec)vmwarePortConfig.vlan).pvlanId);
            vlan.type = "private";
            vlan.value = DvPortgroupParser.parsePvlanSpec(pvlanMapEntry);
        }
        return vlan;
    }

    private static String parsePvlanSpec(VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry) {
        return pvlanMapEntry == null ? NetworkStringUtil.getString("na") : NetworkStringUtil.getString("dvpg.policy.vlan.displayFormat", VlanUtil.getPvlanTypeText((String)pvlanMapEntry.pvlanType), Integer.toString(pvlanMapEntry.primaryVlanId), Integer.toString(pvlanMapEntry.secondaryVlanId));
    }

    private static VmwareDistributedVirtualSwitch.PvlanMapEntry findPvlanMapEntry(VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntry, int pvlanId) {
        for (VmwareDistributedVirtualSwitch.PvlanMapEntry entry : pvlanMapEntry) {
            if (entry.secondaryVlanId != pvlanId) continue;
            return entry;
        }
        return null;
    }

    private static String[] getLagNames(VmwareDistributedVirtualSwitch.LacpGroupConfig[] lags) {
        if (lags == null) {
            return new String[0];
        }
        String[] lagNames = new String[lags.length];
        for (int i = 0; i < lags.length; ++i) {
            lagNames[i] = lags[i].name;
        }
        return lagNames;
    }

    private static Boolean getBooleanPolicyValue(BoolPolicy boolPolicy) {
        return boolPolicy != null ? boolPolicy.value : null;
    }

    private static boolean getBooleanPolicyValue(BoolPolicy boolPolicy, boolean defaultValue) {
        Boolean policyValue = DvPortgroupParser.getBooleanPolicyValue(boolPolicy);
        return policyValue != null ? policyValue : defaultValue;
    }

    private static Long getLongValue(LongPolicy valuePolicy, long defaultValue) {
        return valuePolicy == null || valuePolicy.value == null ? defaultValue : valuePolicy.value;
    }

    private static String getVmVnicNetworkResourcePoolNameForNiocV3(String key, VmVnicNetworkResourcePool[] poolsArray) {
        if (key != null && !key.equals("-1")) {
            if (poolsArray != null) {
                for (VmVnicNetworkResourcePool pool : poolsArray) {
                    if (pool == null || pool.key == null || pool.name == null || !pool.key.equals(key)) continue;
                    return pool.name;
                }
            }
            return NetworkStringUtil.getString("dvpg.properties.vmVnicResPool.na");
        }
        return NetworkStringUtil.getString("dvpg.properties.vmVnicResPool.default");
    }
}

