/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.manage;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.DvPortgroupPolicyParser;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgFailoverPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMiscPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMonitoringPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgResourceAllocationPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgSecurityPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgTrafficShapingPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgVlanPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.manage.model.DvpgPoliciesModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.manage.model.DvpgPolicyTypeModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.manage.model.ManageDvPortgroupsPolicyData;

public class ManageDvPortgroupsParser {
    public static DvpgPoliciesModel getPoliciesData(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        DvpgPoliciesModel policiesModel = new DvpgPoliciesModel();
        policiesModel.policyTypeModel = ManageDvPortgroupsParser.createPolicyTypeModel(manageDvpgPolicyData);
        if (policiesModel.policyTypeModel.isSecurityPolicyAvailable) {
            policiesModel.securityPolicyModel = ManageDvPortgroupsParser.createSecurityPolicyModel(manageDvpgPolicyData);
        }
        if (policiesModel.policyTypeModel.isVlanPolicyAvailable) {
            policiesModel.vlanPolicyModel = ManageDvPortgroupsParser.createVlanPolicyModel(manageDvpgPolicyData);
        }
        policiesModel.trafficShapingPolicyModel = ManageDvPortgroupsParser.createTrafficShapingPolicyModel(manageDvpgPolicyData);
        if (policiesModel.policyTypeModel.isResAllocPolicyAvailable) {
            policiesModel.resourceAllocationPolicyModel = ManageDvPortgroupsParser.createResourceAllocationPolicyModel(manageDvpgPolicyData);
        }
        if (policiesModel.policyTypeModel.isFailoverPolicyAvailable) {
            policiesModel.failoverPolicyModel = ManageDvPortgroupsParser.createFailoverPolicyModel(manageDvpgPolicyData);
        }
        if (policiesModel.policyTypeModel.isMonitoringPolicyAvailable) {
            policiesModel.monitoringPolicyModel = ManageDvPortgroupsParser.createMonitoringPolicyModel(manageDvpgPolicyData);
        }
        policiesModel.miscPolicyModel = ManageDvPortgroupsParser.createMiscPolicyModel(manageDvpgPolicyData);
        return policiesModel;
    }

    private static DvpgPolicyTypeModel createPolicyTypeModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        boolean isVmwDvs;
        DvpgPolicyTypeModel policyTypeModel = new DvpgPolicyTypeModel();
        policyTypeModel.isResAllocPolicyAvailable = manageDvpgPolicyData.featuresSupported != null && manageDvpgPolicyData.featuresSupported.networkResourceManagementSupported && (manageDvpgPolicyData.niocVersion == 2 || manageDvpgPolicyData.niocVersion == 3);
        boolean isNetworkOffloadEnabled = manageDvpgPolicyData.isNetworkOffloadEnabled != null && manageDvpgPolicyData.isNetworkOffloadEnabled != false;
        policyTypeModel.isTrafficShapingPolicyAvailable = !isNetworkOffloadEnabled;
        policyTypeModel.isTrafficFilterPolicyAvailable = false;
        boolean bl = isVmwDvs = manageDvpgPolicyData.featuresSupported != null && manageDvpgPolicyData.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability;
        if (isVmwDvs) {
            policyTypeModel.isSecurityPolicyAvailable = true;
            policyTypeModel.isFailoverPolicyAvailable = true;
            policyTypeModel.isVlanPolicyAvailable = true;
            VmwareDistributedVirtualSwitch.FeatureCapability capability = (VmwareDistributedVirtualSwitch.FeatureCapability)manageDvpgPolicyData.featuresSupported;
            policyTypeModel.isMonitoringPolicyAvailable = capability.ipfixSupported != null && capability.ipfixSupported != false;
            policyTypeModel.isMacLearningPolicyAvailable = capability.macLearningSupported != null && capability.macLearningSupported != false;
        }
        return policyTypeModel;
    }

    private static DvpgSecurityPolicyModel createSecurityPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        VmwareDistributedVirtualSwitch.FeatureCapability featuresSupported = (VmwareDistributedVirtualSwitch.FeatureCapability)manageDvpgPolicyData.featuresSupported;
        boolean macLearningSupported = featuresSupported.macLearningSupported != null && featuresSupported.macLearningSupported != false;
        DvpgSecurityPolicyModel securityPolicyModel = DvPortgroupPolicyParser.getSecurityPolicyModel(defaultPortConfig, macLearningSupported);
        return securityPolicyModel;
    }

    private static DvpgVlanPolicyModel createVlanPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        DvpgVlanPolicyModel vlanPolicyModel = DvPortgroupPolicyParser.getVlanPolicyModel(defaultPortConfig, manageDvpgPolicyData.pvlanConfig);
        return vlanPolicyModel;
    }

    private static DvpgTrafficShapingPolicyModel createTrafficShapingPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        DvpgTrafficShapingPolicyModel trafficShapingPolicyModel = DvPortgroupPolicyParser.getTrafficShapingPolicies(defaultPortConfig);
        return trafficShapingPolicyModel;
    }

    private static DvpgFailoverPolicyModel createFailoverPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        DvpgFailoverPolicyModel failoverPolicyModel = DvPortgroupPolicyParser.getTeamingAndFailoverPolicy(defaultPortConfig, manageDvpgPolicyData.uplinkPortNames, manageDvpgPolicyData.lacpGroupConfigs, manageDvpgPolicyData.loadBalancingModes);
        return failoverPolicyModel;
    }

    private static DvpgResourceAllocationPolicyModel createResourceAllocationPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null) {
            return null;
        }
        DvpgResourceAllocationPolicyModel resourceAllocationPolicyModel = DvPortgroupPolicyParser.getResourceAllocationModel(manageDvpgPolicyData.defaultPortConfig, false, manageDvpgPolicyData.niocVersion, "-1", manageDvpgPolicyData.vmVnicNetworkResourcePools, manageDvpgPolicyData.networkResourcePools);
        return resourceAllocationPolicyModel;
    }

    private static DvpgMonitoringPolicyModel createMonitoringPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) || manageDvpgPolicyData.featuresSupported == null || !(manageDvpgPolicyData.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        VmwareDistributedVirtualSwitch.FeatureCapability capability = (VmwareDistributedVirtualSwitch.FeatureCapability)manageDvpgPolicyData.featuresSupported;
        DvpgMonitoringPolicyModel monitoringPolicyModel = DvPortgroupPolicyParser.getIpfixPolicy(defaultPortConfig, capability.ipfixCapability);
        return monitoringPolicyModel;
    }

    private static DvpgMiscPolicyModel createMiscPolicyModel(ManageDvPortgroupsPolicyData manageDvpgPolicyData) {
        if (manageDvpgPolicyData == null || manageDvpgPolicyData.defaultPortConfig == null || !(manageDvpgPolicyData.defaultPortConfig instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)) {
            return null;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)manageDvpgPolicyData.defaultPortConfig;
        DvpgMiscPolicyModel miscPolicyModel = DvPortgroupPolicyParser.getPortBlockedPolicyModel(defaultPortConfig);
        return miscPolicyModel;
    }
}

