/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.manage.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvpgFilterBuilder
implements QueryFilterBuilder {
    static final String PROPERTY_DVS = "config.distributedVirtualSwitch";
    static final String PROPERTY_IS_UPLINK = "isUplinkPortgroup";
    static final String PROPERTY_BACKING_TYPE = "backingType";
    private static final Log _logger = LogFactory.getLog(DvpgFilterBuilder.class);
    private final ObjectReferenceService _objectReferenceService;

    public DvpgFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="dvpgObjectsFilter")
    public Filter dvpgObjectsFilter(String objectId) {
        Validate.notNull((Object)objectId);
        Object dvsRef = this.getRef(objectId);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate portgroupAttachedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        PropertyPredicate notUplinkPortgroupPredicate = new PropertyPredicate(PROPERTY_IS_UPLINK, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)Boolean.TRUE);
        List<PropertyPredicate> predicateList = Arrays.asList(portgroupAttachedToDvsPredicate, notUplinkPortgroupPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="dvpgExcludedObjectsFilter")
    public Filter dvpgExcludedObjectsFilter(String dvsId, String[] dvpgIds) {
        Validate.notNull((Object)dvsId);
        Validate.notNull((Object)dvpgIds);
        Validate.isTrue((dvpgIds.length == 0 || StringUtils.isNoneBlank((CharSequence[])dvpgIds) ? 1 : 0) != 0);
        Object dvsRef = this._objectReferenceService.getReference(dvsId, true);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate portgroupAttachedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        PropertyPredicate notUplinkPortgroupPredicate = new PropertyPredicate(PROPERTY_IS_UPLINK, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)Boolean.TRUE);
        ArrayList<Object> objects = new ArrayList<Object>(dvpgIds.length);
        for (String objectId : dvpgIds) {
            objects.add(this._objectReferenceService.getReference(objectId, true));
        }
        PropertyPredicate excludedPortgroupPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, objects);
        List<PropertyPredicate> predicateList = Arrays.asList(portgroupAttachedToDvsPredicate, notUplinkPortgroupPredicate, excludedPortgroupPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="dvpgNsxObjectsFilter")
    public Filter dvpgNsxObjectsFilter(String objectId) {
        Validate.notNull((Object)objectId);
        Object dvsRef = this.getRef(objectId);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate portgroupAttachedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        PropertyPredicate notUplinkPortgroupPredicate = new PropertyPredicate(PROPERTY_IS_UPLINK, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)Boolean.TRUE);
        PropertyPredicate notNsxPortgroupPredicate = new PropertyPredicate(PROPERTY_BACKING_TYPE, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)DistributedVirtualPortgroup.BackingType.nsx.toString());
        List<PropertyPredicate> predicateList = Arrays.asList(portgroupAttachedToDvsPredicate, notUplinkPortgroupPredicate, notNsxPortgroupPredicate);
        return new Filter(predicateList);
    }

    private Object getRef(String objectId) {
        Object objectRef = this._objectReferenceService.getReference(objectId, true);
        if (objectRef == null) {
            _logger.warn((Object)"No valid object ref found for filter");
            return null;
        }
        return objectRef;
    }
}

