/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.impl;

import com.vmware.vim.binding.vim.IntExpression;
import com.vmware.vim.binding.vim.IpAddress;
import com.vmware.vim.binding.vim.IpRange;
import com.vmware.vim.binding.vim.MacAddress;
import com.vmware.vim.binding.vim.MacRange;
import com.vmware.vim.binding.vim.SingleIp;
import com.vmware.vim.binding.vim.SingleMac;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.TrafficRule;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgIpAddressModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgIpQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgMacAddressModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgMacQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgPortModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgProtocolModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgSystemQualifierModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.trafficfilter.model.DvpgTrafficRuleModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DvpgTrafficRuleModelBuilder {
    public static final String ALLOW = "allow";
    public static final String DROP = "drop";
    public static final String TAG = "tag";
    public static final int ANY = 0;
    public static final int IS = 1;
    public static final int IS_NOT = 2;
    public static final int IN_RANGE = 3;
    public static final int NOT_IN_RANGE = 4;
    public static final int MATCHES = 5;
    public static final int DOES_NOT_MATCH = 6;
    public static final int TCP_PROTOCOL_VALUE = 6;
    public static final int UDP_PROTOCOL_VALUE = 17;
    public static final int ICMP_PROTOCOL_VALUE = 1;
    public static final int ICMP6_PROTOCOL_VALUE = 58;
    public static final int CUSTOM_PROTOCOL_VALUE = 0;
    public static final int IPV4_PROTOCOL_HEX_VALUE = 2048;
    public static final int IPV6_PROTOCOL_HEX_VALUE = 34525;
    public static final int ARP_PROTOCOL_HEX_VALUE = 2054;
    public static final String IPV4 = "ipv4";
    public static final String IPV6 = "ipv6";
    public static final String MIXED = "mixed";
    public static final int ANY_IP_PREFIX = 0;
    public static final String ANY_IPV4_ADDRESS = "255.255.255.255";
    public static final String ANY_IPV6_ADDRESS = "::";

    public static DvpgTrafficRuleModel getTrafficRuleModelByKey(DistributedVirtualPort.FilterPolicy filterPolicy, String ruleKey) {
        if (StringUtils.isEmpty((CharSequence)ruleKey) || filterPolicy == null || ArrayUtils.isEmpty((Object[])filterPolicy.filterConfig)) {
            return null;
        }
        DistributedVirtualPort.TrafficFilterConfig trafficFilterConfig = DvpgTrafficRuleModelBuilder.getGenericFilterConfig(filterPolicy);
        if (trafficFilterConfig == null || trafficFilterConfig.trafficRuleset == null || trafficFilterConfig.trafficRuleset.rules == null) {
            return null;
        }
        TrafficRule trafficRule = null;
        for (TrafficRule rule : trafficFilterConfig.trafficRuleset.rules) {
            if (!rule.key.equals(ruleKey)) continue;
            trafficRule = rule;
            break;
        }
        if (trafficRule == null) {
            return null;
        }
        return DvpgTrafficRuleModelBuilder.createTrafficRuleModel(trafficRule);
    }

    public static DistributedVirtualPort.TrafficFilterConfig getGenericFilterConfig(DistributedVirtualPort.FilterPolicy filterPolicy) {
        if (filterPolicy == null || ArrayUtils.isEmpty((Object[])filterPolicy.filterConfig)) {
            return null;
        }
        for (int i = 0; i < filterPolicy.filterConfig.length; ++i) {
            if (!filterPolicy.filterConfig[i].agentName.equals("dvfilter-generic-vmware")) continue;
            return (DistributedVirtualPort.TrafficFilterConfig)filterPolicy.filterConfig[i];
        }
        return null;
    }

    public static DvpgTrafficRuleModel createTrafficRuleModel(TrafficRule trafficRule) {
        if (trafficRule == null) {
            return null;
        }
        DvpgTrafficRuleModel ruleModel = new DvpgTrafficRuleModel();
        ruleModel.key = trafficRule.key;
        ruleModel.sequence = trafficRule.sequence;
        ruleModel.name = trafficRule.description;
        ruleModel.direction = trafficRule.direction;
        ruleModel.action = DvpgTrafficRuleModelBuilder.getRuleAction(trafficRule.action);
        if (trafficRule.action instanceof TrafficRule.UpdateTagAction) {
            TrafficRule.UpdateTagAction updateTagAction = (TrafficRule.UpdateTagAction)trafficRule.action;
            if (updateTagAction.qosTag != null) {
                ruleModel.qosTagSelected = true;
                ruleModel.qosTagValue = updateTagAction.qosTag.toString();
            }
            if (updateTagAction.dscpTag != null) {
                ruleModel.dscpTagSelected = true;
                ruleModel.dscpTagValue = updateTagAction.dscpTag.toString();
            }
        }
        ruleModel.ipQualifierModel = DvpgTrafficRuleModelBuilder.getIpQualifierModel((TrafficRule.IpQualifier)DvpgTrafficRuleModelBuilder.getQualifierByType(trafficRule.qualifier, TrafficRule.IpQualifier.class));
        ruleModel.macQualifierModel = DvpgTrafficRuleModelBuilder.getMacQualifierModel((TrafficRule.MacQualifier)DvpgTrafficRuleModelBuilder.getQualifierByType(trafficRule.qualifier, TrafficRule.MacQualifier.class));
        ruleModel.systemQualifierModel = DvpgTrafficRuleModelBuilder.getSystemQualifierModel((TrafficRule.SystemTrafficQualifier)DvpgTrafficRuleModelBuilder.getQualifierByType(trafficRule.qualifier, TrafficRule.SystemTrafficQualifier.class));
        return ruleModel;
    }

    public static String getRuleAction(TrafficRule.Action action) {
        if (action == null) {
            return null;
        }
        if (action instanceof TrafficRule.AcceptAction) {
            return ALLOW;
        }
        if (action instanceof TrafficRule.DropAction) {
            return DROP;
        }
        if (action instanceof TrafficRule.UpdateTagAction) {
            return TAG;
        }
        return null;
    }

    public static DvpgIpQualifierModel getIpQualifierModel(TrafficRule.IpQualifier ipQualifier) {
        if (ipQualifier == null) {
            return null;
        }
        DvpgIpQualifierModel ipQualifierModel = new DvpgIpQualifierModel();
        ipQualifierModel.enableIpQualifier = true;
        ipQualifierModel.protocol = DvpgTrafficRuleModelBuilder.getQualifierProtocolModel(ipQualifier.protocol, false);
        if (ipQualifier.protocol != null && (ipQualifier.protocol.value == 6 || ipQualifier.protocol.value == 17)) {
            ipQualifierModel.sourcePort = DvpgTrafficRuleModelBuilder.getIpPortModel(ipQualifier.sourceIpPort);
            ipQualifierModel.destinationPort = DvpgTrafficRuleModelBuilder.getIpPortModel(ipQualifier.destinationIpPort);
        }
        ipQualifierModel.sourceIpAddress = DvpgTrafficRuleModelBuilder.getIpAddressModel(ipQualifier.sourceAddress);
        ipQualifierModel.destinationIpAddress = DvpgTrafficRuleModelBuilder.getIpAddressModel(ipQualifier.destinationAddress);
        return ipQualifierModel;
    }

    public static DvpgMacQualifierModel getMacQualifierModel(TrafficRule.MacQualifier macQualifier) {
        if (macQualifier == null) {
            return null;
        }
        DvpgMacQualifierModel macQualifierModel = new DvpgMacQualifierModel();
        macQualifierModel.enableMacQualifier = true;
        macQualifierModel.protocol = DvpgTrafficRuleModelBuilder.getQualifierProtocolModel(macQualifier.protocol, true);
        if (macQualifier.vlanId == null) {
            macQualifierModel.vlanOperation = 0;
        } else {
            int n = macQualifierModel.vlanOperation = macQualifier.vlanId.negate != null && macQualifier.vlanId.negate != false ? 2 : 1;
            if (macQualifier.vlanId.value != null) {
                macQualifierModel.vlanId = DvpgTrafficRuleModelBuilder.convertIntegerToString(macQualifier.vlanId.value, false);
            }
        }
        macQualifierModel.sourceMacAddress = DvpgTrafficRuleModelBuilder.getMacAddressModel(macQualifier.sourceAddress);
        macQualifierModel.destinationMacAddress = DvpgTrafficRuleModelBuilder.getMacAddressModel(macQualifier.destinationAddress);
        return macQualifierModel;
    }

    public static DvpgSystemQualifierModel getSystemQualifierModel(TrafficRule.SystemTrafficQualifier systemQualifier) {
        if (systemQualifier == null) {
            return null;
        }
        DvpgSystemQualifierModel systemQualifierModel = new DvpgSystemQualifierModel();
        systemQualifierModel.enableSystemQualifier = true;
        if (systemQualifier.typeOfSystemTraffic == null || systemQualifier.typeOfSystemTraffic.value == null) {
            systemQualifierModel.trafficOperation = 0;
        } else {
            systemQualifierModel.trafficOperation = systemQualifier.typeOfSystemTraffic.negate != null && systemQualifier.typeOfSystemTraffic.negate != false ? 2 : 1;
            systemQualifierModel.trafficType = systemQualifier.typeOfSystemTraffic.value;
        }
        return systemQualifierModel;
    }

    public static DvpgProtocolModel getQualifierProtocolModel(IntExpression protocol, boolean isHexValue) {
        DvpgProtocolModel protocolModel = new DvpgProtocolModel();
        if (protocol == null || protocol.value == null) {
            protocolModel.operation = 0;
            protocolModel.type = 2048;
            return protocolModel;
        }
        protocolModel.operation = protocol.negate != null && protocol.negate != false ? 2 : 1;
        protocolModel.type = DvpgTrafficRuleModelBuilder.getProtocolTypeCode(protocol.value, isHexValue);
        if (protocolModel.type == 0 && protocol.value != null) {
            protocolModel.customValue = DvpgTrafficRuleModelBuilder.convertIntegerToString(protocol.value, isHexValue);
        }
        return protocolModel;
    }

    public static DvpgPortModel getIpPortModel(TrafficRule.IpPort port) {
        DvpgPortModel portModel = new DvpgPortModel();
        if (port == null) {
            portModel.operation = 0;
            return portModel;
        }
        if (port instanceof TrafficRule.SingleIpPort) {
            TrafficRule.SingleIpPort singleIpPort = (TrafficRule.SingleIpPort)port;
            portModel.operation = singleIpPort.negate != null && singleIpPort.negate != false ? 2 : 1;
            portModel.port = DvpgTrafficRuleModelBuilder.convertIntegerToString(singleIpPort.portNumber, false);
        } else if (port instanceof TrafficRule.IpPortRange) {
            TrafficRule.IpPortRange ipPortRange = (TrafficRule.IpPortRange)port;
            portModel.operation = ipPortRange.negate != null && ipPortRange.negate != false ? 4 : 3;
            portModel.port = DvpgTrafficRuleModelBuilder.convertIntegerToString(ipPortRange.startPortNumber, false);
            portModel.portRangeEnd = DvpgTrafficRuleModelBuilder.convertIntegerToString(ipPortRange.endPortNumber, false);
        }
        return portModel;
    }

    public static DvpgIpAddressModel getIpAddressModel(IpAddress ipAddress) {
        DvpgIpAddressModel dvpgIpAddressModel = new DvpgIpAddressModel();
        dvpgIpAddressModel.ipAddressType = MIXED;
        if (ipAddress == null) {
            dvpgIpAddressModel.operation = 0;
            return dvpgIpAddressModel;
        }
        if (ipAddress instanceof IpRange) {
            IpRange ipRange = (IpRange)ipAddress;
            if (ipRange.prefixLength == 0) {
                dvpgIpAddressModel.operation = 0;
                if (ipRange.addressPrefix != null) {
                    if (ipRange.addressPrefix.equals(ANY_IPV4_ADDRESS)) {
                        dvpgIpAddressModel.ipAddressType = IPV4;
                    } else if (ipRange.addressPrefix.equals(ANY_IPV6_ADDRESS)) {
                        dvpgIpAddressModel.ipAddressType = IPV6;
                    }
                }
            } else {
                dvpgIpAddressModel.operation = ipRange.negate != null && ipRange.negate != false ? 6 : 5;
                dvpgIpAddressModel.ipAddress = ipRange.addressPrefix;
                dvpgIpAddressModel.prefixLength = DvpgTrafficRuleModelBuilder.convertIntegerToString(ipRange.prefixLength, false);
            }
        } else if (ipAddress instanceof SingleIp) {
            SingleIp singleIp = (SingleIp)ipAddress;
            int n = dvpgIpAddressModel.operation = singleIp.negate != null && singleIp.negate != false ? 2 : 1;
            if (singleIp.address != null) {
                dvpgIpAddressModel.ipAddress = singleIp.address;
            }
        }
        return dvpgIpAddressModel;
    }

    public static DvpgMacAddressModel getMacAddressModel(MacAddress macAddress) {
        DvpgMacAddressModel macAddressModel = new DvpgMacAddressModel();
        if (macAddress == null) {
            macAddressModel.operation = 0;
            return macAddressModel;
        }
        if (macAddress instanceof SingleMac) {
            SingleMac singleMac = (SingleMac)macAddress;
            macAddressModel.operation = singleMac.negate != null && singleMac.negate != false ? 2 : 1;
            macAddressModel.macAddress = singleMac.address;
        } else if (macAddress instanceof MacRange) {
            MacRange macRange = (MacRange)macAddress;
            macAddressModel.operation = macRange.negate != null && macRange.negate != false ? 6 : 5;
            macAddressModel.macAddress = macRange.address;
            macAddressModel.wildcardMask = macRange.mask;
        }
        return macAddressModel;
    }

    private static TrafficRule.Qualifier getQualifierByType(TrafficRule.Qualifier[] qualifiers, Class<?> qualifierType) {
        if (ArrayUtils.isEmpty((Object[])qualifiers)) {
            return null;
        }
        for (TrafficRule.Qualifier qualifier : qualifiers) {
            if (!qualifierType.isInstance(qualifier)) continue;
            return qualifier;
        }
        return null;
    }

    private static int getProtocolTypeCode(Integer protocolCode, boolean isHexValue) {
        if (protocolCode == null) {
            return 0;
        }
        if (isHexValue) {
            switch (protocolCode) {
                case 2048: 
                case 2054: 
                case 34525: {
                    return protocolCode;
                }
            }
            return 0;
        }
        switch (protocolCode) {
            case 1: 
            case 6: 
            case 17: 
            case 58: {
                return protocolCode;
            }
        }
        return 0;
    }

    private static String convertIntegerToString(Integer value, boolean isHexValue) {
        if (value == null) {
            return null;
        }
        if (isHexValue) {
            String hexValue = Integer.toHexString(value).toUpperCase();
            while (hexValue.length() < 4) {
                hexValue = '0' + hexValue;
            }
            return hexValue;
        }
        return value.toString();
    }
}

