/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.dvs.api.DvsHostCompatibilityInfo;
import com.vmware.vsphere.client.dvs.api.host.DvsHostsData;
import com.vmware.vsphere.client.dvs.api.host.HostListItemData;
import com.vmware.vsphere.client.h5.network.backend.DistributedVirtualSwitchManagerFactory;
import com.vmware.vsphere.client.h5.network.dvs.addhost.HostListItemHelper;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsNewHostsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.DvsHostMemberModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.DvsMemberHostsModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.DvsNewHostsModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public class DvsAddHostPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService queryBindingService;
    private final DistributedVirtualSwitchManagerFactory dvsManagerFactory;
    private final HostListItemHelper hostListItemHelper;

    public DvsAddHostPropertyProvider(QueryBindingService queryBindingService, DistributedVirtualSwitchManagerFactory dvsManagerFactory, HostListItemHelper hostListItemHelper) {
        this.queryBindingService = queryBindingService;
        this.dvsManagerFactory = dvsManagerFactory;
        this.hostListItemHelper = hostListItemHelper;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="newHostsData")
    public DvsNewHostsData getNewHostsData(ManagedObjectReference dvsRef) {
        Validate.notNull((Object)dvsRef);
        DvsNewHostsData newHostsData = new DvsNewHostsData();
        DvsNewHostsModel dvsNewHostsModel = (DvsNewHostsModel)this.queryBindingService.prepare(DvsNewHostsModel.class).fetch((Object)dvsRef);
        DistributedVirtualSwitchManager manager = this.dvsManagerFactory.getDistributedVirtualSwitchManager(dvsRef.getServerGuid());
        ManagedObjectReference[] dvsNewCompatHosts = manager.queryCompatibleHostForExistingDvs(dvsNewHostsModel.dcRef, true, dvsRef);
        ArrayList<ManagedObjectReference> allHosts = new ArrayList<ManagedObjectReference>();
        if (dvsNewCompatHosts != null) {
            allHosts.addAll(Arrays.asList(dvsNewCompatHosts));
        }
        if (dvsNewHostsModel.dvsIncompatHostCompatibilityInfo != null) {
            for (DvsHostCompatibilityInfo hostCompatibilityInfo : dvsNewHostsModel.dvsIncompatHostCompatibilityInfo) {
                allHosts.add(hostCompatibilityInfo.hostRef);
            }
        }
        Collection dvsHostMemberModels = this.queryBindingService.prepare(DvsHostMemberModel.class).fetch(allHosts);
        newHostsData.hosts = this.hostListItemHelper.createHostListItems(dvsHostMemberModels);
        for (HostListItemData item : newHostsData.hosts) {
            this.addCompatibilityErrorsToItem(item, dvsNewHostsModel.dvsIncompatHostCompatibilityInfo);
        }
        return newHostsData;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="dvsHostsData")
    public DvsHostsData getDvsHostsData(ManagedObjectReference dvsRef) {
        Validate.notNull((Object)dvsRef);
        DvsHostsData dvsHostsData = new DvsHostsData();
        DvsMemberHostsModel dvsMemberHostsModel = (DvsMemberHostsModel)this.queryBindingService.prepare(DvsMemberHostsModel.class).fetch((Object)dvsRef);
        if (dvsMemberHostsModel.dvsHostMemberModels != null) {
            dvsHostsData.dvsHosts = this.hostListItemHelper.createHostListItems(Arrays.asList(dvsMemberHostsModel.dvsHostMemberModels));
            for (HostListItemData item : dvsHostsData.dvsHosts) {
                this.hostListItemHelper.addVdsStateToItem(item, dvsMemberHostsModel.hostMemberRuntimeInfos);
            }
        } else {
            dvsHostsData.dvsHosts = new ArrayList();
        }
        return dvsHostsData;
    }

    private void addCompatibilityErrorsToItem(HostListItemData item, DvsHostCompatibilityInfo[] dvsIncompatHostCompatibilityInfos) {
        DvsHostCompatibilityInfo dvsHostCompatibilityInfo = null;
        if (dvsIncompatHostCompatibilityInfos != null) {
            for (DvsHostCompatibilityInfo info : dvsIncompatHostCompatibilityInfos) {
                if (!item.hostRef.equals((Object)info.hostRef)) continue;
                dvsHostCompatibilityInfo = info;
                break;
            }
            if (dvsHostCompatibilityInfo != null) {
                item.compatibilityErrors.addAll(Arrays.asList(dvsHostCompatibilityInfo.compatibilityError));
            }
        }
    }
}

