/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostVnicData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostVnicHostData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostVnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.util.DvsHostNicModelComparator;
import com.vmware.vsphere.client.h5.network.dvs.addhost.vnic.model.HostOpaqueNetworkData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.vnic.model.VirtualAdapterData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DvsAddHostVnicParser {
    private static final String ON_THIS_SWITCH_ID = "-onThisSwitch-";
    private static final String ON_OTHER_SWITCHES_ID = "-onOtherSwitches-";

    public static Result parseHostVnics(Collection<DvsHostVnicModel> hostVnicDataObjects, boolean areMemberHosts, String dvsUuid) {
        if (hostVnicDataObjects == null || StringUtils.isEmpty((CharSequence)dvsUuid)) {
            return null;
        }
        Object[] dvsHostVnicModels = hostVnicDataObjects.toArray(new DvsHostVnicModel[hostVnicDataObjects.size()]);
        if (ArrayUtils.isEmpty((Object[])dvsHostVnicModels)) {
            return new Result();
        }
        DvsAddHostVnicParser.sortHostsAndVnics((DvsHostVnicModel[])dvsHostVnicModels);
        ArrayList<DvsAddManageHostVnicHostData> hostsList = new ArrayList<DvsAddManageHostVnicHostData>();
        HashSet<String> distributedPortgroupKeys = new HashSet<String>();
        HashMap<String, List<DvsAddManageHostVnicData>> vnicsConnectedToDvPortgroups = new HashMap<String, List<DvsAddManageHostVnicData>>();
        for (Object hostVnicModel : dvsHostVnicModels) {
            DvsAddManageHostVnicHostData hostItem = DvsAddHostVnicParser.createHostItem((DvsHostVnicModel)hostVnicModel, areMemberHosts);
            if (hostItem != null) {
                ArrayList<DvsAddManageHostVnicData> vnicsList = new ArrayList<DvsAddManageHostVnicData>();
                if (!ArrayUtils.isEmpty((Object[])((DvsHostVnicModel)hostVnicModel).vnics)) {
                    Map<String, VirtualAdapterData> vnicMap = DvsAddHostVnicParser.createVnicMap((DvsHostVnicModel)hostVnicModel);
                    for (VirtualNic virtualNic : ((DvsHostVnicModel)hostVnicModel).vnics) {
                        VirtualAdapterData virtualAdapterData = vnicMap.get(virtualNic.device);
                        DvsAddManageHostVnicData vnicItem = DvsAddHostVnicParser.createVnicItem(virtualAdapterData, (ManagedObjectReference)((DvsHostVnicModel)hostVnicModel).provider, dvsUuid);
                        if (virtualAdapterData != null && StringUtils.isNotEmpty((CharSequence)virtualAdapterData.dvPortgroupKey)) {
                            distributedPortgroupKeys.add(virtualAdapterData.dvPortgroupKey);
                            String uniqueIdentifier = DvsAddHostVnicParser.getUniqueDvPortgroupIdentifier(virtualAdapterData.dvPortgroupKey, virtualAdapterData.dvsUuid);
                            ArrayList<DvsAddManageHostVnicData> nicItems = (ArrayList<DvsAddManageHostVnicData>)vnicsConnectedToDvPortgroups.get(uniqueIdentifier);
                            if (nicItems == null) {
                                nicItems = new ArrayList<DvsAddManageHostVnicData>();
                                vnicsConnectedToDvPortgroups.put(uniqueIdentifier, nicItems);
                            }
                            nicItems.add(vnicItem);
                        }
                        if (vnicItem == null) continue;
                        if (vnicItem.isOnThisSwitch) {
                            hostItem.increaseAssignedVnics();
                        }
                        vnicsList.add(vnicItem);
                    }
                }
                hostItem.setVnics(vnicsList.toArray(new DvsAddManageHostVnicData[vnicsList.size()]));
            }
            hostsList.add(hostItem);
        }
        Result result = new Result();
        result.distributedPortgroupKeys = new ArrayList<String>(distributedPortgroupKeys);
        result.vnicsConnectedToDvPortgroups = vnicsConnectedToDvPortgroups;
        result.hostsItems = hostsList.toArray(new DvsAddManageHostVnicHostData[hostsList.size()]);
        return result;
    }

    public static String getUniqueDvPortgroupIdentifier(String portgroupKey, String dvsUuid) {
        if (portgroupKey == null) {
            throw new IllegalArgumentException("portgroupKey cannot be null");
        }
        if (dvsUuid == null) {
            throw new IllegalArgumentException("dvsUuid cannot be null");
        }
        return portgroupKey + ":" + dvsUuid;
    }

    private static DvsAddManageHostVnicData createVnicItem(VirtualAdapterData vnicData, ManagedObjectReference hostRef, String dvsUuid) {
        if (vnicData == null || StringUtils.isEmpty((CharSequence)vnicData.vnicName)) {
            return null;
        }
        boolean isOnThisSwitch = false;
        if (vnicData.vswitch instanceof HostProxySwitch) {
            HostProxySwitch hostProxySwitch = (HostProxySwitch)vnicData.vswitch;
            if (dvsUuid.equals(hostProxySwitch.dvsUuid)) {
                isOnThisSwitch = true;
            }
        }
        boolean isStandardSwitch = vnicData.vswitch instanceof VirtualSwitch;
        boolean isOpaqueSwitch = vnicData.vswitch instanceof OpaqueSwitch;
        boolean isOnManagementStack = vnicData.virtualNic.spec == null || vnicData.virtualNic.spec.netStackInstanceKey == null || vnicData.virtualNic.spec.netStackInstanceKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.name());
        return new DvsAddManageHostVnicData(vnicData.virtualNic.device, DvsAddHostVnicParser.getVswitchName(vnicData.vswitch), isOnThisSwitch, vnicData.portgroup, isStandardSwitch, isOpaqueSwitch, isOnManagementStack, hostRef, Boolean.valueOf(vnicData.vswitch instanceof VirtualSwitch));
    }

    private static String getVswitchName(Object vswitch) {
        String name = NetworkStringUtil.getString("na");
        if (vswitch instanceof VirtualSwitch) {
            VirtualSwitch virtualSwitch = (VirtualSwitch)vswitch;
            name = virtualSwitch.name;
        } else if (vswitch instanceof HostProxySwitch) {
            HostProxySwitch hostProxySwitch = (HostProxySwitch)vswitch;
            name = hostProxySwitch.dvsName;
        } else if (vswitch instanceof OpaqueSwitch) {
            OpaqueSwitch opaqueSwitch = (OpaqueSwitch)vswitch;
            name = opaqueSwitch.name;
        }
        return name;
    }

    private static void sortHostsAndVnics(DvsHostVnicModel[] hostVnicModels) {
        Arrays.sort(hostVnicModels, new DvsHostNicModelComparator());
        for (DvsHostVnicModel hostVnicModel : hostVnicModels) {
            if (hostVnicModel == null) continue;
            DvsAddHostVnicParser.sortVnics(hostVnicModel.vnics);
        }
    }

    private static void sortVnics(VirtualNic[] vnics) {
        if (ArrayUtils.isEmpty((Object[])vnics)) {
            return;
        }
        Arrays.sort(vnics, new Comparator<VirtualNic>(){

            @Override
            public int compare(VirtualNic vnic1, VirtualNic vnic2) {
                if (vnic1 == null || vnic1.device == null) {
                    return -1;
                }
                if (vnic2 == null || vnic2.device == null) {
                    return 1;
                }
                String vnic1Device = vnic1.device;
                String vnic2Device = vnic2.device;
                return NetworkUtil.compareNicDevices(vnic1Device, vnic2Device, "vmk");
            }
        });
    }

    private static Map<String, VirtualAdapterData> createVnicMap(DvsHostVnicModel hostVnicModel) {
        HashMap<String, VirtualAdapterData> resultMap = new HashMap<String, VirtualAdapterData>();
        Map<String, HostProxySwitch> proxySwitchMap = DvsAddHostVnicParser.createProxySwitchMap(hostVnicModel.proxySwitches);
        Map<String, HostOpaqueNetworkData> opaqueNetworkMap = DvsAddHostWizardUtil.createOpaqueNetworkMap(hostVnicModel.opaqueNetwork, hostVnicModel.opaqueSwitches);
        Map<String, PortGroup> keyToPortgroupMap = DvsAddHostVnicParser.createKeyToPortgroupMap(hostVnicModel.portGroups);
        if (!ArrayUtils.isEmpty((Object[])hostVnicModel.vnics)) {
            for (VirtualNic virtualNic : hostVnicModel.vnics) {
                VirtualAdapterData virtualAdapterData = DvsAddHostVnicParser.createVnicAdapterData(virtualNic, proxySwitchMap, opaqueNetworkMap);
                if (virtualAdapterData == null) continue;
                resultMap.put(virtualNic.device, virtualAdapterData);
            }
        }
        DvsAddHostVnicParser.populateStandardSwitchData(hostVnicModel.vswitches, keyToPortgroupMap, hostVnicModel.vnics, resultMap);
        return resultMap;
    }

    private static VirtualAdapterData createVnicAdapterData(VirtualNic vnic, Map<String, HostProxySwitch> proxySwitchMap, Map<String, HostOpaqueNetworkData> opaqueNetworkMap) {
        if (vnic == null || StringUtils.isEmpty((CharSequence)vnic.device)) {
            return null;
        }
        VirtualAdapterData vnicData = new VirtualAdapterData();
        vnicData.virtualNic = vnic;
        vnicData.vnicName = vnic.device;
        vnicData.portgroup = vnic.portgroup;
        if (vnic.spec != null) {
            String opaqueNetworkKey;
            HostOpaqueNetworkData opaqueNetworkData;
            if (vnic.spec.distributedVirtualPort != null) {
                HostProxySwitch proxyswitch = proxySwitchMap.get(vnic.spec.distributedVirtualPort.switchUuid);
                if (proxyswitch != null) {
                    vnicData.vswitch = proxyswitch;
                }
                String portgroupKey = vnic.spec.distributedVirtualPort.portgroupKey;
                String dvsUuid = vnic.spec.distributedVirtualPort.switchUuid;
                String portKey = vnic.spec.distributedVirtualPort.portKey;
                if (StringUtils.isNotEmpty((CharSequence)portgroupKey)) {
                    vnicData.dvPortgroupKey = portgroupKey;
                    vnicData.dvsUuid = dvsUuid;
                    vnicData.portgroup = "";
                } else if (StringUtils.isNotEmpty((CharSequence)portKey)) {
                    vnicData.portgroup = NetworkStringUtil.getString("SelectVirtualAdaptersPage.portId", portKey);
                }
            } else if (vnic.spec.opaqueNetwork != null && (opaqueNetworkData = opaqueNetworkMap.get(opaqueNetworkKey = DvsAddHostWizardUtil.constructOpaqueNetworkKey(vnic.spec.opaqueNetwork.opaqueNetworkId, vnic.spec.opaqueNetwork.opaqueNetworkType))) != null) {
                vnicData.vswitch = opaqueNetworkData.opaqueSwitch;
                vnicData.portgroup = opaqueNetworkData.getLongNetworkLabel();
            }
        }
        if (StringUtils.isEmpty((CharSequence)vnicData.portgroup)) {
            vnicData.portgroup = NetworkStringUtil.getString("na");
        }
        return vnicData;
    }

    private static void populateStandardSwitchData(VirtualSwitch[] virtualSwitches, Map<String, PortGroup> keyToPortgroupMap, VirtualNic[] vnics, Map<String, VirtualAdapterData> vnicMap) {
        if (!ArrayUtils.isEmpty((Object[])virtualSwitches)) {
            for (VirtualSwitch vSwitch : virtualSwitches) {
                if (vSwitch == null || ArrayUtils.isEmpty((Object[])vSwitch.portgroup)) continue;
                for (String portgroupKey : vSwitch.portgroup) {
                    VirtualAdapterData vnicData;
                    PortGroup portgroup = DvsAddHostVnicParser.getPortgroupForKey(keyToPortgroupMap, portgroupKey);
                    if (portgroup == null) continue;
                    VirtualNic vnic = null;
                    String pgName = null;
                    if (portgroup != null && portgroup.spec != null) {
                        pgName = portgroup.spec.name;
                    }
                    for (VirtualNic virtualNic : vnics) {
                        if (pgName == null || !pgName.equals(virtualNic.portgroup)) continue;
                        vnic = virtualNic;
                        break;
                    }
                    if (vnic == null || !StringUtils.isNotEmpty((CharSequence)vnic.device) || (vnicData = vnicMap.get(vnic.device)) == null) continue;
                    vnicData.vswitch = vSwitch;
                }
            }
        }
    }

    private static PortGroup getPortgroupForKey(Map<String, PortGroup> keyToPortgroupMap, String pgKey) {
        for (Map.Entry<String, PortGroup> entry : keyToPortgroupMap.entrySet()) {
            if (!StringUtils.endsWith((CharSequence)pgKey, (CharSequence)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Map<String, HostProxySwitch> createProxySwitchMap(HostProxySwitch[] proxySwitches) {
        HashMap<String, HostProxySwitch> resultMap = new HashMap<String, HostProxySwitch>();
        if (!ArrayUtils.isEmpty((Object[])proxySwitches)) {
            for (HostProxySwitch proxySwitch : proxySwitches) {
                if (proxySwitch == null || !StringUtils.isNotEmpty((CharSequence)proxySwitch.dvsUuid)) continue;
                resultMap.put(proxySwitch.dvsUuid, proxySwitch);
            }
        }
        return resultMap;
    }

    private static Map<String, PortGroup> createKeyToPortgroupMap(PortGroup[] portGroups) {
        HashMap<String, PortGroup> resultMap = new HashMap<String, PortGroup>();
        if (!ArrayUtils.isEmpty((Object[])portGroups)) {
            for (PortGroup portgroup : portGroups) {
                if (portgroup == null || !StringUtils.isNotEmpty((CharSequence)portgroup.key)) continue;
                resultMap.put(portgroup.key, portgroup);
            }
        }
        return resultMap;
    }

    private static DvsAddManageHostVnicHostData createHostItem(DvsHostVnicModel hostVnicModel, boolean isMemberHost) {
        if (hostVnicModel == null || hostVnicModel.provider == null || !(hostVnicModel.provider instanceof ManagedObjectReference) || StringUtils.isEmpty((CharSequence)hostVnicModel.name)) {
            return null;
        }
        DvsAddManageHostVnicHostData hostItem = new DvsAddManageHostVnicHostData((ManagedObjectReference)hostVnicModel.provider, hostVnicModel.name, isMemberHost);
        return hostItem;
    }

    public static class Result {
        public DvsAddManageHostVnicHostData[] hostsItems;
        public List<String> distributedPortgroupKeys = new ArrayList<String>();
        public Map<String, List<DvsAddManageHostVnicData>> vnicsConnectedToDvPortgroups;
    }
}

