/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.netstack;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.ConfigSpecOperation;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.HostNetStackParser;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackReconfigureData;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackReconfigureSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostNetStackMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostNetStackMutationProvider.class);
    private final QueryBindingService _queryBindingService;

    public HostNetStackMutationProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NetStackReconfigureSpec netStackReconfigureSpec) throws Exception {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (netStackReconfigureSpec == null) {
            _logger.error((Object)"NetStackReconfigureSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        NetStackReconfigureData netStackReconfigureData = (NetStackReconfigureData)this._queryBindingService.prepare(NetStackReconfigureData.class).fetch((Object)hostRef);
        NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)netStackReconfigureData.networkSystemRef);
        if (netStackReconfigureData.multipleNetworkStackInstanceSupported != null && netStackReconfigureData.multipleNetworkStackInstanceSupported.booleanValue()) {
            NetworkConfig networkConfig = new NetworkConfig();
            NetStackInstance netStackInstance = NetStackUtil.getNetStackInstanceByKey(netStackReconfigureSpec.netStackInstanceKey, netStackReconfigureData.netStackInstances);
            if (netStackInstance == null) {
                _logger.error((Object)String.format("NetStackInstance with key %s not found", netStackReconfigureSpec.netStackInstanceKey));
                opResult.error = MixedUtil.getInvalidEntityFault();
                return opResult;
            }
            NetworkConfig.NetStackSpec netStackSpec = new NetworkConfig.NetStackSpec();
            netStackSpec.operation = ConfigSpecOperation.edit.toString();
            netStackSpec.netStackInstance = HostNetStackParser.buildReconfiguredNetStack(netStackInstance, netStackReconfigureSpec);
            networkConfig.netStackSpec = new NetworkConfig.NetStackSpec[]{netStackSpec};
            try {
                networkSystem.updateNetworkConfig(networkConfig, ConfigChange.Mode.modify.toString());
            }
            catch (Exception ex) {
                _logger.error((Object)("Error when modifying network config: " + ex.getMessage()));
                opResult.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        } else {
            if (netStackReconfigureSpec.dnsConfig != null) {
                DnsConfig dnsConfigUpdated = HostNetStackParser.buildUpdatedDnsConfig(netStackReconfigureData.hostDnsConfig, netStackReconfigureSpec.dnsConfig);
                try {
                    networkSystem.updateDnsConfig(dnsConfigUpdated);
                }
                catch (Exception ex) {
                    _logger.error((Object)("Error when modifying dns config: " + ex.getMessage()));
                    opResult.error = MixedUtil.getMethodFault((Throwable)ex);
                }
            }
            if (netStackReconfigureSpec.ipRouteConfig != null) {
                try {
                    networkSystem.updateIpRouteConfig(netStackReconfigureSpec.ipRouteConfig);
                }
                catch (Exception ex) {
                    _logger.error((Object)("Error when modifying ip routing config: " + ex.getMessage()));
                    opResult.error = MixedUtil.getMethodFault((Throwable)ex);
                }
            }
        }
        return opResult;
    }
}

