/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.proxyswitch;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.backend.DistributedVirtualSwitchManagerFactory;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.ProxySwitchParser;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.DvsUplinkPortgroupData;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.model.ProxySwitchUplinkData;
import com.vmware.vsphere.client.h5.network.host.proxyswitch.spec.ProxySwitchInfoSpec;
import java.util.ArrayList;

public class ProxySwitchPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;
    private final DistributedVirtualSwitchManagerFactory _dvsManagerFactory;

    public ProxySwitchPropertyProvider(QueryBindingService queryBindingService, DistributedVirtualSwitchManagerFactory dvsManagerFactory) {
        this._queryBindingService = queryBindingService;
        this._dvsManagerFactory = dvsManagerFactory;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="proxyswitch", property="getProxySwitchUplinkData")
    public ProxySwitchUplinkData getProxySwitchUplinkData(ManagedObjectReference hostMor, ProxySwitchInfoSpec proxySwitchInfoSpec) {
        DistributedVirtualSwitchManager manager;
        DistributedVirtualSwitchManager.PhysicalNicsList[] compatibleHostPnics;
        HostPnicSwitchData hostPnicSwitchData = (HostPnicSwitchData)this._queryBindingService.prepare(HostPnicSwitchData.class).fetch((Object)hostMor);
        DvsUplinkPortgroupData dvpgData = null;
        ArrayList<String> compatiblePnics = new ArrayList<String>();
        if (proxySwitchInfoSpec.dvsRef != null && (dvpgData = (DvsUplinkPortgroupData)this._queryBindingService.prepare(DvsUplinkPortgroupData.class).fetch((Object)proxySwitchInfoSpec.dvsRef)) != null && dvpgData.isNetworkOffloadEnabled != null && dvpgData.isNetworkOffloadEnabled.booleanValue() && (compatibleHostPnics = (manager = this._dvsManagerFactory.getDistributedVirtualSwitchManager(proxySwitchInfoSpec.dvsRef.getServerGuid())).queryCompatibleVmnicsFromHosts(new ManagedObjectReference[]{hostMor}, proxySwitchInfoSpec.dvsRef)) != null && compatibleHostPnics.length > 0 && compatibleHostPnics[0].physicalNics != null && compatibleHostPnics[0].physicalNics.length > 0) {
            for (PhysicalNic physicalNic : compatibleHostPnics[0].physicalNics) {
                compatiblePnics.add(physicalNic.device);
            }
        }
        return ProxySwitchParser.buildDvsUplinkData(hostPnicSwitchData, dvpgData, proxySwitchInfoSpec.proxySwitchKey, compatiblePnics);
    }
}

