/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.rdma;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.RdmaDevice;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdapterDetailsQueryBinding;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdapterProperties;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdapterVmksQueryBinding;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdaptersQueryBinding;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdaptersVmkAdapterData;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaAdaptersVmkAdaptersList;
import com.vmware.vsphere.client.h5.network.host.rdma.model.RdmaItem;
import com.vmware.vsphere.client.h5.network.util.IpUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class RdmaAdaptersPropertyProvider
implements PropertyProviderBean {
    private static final String CONNECTION_STATE_ACTIVE = "active";
    private static final String CONNECTION_STATE_DOWN = "down";
    private final QueryBindingService _queryBindingService;

    public RdmaAdaptersPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="rdma", property="rdmaAdapters")
    public RdmaItem[] getRdmaAdapters(ManagedObjectReference hostMor) {
        RdmaAdaptersQueryBinding rdmaData = (RdmaAdaptersQueryBinding)((Object)this._queryBindingService.prepare(RdmaAdaptersQueryBinding.class).fetch((Object)hostMor));
        if (rdmaData == null || ArrayUtils.isEmpty((Object[])rdmaData.rdmaDevices)) {
            return null;
        }
        RdmaDevice[] rdmaDevices = rdmaData.rdmaDevices;
        ArrayList<RdmaItem> rdmaItemList = new ArrayList<RdmaItem>();
        for (RdmaDevice rdmaDevice : rdmaDevices) {
            String pairedPnicKey;
            PhysicalNic pairedPnic;
            RdmaDevice.PnicBacking rdmaDeviceBacking;
            RdmaItem rdmaItem = new RdmaItem();
            rdmaItem.deviceName = rdmaDevice.device;
            rdmaItem.deviceDriver = rdmaDevice.driver;
            rdmaItem.key = rdmaDevice.key;
            if (rdmaDevice.connectionInfo == null) {
                rdmaItem.state = NetworkStringUtil.getString("na");
            } else {
                switch (rdmaDevice.connectionInfo.state) {
                    case "active": {
                        rdmaItem.state = NetworkStringUtil.getString("rdma.device.connection.state.active");
                        break;
                    }
                    case "down": {
                        rdmaItem.state = NetworkStringUtil.getString("rdma.device.connection.state.down");
                        break;
                    }
                    default: {
                        rdmaItem.state = rdmaDevice.connectionInfo.state;
                    }
                }
            }
            rdmaItem.pnicName = !ArrayUtils.isEmpty((Object[])rdmaData.pnics) ? ((rdmaDeviceBacking = (RdmaDevice.PnicBacking)rdmaDevice.backing) != null ? ((pairedPnic = this.getPnicByKey(rdmaData.pnics, pairedPnicKey = rdmaDeviceBacking.pairedUplink)) != null ? pairedPnic.device : NetworkStringUtil.getString("na")) : NetworkStringUtil.getString("na")) : NetworkStringUtil.getString("na");
            if (rdmaDevice.capability != null) {
                RdmaDevice.Capability capability = rdmaDevice.capability;
                rdmaItem.enabledRoceV1 = capability.roceV1Capable ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                rdmaItem.enabledRoceV2 = capability.roceV2Capable ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
                rdmaItem.iWarpEnabled = capability.iWarpCapable ? NetworkStringUtil.getString("enabled") : NetworkStringUtil.getString("disabled");
            } else {
                rdmaItem.enabledRoceV1 = NetworkStringUtil.getString("na");
                rdmaItem.enabledRoceV2 = NetworkStringUtil.getString("na");
            }
            rdmaItemList.add(rdmaItem);
        }
        return rdmaItemList.toArray(new RdmaItem[rdmaItemList.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="rdma", property="rdmaAdapterPropertiesData")
    public RdmaAdapterProperties getRdmaAdapterPropertiesData(ManagedObjectReference hostMor, String rdmaAdapterKey) {
        if (rdmaAdapterKey == null || rdmaAdapterKey.equals("")) {
            return null;
        }
        RdmaAdapterDetailsQueryBinding rdmaAdaptersData = (RdmaAdapterDetailsQueryBinding)((Object)this._queryBindingService.prepare(RdmaAdapterDetailsQueryBinding.class).fetch((Object)hostMor));
        if (rdmaAdaptersData == null || ArrayUtils.isEmpty((Object[])rdmaAdaptersData.rdmaDevices)) {
            return null;
        }
        RdmaAdapterProperties rdmaAdapterProperties = null;
        for (RdmaDevice rdmaDevice : rdmaAdaptersData.rdmaDevices) {
            if (!rdmaAdapterKey.equals(rdmaDevice.key)) continue;
            rdmaAdapterProperties = new RdmaAdapterProperties();
            rdmaAdapterProperties.deviceName = rdmaDevice.device;
            rdmaAdapterProperties.description = rdmaDevice.description;
            if (rdmaDevice.connectionInfo == null) break;
            rdmaAdapterProperties.mtu = rdmaDevice.connectionInfo.mtu;
            rdmaAdapterProperties.speedInMbps = rdmaDevice.connectionInfo.speedInMbps;
            break;
        }
        return rdmaAdapterProperties;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="rdma", property="rdmaAdapterVmksData")
    public RdmaAdaptersVmkAdaptersList getRdmaAdapterVmksData(ManagedObjectReference hostMor, String rdmaAdapterKey) {
        RdmaAdapterVmksQueryBinding rdmaVmksData = (RdmaAdapterVmksQueryBinding)((Object)this._queryBindingService.prepare(RdmaAdapterVmksQueryBinding.class).fetch((Object)hostMor));
        if (rdmaVmksData == null || ArrayUtils.isEmpty((Object[])rdmaVmksData.rdmaDevices)) {
            return null;
        }
        RdmaAdaptersVmkAdaptersList rdmaVmkAdapters = new RdmaAdaptersVmkAdaptersList();
        RdmaDevice[] rdmaDevices = rdmaVmksData.rdmaDevices;
        RdmaDevice rdmaDevice = null;
        for (RdmaDevice device : rdmaDevices) {
            if (!rdmaAdapterKey.equals(device.key)) continue;
            rdmaDevice = device;
            break;
        }
        if (rdmaDevice != null) {
            ArrayList<RdmaAdaptersVmkAdapterData> rdmaVmkAdaptersList = new ArrayList<RdmaAdaptersVmkAdapterData>();
            Map<String, String> mapPnicSwitchKey = this.fillPnicSwitchKeyMap(rdmaDevice, rdmaVmksData);
            Map<VirtualNic, String> mapVnicSwitchKey = this.fillVnicSwitchKeyMap(rdmaVmksData);
            for (Map.Entry<VirtualNic, String> entryVnicSwitch : mapVnicSwitchKey.entrySet()) {
                for (Map.Entry<String, String> entryPnicSwitch : mapPnicSwitchKey.entrySet()) {
                    if (entryPnicSwitch.getValue() == null || entryVnicSwitch.getValue() == null || !entryPnicSwitch.getValue().equals(entryVnicSwitch.getValue())) continue;
                    RdmaAdaptersVmkAdapterData rdmaAdaptersVmkAdapter = new RdmaAdaptersVmkAdapterData();
                    VirtualNic vnic = entryVnicSwitch.getKey();
                    rdmaAdaptersVmkAdapter.vmkAdapter = vnic.device;
                    if (vnic.spec != null && vnic.spec.netStackInstanceKey != null && rdmaVmksData.netStackInstance != null) {
                        rdmaAdaptersVmkAdapter.netStack = NetStackUtil.getNetStackInstanceName(NetStackUtil.getNetStackInstanceByKey(vnic.spec.netStackInstanceKey, rdmaVmksData.netStackInstance));
                    }
                    rdmaAdaptersVmkAdapter.netStack = rdmaAdaptersVmkAdapter.netStack != null ? rdmaAdaptersVmkAdapter.netStack : NetworkStringUtil.getString("na");
                    rdmaAdaptersVmkAdapter.ipAddress = IpUtil.extractIpAddress(vnic);
                    rdmaVmkAdaptersList.add(rdmaAdaptersVmkAdapter);
                }
            }
            Collections.sort(rdmaVmkAdaptersList);
            rdmaVmkAdapters.rdmaAdaptersVmkAdapters = rdmaVmkAdaptersList.toArray(new RdmaAdaptersVmkAdapterData[rdmaVmkAdaptersList.size()]);
        }
        return rdmaVmkAdapters;
    }

    private PhysicalNic getPnicByKey(PhysicalNic[] pnics, String pairedPnicKey) {
        for (PhysicalNic pnic : pnics) {
            if (!pairedPnicKey.equals(pnic.key)) continue;
            return pnic;
        }
        return null;
    }

    private Map<String, String> fillPnicSwitchKeyMap(RdmaDevice rdmaDevice, RdmaAdapterVmksQueryBinding rdmaVmksData) {
        RdmaDevice.PnicBacking rdmaDeviceBacking;
        HashMap<String, String> mapPnicSwitchKey = new HashMap<String, String>();
        if (!ArrayUtils.isEmpty((Object[])rdmaVmksData.pnics) && (rdmaDeviceBacking = (RdmaDevice.PnicBacking)rdmaDevice.backing) != null) {
            String pairedPnicKey = rdmaDeviceBacking.pairedUplink;
            PhysicalNic pairedPnic = this.getPnicByKey(rdmaVmksData.pnics, pairedPnicKey);
            String switchKey = this.getSwitchKey(pairedPnic, rdmaVmksData.vswitches, rdmaVmksData.proxySwitches, rdmaVmksData.opaqueSwitches);
            mapPnicSwitchKey.put(pairedPnic.device, switchKey);
        }
        return mapPnicSwitchKey;
    }

    private Map<VirtualNic, String> fillVnicSwitchKeyMap(RdmaAdapterVmksQueryBinding rdmaVmksData) {
        HashMap<VirtualNic, String> mapVnicSwitchKey = new HashMap<VirtualNic, String>();
        for (VirtualNic vnic : rdmaVmksData.vnics) {
            String switchKey = this.getStandardSwitchKey(vnic, rdmaVmksData.portGroups);
            if (switchKey == null) {
                switchKey = this.getHostProxySwitchKey(vnic, rdmaVmksData.proxySwitches);
            }
            if (switchKey == null) {
                switchKey = this.getOpaqueSwitchKey(vnic, rdmaVmksData);
            }
            if (switchKey == null) continue;
            mapVnicSwitchKey.put(vnic, switchKey);
        }
        return mapVnicSwitchKey;
    }

    private String getSwitchKey(PhysicalNic pnic, VirtualSwitch[] vSwitches, HostProxySwitch[] proxySwitches, OpaqueSwitch[] opaqueSwitches) {
        if (pnic == null) {
            return null;
        }
        if (vSwitches != null) {
            for (VirtualSwitch virtualSwitch : vSwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    return virtualSwitch.key;
                }
            }
        }
        if (proxySwitches != null) {
            for (VirtualSwitch virtualSwitch : proxySwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    return virtualSwitch.dvsUuid;
                }
            }
        }
        if (opaqueSwitches != null) {
            for (VirtualSwitch virtualSwitch : opaqueSwitches) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    return virtualSwitch.key;
                }
            }
        }
        return null;
    }

    private String getStandardSwitchKey(VirtualNic vnic, PortGroup[] portGroups) {
        if (vnic == null || portGroups == null) {
            return null;
        }
        String portGroupName = null;
        if (vnic.spec != null && vnic.spec.portgroup != null) {
            portGroupName = vnic.spec.portgroup;
        }
        if (portGroupName != null) {
            for (PortGroup portGroup : portGroups) {
                if (portGroup.spec == null || !portGroupName.equals(portGroup.spec.getName())) continue;
                return portGroup.vswitch;
            }
        }
        return null;
    }

    private String getHostProxySwitchKey(VirtualNic vnic, HostProxySwitch[] proxySwitches) {
        if (vnic == null || proxySwitches == null) {
            return null;
        }
        String vnicDvpSwitchId = null;
        if (vnic.spec != null && vnic.spec.distributedVirtualPort != null && vnic.spec.distributedVirtualPort.switchUuid != null) {
            vnicDvpSwitchId = vnic.spec.distributedVirtualPort.switchUuid;
        }
        if (vnicDvpSwitchId != null) {
            for (HostProxySwitch proxySwitch : proxySwitches) {
                if (proxySwitch.dvsUuid == null || !proxySwitch.dvsUuid.equals(vnicDvpSwitchId)) continue;
                return proxySwitch.dvsUuid;
            }
        }
        return null;
    }

    private String getOpaqueSwitchKey(VirtualNic vnic, RdmaAdapterVmksQueryBinding rdmaVmksData) {
        String[] pnicZones = this.getOpaqueNetworkPnicZoneIds(vnic, rdmaVmksData.opaqueNetworks);
        if (pnicZones != null) {
            for (String pnicZone : pnicZones) {
                for (OpaqueSwitch opaqueSwitch : rdmaVmksData.opaqueSwitches) {
                    if (!this.getPnicZoneKeysSet(opaqueSwitch).contains(pnicZone)) continue;
                    return opaqueSwitch.key;
                }
            }
        }
        return null;
    }

    private String[] getOpaqueNetworkPnicZoneIds(VirtualNic vnic, OpaqueNetworkInfo[] opaqueNetworks) {
        if (vnic == null || opaqueNetworks == null) {
            return null;
        }
        String vnicOpaqueNetworkId = null;
        if (vnic.spec != null && vnic.spec.opaqueNetwork != null) {
            vnicOpaqueNetworkId = vnic.spec.opaqueNetwork.opaqueNetworkId;
        }
        if (vnicOpaqueNetworkId != null) {
            for (OpaqueNetworkInfo opaqueNetwork : opaqueNetworks) {
                if (opaqueNetwork == null || opaqueNetwork.opaqueNetworkId == null || !opaqueNetwork.opaqueNetworkId.equals(vnicOpaqueNetworkId)) continue;
                return opaqueNetwork.pnicZone;
            }
        }
        return null;
    }

    private Set<String> getPnicZoneKeysSet(OpaqueSwitch opaqueSwitch) {
        HashSet<String> pnicZonesByKey = new HashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])opaqueSwitch.pnicZone)) {
            for (OpaqueSwitch.PhysicalNicZone pnicZone : opaqueSwitch.pnicZone) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pnicZone.key)) continue;
                pnicZonesByKey.add(pnicZone.key);
            }
        }
        return pnicZonesByKey;
    }
}

