/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.virtualswitch;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.host.portgroup.PortGroupParser;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.HostVirtualSwitchParser;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.DvsUuidData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.EditStandardSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.EditStandardSwitchDialogData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchIssueType;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchItem;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchItemsData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostSwitchType;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualStandardSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPoliciesData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.HostVirtualSwitchPortGroupData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.PortGroupItem;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.model.StandardSwitchPropertiesData;
import com.vmware.vsphere.client.h5.network.host.virtualswitch.spec.VirtualSwitchIdSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.modules.api.network.ProxySwitchSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostVirtualSwitchPropertyProvider
implements PropertyProviderBean {
    private static final String DVS_BY_UUIDS_PROPERTY = "dvsesByUuids";
    private static final String HOST_PORT_GROUPS = "config.network.portgroup";
    private static final Log _logger = LogFactory.getLog(HostVirtualSwitchPropertyProvider.class);
    private QueryBindingService _queryBindingService;
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostVirtualSwitchPropertyProvider(QueryBindingService queryBindingService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryBindingService = queryBindingService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="proxyAndStandardSwitches")
    public HostSwitchItemsData getProxyAndStandardSwitches(ManagedObjectReference hostMor) {
        return this.getHostSwitchItemsData(hostMor, false);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="virtualStandardSwitches")
    public HostSwitchItemsData getVirtualStandardSwitches(ManagedObjectReference hostMor) {
        HostVirtualStandardSwitchData data = (HostVirtualStandardSwitchData)this._queryBindingService.prepare(HostVirtualStandardSwitchData.class).fetch((Object)hostMor);
        if (data == null) {
            return HostSwitchItemsData.newEmptyInstance();
        }
        List<HostSwitchItem> standardSwitchItems = this.getHostVirtualStandardSwitchItems(data.standardSwitches);
        HostSwitchItemsData result = new HostSwitchItemsData();
        result.switchItems = standardSwitchItems.toArray(new HostSwitchItem[standardSwitchItems.size()]);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="allVirtualSwitches")
    public HostSwitchItemsData getAllVirtualSwitches(ManagedObjectReference hostMor) {
        return this.getHostSwitchItemsData(hostMor, true);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="propertiesViewData")
    public StandardSwitchPropertiesData getPropertiesViewData(ManagedObjectReference hostMor, VirtualSwitchIdSpec switchIdSpec) {
        Validate.notNull((Object)switchIdSpec);
        HostVirtualStandardSwitchData data = (HostVirtualStandardSwitchData)this._queryBindingService.prepare(HostVirtualStandardSwitchData.class).fetch((Object)hostMor);
        return HostVirtualSwitchParser.getPropertiesViewData(data, switchIdSpec);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="policiesViewData")
    public HostNetworkDetailsData.PortPolicy getPoliciesViewData(ManagedObjectReference hostMor, VirtualSwitchIdSpec switchIdSpec) {
        Validate.notNull((Object)switchIdSpec);
        HostVirtualSwitchPoliciesData data = (HostVirtualSwitchPoliciesData)this._queryBindingService.prepare(HostVirtualSwitchPoliciesData.class).fetch((Object)hostMor);
        return HostVirtualSwitchParser.getPoliciesViewData(data, switchIdSpec);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="editDialogData")
    public EditStandardSwitchDialogData getEditDialogData(ManagedObjectReference hostMor, VirtualSwitchIdSpec switchIdSpec) {
        Validate.notNull((Object)switchIdSpec);
        EditStandardSwitchData data = (EditStandardSwitchData)this._queryBindingService.prepare(EditStandardSwitchData.class).fetch((Object)hostMor);
        return HostVirtualSwitchParser.getEditDialogData(data, switchIdSpec);
    }

    private HostSwitchItemsData getHostSwitchItemsData(ManagedObjectReference hostMor, boolean includeOpaqueSwitches) {
        HostVirtualSwitchData data = (HostVirtualSwitchData)this._queryBindingService.prepare(HostVirtualSwitchData.class).fetch((Object)hostMor);
        if (data == null) {
            return HostSwitchItemsData.newEmptyInstance();
        }
        ArrayList<HostSwitchItem> hostSwitchItems = new ArrayList<HostSwitchItem>();
        if (data.proxySwitches != null) {
            hostSwitchItems.addAll(this.getHostProxySwitchItems(data, hostMor));
        }
        hostSwitchItems.addAll(this.getHostVirtualStandardSwitchItems(data.standardSwitches));
        if (includeOpaqueSwitches) {
            hostSwitchItems.addAll(this.getHostOpaqueSwitchItems(data.opaqueSwitches));
        }
        HostSwitchItemsData result = new HostSwitchItemsData();
        result.switchItems = hostSwitchItems.toArray(new HostSwitchItem[hostSwitchItems.size()]);
        return result;
    }

    private List<HostSwitchItem> getHostVirtualStandardSwitchItems(VirtualSwitch[] standardSwitches) {
        ArrayList<HostSwitchItem> hostSwitchItems = new ArrayList<HostSwitchItem>();
        if (standardSwitches != null) {
            for (VirtualSwitch vswitch : standardSwitches) {
                if (vswitch == null) continue;
                HostSwitchItem switchItem = new HostSwitchItem();
                switchItem.key = vswitch.key;
                switchItem.name = vswitch.name;
                switchItem.type = HostSwitchType.StandardSwitch;
                switchItem.issueType = HostSwitchIssueType.None;
                switchItem.mtu = vswitch.mtu;
                hostSwitchItems.add(switchItem);
            }
        }
        return hostSwitchItems;
    }

    private List<HostSwitchItem> getHostOpaqueSwitchItems(OpaqueSwitch[] opaqueSwitches) {
        ArrayList<HostSwitchItem> switchItems = new ArrayList<HostSwitchItem>();
        if (!ArrayUtils.isEmpty((Object[])opaqueSwitches)) {
            for (OpaqueSwitch ovs : opaqueSwitches) {
                if (ovs == null) continue;
                HostSwitchItem switchItem = new HostSwitchItem();
                switchItem.key = ovs.key;
                switchItem.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)ovs.name);
                switchItem.type = HostSwitchType.OpaqueSwitch;
                switchItems.add(switchItem);
            }
        }
        return switchItems;
    }

    private List<HostSwitchItem> getHostProxySwitchItems(HostVirtualSwitchData data, ManagedObjectReference hostMor) {
        ArrayList<HostSwitchItem> result = new ArrayList<HostSwitchItem>();
        Map<String, ManagedObjectReference> dvsUuidToMor = this.extractDvsRefs(data);
        Map<String, ProxySwitchSpec> uuidToMissingDvsSpecMap = this.getUuidToMissingDvsSpecMap(hostMor, data);
        for (HostProxySwitch proxySwitch : data.proxySwitches) {
            ProxySwitchSpec spec;
            if (proxySwitch == null) continue;
            HostSwitchItem switchItem = new HostSwitchItem();
            switchItem.key = proxySwitch.key;
            switchItem.dvsUuid = proxySwitch.dvsUuid;
            switchItem.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)proxySwitch.dvsName);
            switchItem.type = HostSwitchType.DistributedSwitch;
            switchItem.isNsxSwitch = Boolean.TRUE.equals(proxySwitch.nsxtEnabled);
            ManagedObjectReference dvsRef = dvsUuidToMor.get(proxySwitch.dvsUuid);
            if (dvsRef == null && (spec = uuidToMissingDvsSpecMap.get(proxySwitch.dvsUuid)) != null) {
                dvsRef = spec.dvsRef;
            }
            switchItem.dvsRef = dvsRef;
            this.populateIssueData(switchItem, proxySwitch, uuidToMissingDvsSpecMap, data.hostName);
            result.add(switchItem);
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="portGroupPropertyViewData")
    public HostNetworkDetailsData getHostPortGroupPropertyViewData(ManagedObjectReference hostMor, String portGroupKey) {
        Validate.notNull((Object)portGroupKey);
        HostVirtualSwitchPortGroupData portGroupsData = (HostVirtualSwitchPortGroupData)this._queryBindingService.prepare(HostVirtualSwitchPortGroupData.class).fetch((Object)hostMor);
        return PortGroupParser.getPortGroupDetails(portGroupsData, portGroupKey);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="portGroupPropertyViewDataByName")
    public HostNetworkDetailsData getPortGroupPropertyViewDataByName(ManagedObjectReference hostMor, String portGroupName) {
        Validate.notNull((Object)portGroupName);
        HostVirtualSwitchPortGroupData portGroupsData = (HostVirtualSwitchPortGroupData)this._queryBindingService.prepare(HostVirtualSwitchPortGroupData.class).fetch((Object)hostMor);
        return PortGroupParser.getPortGroupDetailsByName(portGroupsData, portGroupName);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="virtualswitch", property="portGroups")
    public PortGroupItem[] getPortGroups(ManagedObjectReference hostMor, String vswitch) throws Exception {
        ArrayList<PortGroupItem> portGroupItems = new ArrayList<PortGroupItem>();
        PortGroup[] portGroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostMor, HOST_PORT_GROUPS);
        if (portGroups != null && vswitch != null) {
            for (PortGroup portGroup : portGroups) {
                if (!vswitch.equals(portGroup.vswitch)) continue;
                PortGroupItem portGroupItem = new PortGroupItem();
                portGroupItem.portgroupName = portGroup.spec.name;
                portGroupItem.vlanId = portGroup.spec.vlanId;
                portGroupItem.portgroupKey = portGroup.key;
                if (portGroup.port != null) {
                    portGroupItem.activePorts = portGroup.port.length;
                }
                StringBuilder uplinks = new StringBuilder();
                if (portGroup.computedPolicy.nicTeaming != null && portGroup.computedPolicy.nicTeaming.nicOrder != null) {
                    NetworkPolicy.NicOrderPolicy nicOrder = portGroup.computedPolicy.nicTeaming.nicOrder;
                    if (nicOrder.activeNic != null) {
                        for (String activeNic : nicOrder.activeNic) {
                            if (uplinks.length() > 0) {
                                uplinks.append(", ");
                            }
                            uplinks.append(activeNic);
                        }
                    }
                    if (nicOrder.standbyNic != null) {
                        for (String standbyNic : nicOrder.standbyNic) {
                            if (uplinks.length() > 0) {
                                uplinks.append(", ");
                            }
                            uplinks.append(standbyNic);
                        }
                    }
                }
                portGroupItem.uplinks = uplinks.toString();
                portGroupItems.add(portGroupItem);
            }
        }
        Collections.sort(portGroupItems, new Comparator<PortGroupItem>(){

            @Override
            public int compare(PortGroupItem item1, PortGroupItem item2) {
                if (item1.portgroupName == null && item2.portgroupName == null) {
                    return 0;
                }
                if (item1.portgroupName == null) {
                    return -1;
                }
                if (item2.portgroupName == null) {
                    return 1;
                }
                return item1.portgroupName.compareTo(item2.portgroupName);
            }
        });
        return portGroupItems.toArray(new PortGroupItem[portGroupItems.size()]);
    }

    private Map<String, ProxySwitchSpec> getUuidToMissingDvsSpecMap(ManagedObjectReference hostMor, HostVirtualSwitchData data) {
        String[] missingDvsUuids = this.extractMissingDvsUuids(data);
        ProxySwitchSpec[] missingProxySwitches = this.retrieveMissingProxySwitches(hostMor, missingDvsUuids);
        return this.createUuidToMissingDvsSpecMap(missingProxySwitches);
    }

    private ProxySwitchSpec[] retrieveMissingProxySwitches(ManagedObjectReference hostMor, String[] missingDvsUuids) {
        if (ArrayUtils.isEmpty((Object[])missingDvsUuids)) {
            return null;
        }
        try {
            return (ProxySwitchSpec[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, hostMor, DVS_BY_UUIDS_PROPERTY, missingDvsUuids);
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to load dvsesByUuid property: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private String[] extractMissingDvsUuids(HostVirtualSwitchData data) {
        ArrayList<String> missingUuids = new ArrayList<String>();
        HashSet<String> existingUuids = new HashSet<String>();
        if (data.dvsUuidData != null) {
            for (DvsUuidData dvsUuidData : data.dvsUuidData) {
                if (dvsUuidData == null || !StringUtils.isNotEmpty((CharSequence)dvsUuidData.uuid)) continue;
                existingUuids.add(dvsUuidData.uuid);
            }
        }
        if (data.proxySwitches != null) {
            for (DvsUuidData dvsUuidData : data.proxySwitches) {
                if (!StringUtils.isNotEmpty((CharSequence)dvsUuidData.dvsUuid) || existingUuids.contains(dvsUuidData.dvsUuid)) continue;
                missingUuids.add(dvsUuidData.dvsUuid);
            }
        }
        return missingUuids.toArray(new String[missingUuids.size()]);
    }

    private Map<String, ManagedObjectReference> extractDvsRefs(HostVirtualSwitchData data) {
        HashMap<String, ManagedObjectReference> result = new HashMap<String, ManagedObjectReference>();
        if (data.dvsUuidData != null) {
            for (DvsUuidData dvsUuidData : data.dvsUuidData) {
                if (dvsUuidData == null || !StringUtils.isNotEmpty((CharSequence)dvsUuidData.uuid)) continue;
                result.put(dvsUuidData.uuid, (ManagedObjectReference)dvsUuidData.provider);
            }
        }
        return result;
    }

    private void populateIssueData(HostSwitchItem item, HostProxySwitch proxySwitch, Map<String, ProxySwitchSpec> uuidToMissingDvsSpecMap, String hostName) {
        if (uuidToMissingDvsSpecMap == null || proxySwitch == null || proxySwitch.dvsUuid == null) {
            item.issueType = HostSwitchIssueType.None;
            return;
        }
        ProxySwitchSpec missingDvsProxySpec = uuidToMissingDvsSpecMap.get(proxySwitch.dvsUuid);
        if (missingDvsProxySpec != null) {
            item.isDvsDetached = true;
            item.dvsUuid = proxySwitch.dvsUuid;
        }
        if (missingDvsProxySpec != null && missingDvsProxySpec.isGhostProxySwitch) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.ghostProxySwitchError", hostName);
            item.issueType = HostSwitchIssueType.Alert;
            item.dvsUuid = proxySwitch.dvsUuid;
            item.isGhost = true;
        } else if (this.arePrivilegesMissing(missingDvsProxySpec).booleanValue()) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.noPrivilegesOnDvsWarning");
            item.issueType = HostSwitchIssueType.Warning;
        } else if (!this.arePnicsAttached(proxySwitch).booleanValue()) {
            item.issueText = NetworkStringUtil.getString("HostSwitchIssueType.noHostPnicsAttachedWarning");
            item.issueType = HostSwitchIssueType.Warning;
        } else {
            item.issueType = HostSwitchIssueType.None;
        }
    }

    private HashMap<String, ProxySwitchSpec> createUuidToMissingDvsSpecMap(ProxySwitchSpec[] proxySwitches) {
        HashMap<String, ProxySwitchSpec> uuidToMissingDvsSpecMap = new HashMap<String, ProxySwitchSpec>();
        if (proxySwitches == null) {
            return uuidToMissingDvsSpecMap;
        }
        for (ProxySwitchSpec missingDvsSpec : proxySwitches) {
            uuidToMissingDvsSpecMap.put(missingDvsSpec.dvsUuid, missingDvsSpec);
        }
        return uuidToMissingDvsSpecMap;
    }

    private Boolean arePnicsAttached(HostProxySwitch proxySwitch) {
        return proxySwitch != null && !ArrayUtils.isEmpty((Object[])proxySwitch.pnic);
    }

    private Boolean arePrivilegesMissing(ProxySwitchSpec proxySpec) {
        return proxySpec != null && proxySpec.dvsRef == null && !proxySpec.isGhostProxySwitch;
    }
}

