/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.wizard.addnetworking;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.OpaqueNetworkInfo;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.host.vnic.impl.VnicUtils;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingData;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicIpRoutingInfo;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostVnicMtuInfo;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.PnicBindingDataItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class VnicSettingsPropertyProvider
implements PropertyProviderBean {
    private static final String SUMMARY_PROP = "summary";
    private static final String OPAQUE_NETWORK_PROP = "config/network/opaqueNetwork";
    private static final String OPAQUE_SWITCH_PROP = "config/network/opaqueSwitch";
    private static final String HOST_PNICS_PROP = "config/network/pnic";
    private static final String PROXY_SWITCH_PROP = "config/network/proxySwitch";
    private static final String PORTGROUP_DVS_UUID_PROP = "dvsUuid";
    private static final String MTU_PROPERTY = "config[@type='VMwareDVSConfigInfo'].maxMtu";
    private static final String MTU_CAPABILITY_PROPERTY = "capability/featuresSupported/mtuCapability";
    private static final int DEFAULT_MIN_MTU = 1280;
    private static final int DEFAULT_MAX_MTU = 9000;
    private QueryBindingService _queryBindingService;
    private QueryExecutor _queryExecutor;
    private QueryService _queryService;

    public VnicSettingsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryExecutor queryExecutor, QueryServiceFactory queryServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryExecutor = queryExecutor;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"DistributedVirtualPortgroup"}, propertyNamespace="vnic", property="portgroupMtuData")
    public HostVnicMtuInfo getPortgroupMtuData(ManagedObjectReference portGroupRef) throws Exception {
        PropertyValue[] result = this._queryExecutor.getPropertiesForRelatedObjects((Object)portGroupRef, "dvs", VmwareDistributedVirtualSwitch.class.getSimpleName(), new String[]{MTU_PROPERTY, MTU_CAPABILITY_PROPERTY});
        HostVnicMtuInfo mtuInfo = new HostVnicMtuInfo();
        mtuInfo.mtu = (Integer)Util.getProperty((PropertyValue[])result, (String)MTU_PROPERTY);
        VmwareDistributedVirtualSwitch.MtuCapability mtuCapability = (VmwareDistributedVirtualSwitch.MtuCapability)Util.getProperty((PropertyValue[])result, (String)MTU_CAPABILITY_PROPERTY);
        mtuInfo.minMtuSupported = mtuCapability != null ? mtuCapability.minMtuSupported : 1280;
        mtuInfo.maxMtuSupported = mtuCapability != null ? mtuCapability.maxMtuSupported : 9000;
        return mtuInfo;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdapterIpRouting")
    public HostVnicIpRoutingInfo getVirtualAdapterIpRouting(ManagedObjectReference hostRef, String selectedNetStackKey) {
        HostVnicIpRoutingInfo ipRoutingInfo = new HostVnicIpRoutingInfo();
        HostVnicIpRoutingData ipRoutingData = this.fetchHostIpRoutingInfo(hostRef);
        if (ipRoutingData == null) {
            return ipRoutingInfo;
        }
        if (ipRoutingData.isTcpIpStackSupported) {
            NetStackInstance selectedNetStackInstance = null;
            if (!ArrayUtils.isEmpty((Object[])ipRoutingData.netStackInstances)) {
                for (NetStackInstance netStackInstance : ipRoutingData.netStackInstances) {
                    if (selectedNetStackKey == null || !selectedNetStackKey.equals(netStackInstance.key)) continue;
                    selectedNetStackInstance = netStackInstance;
                    break;
                }
                if (selectedNetStackInstance != null) {
                    if (selectedNetStackInstance.ipRouteConfig != null) {
                        ipRoutingInfo.ipv4DefaultGateway = selectedNetStackInstance.ipRouteConfig.defaultGateway;
                        ipRoutingInfo.ipv6DefaultGateway = selectedNetStackInstance.ipRouteConfig.ipV6DefaultGateway;
                    }
                    if (selectedNetStackInstance.dnsConfig != null) {
                        ipRoutingInfo.dnsAddresses = selectedNetStackInstance.dnsConfig.address;
                    }
                }
            }
        } else {
            if (ipRoutingData.ipRouteConfig != null) {
                ipRoutingInfo.ipv4DefaultGateway = ipRoutingData.ipRouteConfig.defaultGateway;
                ipRoutingInfo.ipv6DefaultGateway = ipRoutingData.ipRouteConfig.ipV6DefaultGateway;
            }
            if (ipRoutingData.dnsConfig != null) {
                ipRoutingInfo.dnsAddresses = ipRoutingData.dnsConfig.address;
            }
        }
        HashMap<String, Set<String>> hostIpv6Addresses = new HashMap<String, Set<String>>();
        if (!ArrayUtils.isEmpty((Object[])ipRoutingData.consoleVnic)) {
            hostIpv6Addresses.putAll(VnicUtils.getHostIpAddresses(ipRoutingData.consoleVnic));
        }
        if (!ArrayUtils.isEmpty((Object[])ipRoutingData.vnic)) {
            hostIpv6Addresses.putAll(VnicUtils.getHostIpAddresses(ipRoutingData.vnic));
        }
        if (hostIpv6Addresses.size() > 0) {
            ipRoutingInfo.hostIpv6Addresses = hostIpv6Addresses;
        }
        ipRoutingInfo.isGatewayFeatureSupported = ipRoutingData.isGatewayFeatureSupported;
        return ipRoutingInfo;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="availablePnicsForBindingBySummary")
    public PnicBindingDataItem[] getAvailablePnicsForBindingBySummary(ManagedObjectReference hostRef, Map<String, String> properies) {
        OpaqueNetwork.Summary opaqueNetworkSummary = new OpaqueNetwork.Summary();
        opaqueNetworkSummary.opaqueNetworkId = properies.get("opaqueNetworkId");
        opaqueNetworkSummary.opaqueNetworkType = properies.get("opaqueNetworkType");
        return this.getAvailablePnics(hostRef, opaqueNetworkSummary);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="availablePnicsForBinding")
    public PnicBindingDataItem[] getAvailablePnicsForBinding(ManagedObjectReference hostRef, ManagedObjectReference opaqueNetworkRef) {
        OpaqueNetwork.Summary opaqueNetworkSummary = (OpaqueNetwork.Summary)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)opaqueNetworkRef, (String)SUMMARY_PROP);
        return this.getAvailablePnics(hostRef, opaqueNetworkSummary);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="availablePnicsForBindingByDvpg")
    public PnicBindingDataItem[] getDvpgAvailablePnicsForBinding(ManagedObjectReference hostRef, ManagedObjectReference dvpgRef) {
        ResourceItem ri;
        ResultSet hostResultSet;
        ResourceItem ri2;
        ArrayList<PnicBindingDataItem> result = new ArrayList<PnicBindingDataItem>();
        ResultSet dvsResultSet = this._queryService.select(new String[]{PORTGROUP_DVS_UUID_PROP}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvpgRef)}).fetch();
        String dvsUuid = null;
        if (!dvsResultSet.getItems().isEmpty() && (ri2 = (ResourceItem)dvsResultSet.getItems().get(0)) != null) {
            dvsUuid = (String)ri2.get(PORTGROUP_DVS_UUID_PROP);
        }
        if (dvsUuid != null && !(hostResultSet = this._queryService.select(new String[]{PROXY_SWITCH_PROP, HOST_PNICS_PROP}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch()).getItems().isEmpty() && (ri = (ResourceItem)hostResultSet.getItems().get(0)) != null) {
            HostProxySwitch[] proxySwitches = (HostProxySwitch[])ri.get(PROXY_SWITCH_PROP);
            PhysicalNic[] physicalNics = (PhysicalNic[])ri.get(HOST_PNICS_PROP);
            HostProxySwitch proxySwitch = this.getProxySwitchByUuid(proxySwitches, dvsUuid);
            if (proxySwitch != null) {
                result.addAll(this.getAvailablePnicsForNSXPortgroup(proxySwitch, physicalNics));
            }
        }
        return result.toArray(new PnicBindingDataItem[result.size()]);
    }

    private List<PnicBindingDataItem> getAvailablePnicsForNSXPortgroup(HostProxySwitch hps, PhysicalNic[] physicalNics) {
        ArrayList<PnicBindingDataItem> result = new ArrayList<PnicBindingDataItem>();
        HashMap<String, PhysicalNic> pnicsByKey = new HashMap<String, PhysicalNic>();
        if (physicalNics != null) {
            for (PhysicalNic pnic : physicalNics) {
                pnicsByKey.put(pnic.key, pnic);
            }
        }
        Set<String> nsxPnicDevices = this.getNsxUsedPnics(hps);
        if (hps.pnic != null) {
            for (String pnicKey : hps.pnic) {
                PhysicalNic pnic = (PhysicalNic)pnicsByKey.get(pnicKey);
                if (pnic == null || !nsxPnicDevices.contains(pnic.device)) continue;
                PnicBindingDataItem item = new PnicBindingDataItem();
                item.pnicId = pnic.key;
                item.device = pnic.device;
                result.add(item);
            }
        }
        Collections.sort(result, new Comparator<PnicBindingDataItem>(){

            @Override
            public int compare(PnicBindingDataItem o1, PnicBindingDataItem o2) {
                return o1.device.compareTo(o2.device);
            }
        });
        return result;
    }

    private PnicBindingDataItem[] getAvailablePnics(ManagedObjectReference hostRef, OpaqueNetwork.Summary opaqueNetworkSummary) {
        Map hostProperties = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)hostRef, (String[])new String[]{OPAQUE_NETWORK_PROP, OPAQUE_SWITCH_PROP, HOST_PNICS_PROP});
        OpaqueSwitch[] opaqueSwitches = (OpaqueSwitch[])hostProperties.get(OPAQUE_SWITCH_PROP);
        OpaqueNetworkInfo[] opaqueNetworkInfos = (OpaqueNetworkInfo[])hostProperties.get(OPAQUE_NETWORK_PROP);
        PhysicalNic[] hostPhysicalNics = (PhysicalNic[])hostProperties.get(HOST_PNICS_PROP);
        OpaqueNetworkInfo selectedOpaqueNetwork = DvsAddHostWizardUtil.getOpaqueNetworkByTypeAndId(opaqueNetworkInfos, opaqueNetworkSummary);
        if (selectedOpaqueNetwork == null) {
            return new PnicBindingDataItem[0];
        }
        OpaqueSwitch matchingOpaqueSwitch = DvsAddHostWizardUtil.getOpaqueSwitchByOpaqueNetwork(selectedOpaqueNetwork, opaqueSwitches);
        if (matchingOpaqueSwitch == null) {
            return new PnicBindingDataItem[0];
        }
        String[] switchPnicIds = matchingOpaqueSwitch.pnic;
        if (switchPnicIds == null || hostPhysicalNics == null) {
            return new PnicBindingDataItem[0];
        }
        ArrayList<PnicBindingDataItem> pnicItems = new ArrayList<PnicBindingDataItem>();
        for (String pnicId : switchPnicIds) {
            for (PhysicalNic pnic : hostPhysicalNics) {
                if (!pnicId.equals(pnic.key)) continue;
                PnicBindingDataItem pnicBindingDataItem = new PnicBindingDataItem();
                pnicBindingDataItem.device = pnic.device;
                pnicBindingDataItem.pnicId = pnic.key;
                pnicItems.add(pnicBindingDataItem);
            }
        }
        Collections.sort(pnicItems, new Comparator<PnicBindingDataItem>(){

            @Override
            public int compare(PnicBindingDataItem o1, PnicBindingDataItem o2) {
                return o1.device.compareTo(o2.device);
            }
        });
        return pnicItems.toArray(new PnicBindingDataItem[pnicItems.size()]);
    }

    private HostVnicIpRoutingData fetchHostIpRoutingInfo(ManagedObjectReference hostRef) {
        return (HostVnicIpRoutingData)this._queryBindingService.prepare(HostVnicIpRoutingData.class).fetch((Object)hostRef);
    }

    private HostProxySwitch getProxySwitchByUuid(HostProxySwitch[] proxySwitches, String uuid) {
        if (proxySwitches != null) {
            for (HostProxySwitch hps : proxySwitches) {
                if (!hps.dvsUuid.equals(uuid)) continue;
                return hps;
            }
        }
        return null;
    }

    private Set<String> getNsxUsedPnics(HostProxySwitch hps) {
        HashSet nsxUsedUplinkPorts = new HashSet();
        if (hps.nsxUsedUplinkPort != null) {
            Collections.addAll(nsxUsedUplinkPorts, hps.nsxUsedUplinkPort);
        }
        HashSet<String> nsxUsedUplinkPortKeys = new HashSet<String>();
        if (hps.uplinkPort != null) {
            for (KeyValue uplinkPort : hps.uplinkPort) {
                if (!nsxUsedUplinkPorts.contains(uplinkPort.value)) continue;
                nsxUsedUplinkPortKeys.add(uplinkPort.key);
            }
        }
        HashSet<String> nsxPnicDevices = new HashSet<String>();
        if (hps.spec != null && hps.spec.backing instanceof HostMember.PnicBacking) {
            HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)hps.spec.backing;
            if (pnicBacking.pnicSpec != null) {
                for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                    if (!nsxUsedUplinkPortKeys.contains(pnicSpec.uplinkPortKey)) continue;
                    nsxPnicDevices.add(pnicSpec.pnicDevice);
                }
            }
        }
        return nsxPnicDevices;
    }
}

