/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.moveto;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.moveto.MoveService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MoveNetworkPropertyProvider {
    private static final String DC_PROPERTY = "dc";
    private final QueryService queryService;
    private final MoveService moveService;

    public MoveNetworkPropertyProvider(MoveService moveService, QueryServiceFactory queryServiceFactory) {
        this.queryService = queryServiceFactory.getQueryService();
        this.moveService = moveService;
    }

    @PropertyProvider(value="Network/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailableForStandardNetwork(Collection<ManagedObjectReference> networkRefs) {
        return this.getPropertyForNetwork(networkRefs, Network.class.getSimpleName());
    }

    @PropertyProvider(value="OpaqueNetwork/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailableForOpaqueNetwork(Collection<ManagedObjectReference> networkRefs) {
        return this.getPropertyForNetwork(networkRefs, OpaqueNetwork.class.getSimpleName());
    }

    @PropertyProvider(value="DistributedVirtualSwitch/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailableForDvs(Collection<ManagedObjectReference> dvsRefs) {
        return this.getPropertyForNetwork(dvsRefs, DistributedVirtualSwitch.class.getSimpleName());
    }

    @PropertyProvider(value="VmwareDistributedVirtualSwitch/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailableForVmwareDvs(Collection<ManagedObjectReference> dvsRefs) {
        return this.getPropertyForNetwork(dvsRefs, VmwareDistributedVirtualSwitch.class.getSimpleName());
    }

    private List<Boolean> getPropertyForNetwork(Collection<ManagedObjectReference> networkRefs, String networkClassName) {
        if (networkRefs.size() == 1) {
            return Collections.singletonList(true);
        }
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, networkRefs));
        ResultSet resultSet = this.queryService.select(new String[]{"@modelKey", DC_PROPERTY}).from(new String[]{networkClassName}).where(LogicalOperator.AND, filter).fetch();
        boolean areNetworksFromOneDc = this.moveService.areObjectsFromOneDc(resultSet.getItems());
        return new ArrayList<Boolean>(Collections.nCopies(networkRefs.size(), areNetworksFromOneDc));
    }
}

