/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.OpaqueNetworkSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class OpaqueNetworkPropertyProvider
implements PropertyProviderBean {
    private static final String VM_PROPERTY = "vm";
    private static final String VM_OPAQUE_NETWORK_PROPERTY = "opaquenetwork";
    private static final String HOST_OPAQUE_NETWORK_RELATION = "opaquenetwork";
    private static final String OPAQUE_NETWORK_NAME_PROPERTY = "name";
    private static final String OVS_DIAGRAM_VM_NET_QUERY_SPEC = "ovsdiagram-vmnet";
    private static final String OVS_DIAGRAM_NET_PROPS_QUERY_SPEC = "ovsdiagram-network-props";
    private DataService dataService;

    public OpaqueNetworkPropertyProvider(DataService dataService) {
        this.dataService = dataService;
    }

    @type(value="HostSystem")
    public OpaqueNetworkSpec[] getOpaqueNetworkSpec(ManagedObjectReference hostRef) {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = this.getNetworksAndVmsQuerySpecs(hostRef);
        Response response = this.dataService.getData(requestSpec);
        ResultSet networksResultSet = this.getResultSetForQuery(response, OVS_DIAGRAM_NET_PROPS_QUERY_SPEC);
        Map<ManagedObjectReference, OpaqueNetworkSpec> opaqueNetworkSpecMap = this.getOpaqueNetworkSpecMap(networksResultSet);
        ResultSet vmsResultSet = this.getResultSetForQuery(response, OVS_DIAGRAM_VM_NET_QUERY_SPEC);
        this.updateVmCounts(vmsResultSet, opaqueNetworkSpecMap);
        ArrayList<OpaqueNetworkSpec> result = new ArrayList<OpaqueNetworkSpec>();
        result.addAll(opaqueNetworkSpecMap.values());
        return result.toArray(new OpaqueNetworkSpec[result.size()]);
    }

    private QuerySpec[] getNetworksAndVmsQuerySpecs(ManagedObjectReference hostRef) {
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)hostRef);
        RelationalConstraint hostsVmsConstraint = QueryUtil.createRelationalConstraint((String)VM_PROPERTY, (Constraint)hostConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        QuerySpec querySpecVms = QueryUtil.buildQuerySpec((Constraint)hostsVmsConstraint, (String[])new String[]{"opaquenetwork"});
        querySpecVms.name = OVS_DIAGRAM_VM_NET_QUERY_SPEC;
        querySpecs.add(querySpecVms);
        RelationalConstraint hostsNetworksConstraint = QueryUtil.createRelationalConstraint((String)"opaquenetwork", (Constraint)hostConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        QuerySpec querySpecNetworks = QueryUtil.buildQuerySpec((Constraint)hostsNetworksConstraint, (String[])new String[]{OPAQUE_NETWORK_NAME_PROPERTY});
        querySpecNetworks.name = OVS_DIAGRAM_NET_PROPS_QUERY_SPEC;
        querySpecs.add(querySpecNetworks);
        return querySpecs.toArray(new QuerySpec[querySpecs.size()]);
    }

    private Map<ManagedObjectReference, OpaqueNetworkSpec> getOpaqueNetworkSpecMap(ResultSet resultSet) {
        HashMap<ManagedObjectReference, OpaqueNetworkSpec> opaqueNetworkSpecMap = new HashMap<ManagedObjectReference, OpaqueNetworkSpec>();
        if (resultSet != null && !ArrayUtils.isEmpty((Object[])resultSet.items)) {
            for (ResultItem ri : resultSet.items) {
                String networkName = (String)this.getPropertyValue(ri, OPAQUE_NETWORK_NAME_PROPERTY);
                if (networkName == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                OpaqueNetworkSpec spec = new OpaqueNetworkSpec();
                spec.name = networkName;
                spec.provider = (ManagedObjectReference)ri.resourceObject;
                spec.vmCount = 0;
                opaqueNetworkSpecMap.put(spec.provider, spec);
            }
        }
        return opaqueNetworkSpecMap;
    }

    private void updateVmCounts(ResultSet vmResultSpec, Map<ManagedObjectReference, OpaqueNetworkSpec> opaqueNetworkSpecMap) {
        if (vmResultSpec != null && vmResultSpec.items != null) {
            for (ResultItem ri : vmResultSpec.items) {
                ManagedObjectReference[] networkRefs = (ManagedObjectReference[])this.getPropertyValue(ri, "opaquenetwork");
                if (networkRefs == null) continue;
                for (ManagedObjectReference mor : networkRefs) {
                    OpaqueNetworkSpec spec = opaqueNetworkSpecMap.get(mor);
                    if (spec == null) continue;
                    ++spec.vmCount;
                }
            }
        }
    }

    private ResultSet getResultSetForQuery(Response response, String queryName) {
        if (response.resultSet == null) {
            return null;
        }
        for (ResultSet resultSet : response.resultSet) {
            if (!queryName.equals(resultSet.queryName)) continue;
            return resultSet;
        }
        return null;
    }

    private <T> T getPropertyValue(ResultItem ri, String propertyName) {
        if (ri != null && !ArrayUtils.isEmpty((Object[])ri.properties)) {
            for (PropertyValue pv : ri.properties) {
                if (pv == null || !propertyName.equals(pv.propertyName)) continue;
                try {
                    return (T)pv.value;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

