/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000e;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet2;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet3;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.SwitchDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovPortModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.switchdiagram.SwitchDiagramBuilderBase;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.VirtualDeviceType;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramExternalPnicSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SwitchDiagramPortgroupVmsBuilderImpl
extends SwitchDiagramBuilderBase
implements SwitchDiagramPortgroupVmsBuilder {
    private static final String UNBOUND_VM_KEY_PREFIX = "UNB_";
    private boolean initialized;
    private SwitchDiagramSpec _switchDiagramSpec;
    private String _dvsUuid;
    private Set<String> _portgroupKeys;
    private Set<String> _nsxPortgroupKeys = new HashSet<String>();
    private Set<SwitchDiagramVmSpec> _vmSpecs = new HashSet<SwitchDiagramVmSpec>();
    private Map<ManagedObjectReference, String[]> _nsxUsedUplinksMap = new HashMap<ManagedObjectReference, String[]>();
    private SwitchDiagramExternalPnicSpec[] _externalPnicCandidates = null;
    private Map<String, DistributedVirtualPort> _portsMap = new HashMap<String, DistributedVirtualPort>();

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String[] portgroupKeys) {
        if (switchDiagramSpec == null) {
            throw new IllegalArgumentException("switchDiagramSpec cannot be null");
        }
        if (switchDiagramSpec.dvsSpec == null) {
            throw new IllegalArgumentException("dvsSpec cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)dvsUuid)) {
            throw new IllegalArgumentException("dvsUuid cannot be null or empty");
        }
        this._switchDiagramSpec = switchDiagramSpec;
        this._dvsUuid = dvsUuid;
        this._portgroupKeys = new HashSet<String>(Arrays.asList(portgroupKeys));
    }

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String[] portgroupKeys, SwitchDiagramExternalPnicSpec[] externalPnicCandidates) {
        this(switchDiagramSpec, dvsUuid, portgroupKeys);
        this._externalPnicCandidates = externalPnicCandidates;
    }

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String[] portgroupKeys, SwitchDiagramExternalPnicSpec[] externalPnicCandidates, String[] nsxPortgroupKeys) {
        this(switchDiagramSpec, dvsUuid, portgroupKeys);
        this._externalPnicCandidates = externalPnicCandidates;
        this._nsxPortgroupKeys.addAll(Arrays.asList(nsxPortgroupKeys));
    }

    public List<PortGroupModel> buildPortgroupVmsModels() {
        ArrayList<PortGroupModel> portGroupModels = new ArrayList<PortGroupModel>();
        this.initialize();
        for (String portgroupKey : this._portgroupKeys) {
            PortGroupModel portGroupModel = new PortGroupModel();
            portGroupModel.portgroupKey = portgroupKey;
            this.addVirtualMachines(portGroupModel, portgroupKey);
            this.sortVms(portGroupModel.vmVnics);
            portGroupModels.add(portGroupModel);
        }
        return portGroupModels;
    }

    public List<SriovAdapterModel> buildExternalSriovPnicModels() {
        ArrayList<SriovAdapterModel> externalSriovAdapterModels = new ArrayList<SriovAdapterModel>();
        this.initialize();
        if (this._externalPnicCandidates != null) {
            SwitchDiagramVmSpec[] vmSpecs = this._vmSpecs.toArray(new SwitchDiagramVmSpec[this._vmSpecs.size()]);
            for (SwitchDiagramExternalPnicSpec externalPnicSpec : this._externalPnicCandidates) {
                externalSriovAdapterModels.addAll(SwitchDiagramUtil.buildExternalSriovPnicModels(externalPnicSpec, vmSpecs));
            }
        }
        return externalSriovAdapterModels;
    }

    private void initialize() {
        if (!this.initialized) {
            this.initializeVmSpecsSet();
            this.initializePortsMap();
            this.initializeNsxUsedUplinksMap();
            this.initialized = true;
        }
    }

    private void sortVms(List<PortModel> vmVnics) {
        Collections.sort(vmVnics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vm1, PortModel vm2) {
                return vm1.title.compareToIgnoreCase(vm2.title);
            }
        });
    }

    private void initializeNsxUsedUplinksMap() {
        if (!ArrayUtils.isEmpty((Object[])this._switchDiagramSpec.dvsSpec.hostMembers)) {
            for (HostMember hostMember : this._switchDiagramSpec.dvsSpec.hostMembers) {
                if (hostMember.config == null || ArrayUtils.isEmpty((Object[])hostMember.config.nsxtUsedUplinkNames)) continue;
                this._nsxUsedUplinksMap.put(hostMember.config.host, hostMember.config.nsxtUsedUplinkNames);
            }
        }
    }

    private void initializeVmSpecsSet() {
        if (!ArrayUtils.isEmpty((Object[])this._switchDiagramSpec.dvsSpec.vms)) {
            for (SwitchDiagramVmSpec vmSpec : this._switchDiagramSpec.dvsSpec.vms) {
                if (StringUtils.isEmpty((CharSequence)vmSpec.name)) continue;
                this._vmSpecs.add(vmSpec);
            }
        }
    }

    private void initializePortsMap() {
        if (!ArrayUtils.isEmpty((Object[])this._switchDiagramSpec.nonUplinkPorts)) {
            for (DistributedVirtualPort distributedVirtualPort : this._switchDiagramSpec.nonUplinkPorts) {
                if (distributedVirtualPort == null || !StringUtils.isNotEmpty((CharSequence)distributedVirtualPort.key)) continue;
                this._portsMap.put(distributedVirtualPort.key, distributedVirtualPort);
            }
        }
    }

    private void addVirtualMachines(PortGroupModel portGroupModel, String portgroupKey) {
        HashMap<ManagedObjectReference, List<PortModel>> vmToPortModelMap = new HashMap<ManagedObjectReference, List<PortModel>>();
        for (SwitchDiagramVmSpec vmSpec : this._vmSpecs) {
            boolean isSecondaryVm = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
            if (isSecondaryVm || ArrayUtils.isEmpty((Object[])vmSpec.devices)) continue;
            ArrayList<VirtualDevice> portBackingDevicesForPortgroup = new ArrayList<VirtualDevice>();
            for (VirtualDevice device : vmSpec.devices) {
                if (!(device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) || ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port == null || !this._dvsUuid.equals(((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port.switchUuid) || !Objects.equals(portgroupKey, ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port.portgroupKey)) continue;
                portBackingDevicesForPortgroup.add(device);
            }
            boolean includeMac = portBackingDevicesForPortgroup.size() > 1;
            for (VirtualDevice device : portBackingDevicesForPortgroup) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo deviceBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                DistributedVirtualPort port = this._portsMap.get(deviceBacking.port.portKey);
                PortModel portModel = this.createPortModel(vmSpec, device, port, includeMac);
                portGroupModel.vmVnics.add(portModel);
                this.mapVmToPortView(vmSpec.provider, portModel, vmToPortModelMap);
            }
        }
        this.processPortViewsMacAddress(vmToPortModelMap);
    }

    private PortModel createPortModel(SwitchDiagramVmSpec vmSpec, VirtualDevice device, DistributedVirtualPort port, boolean includeMac) {
        SriovPortModel portModel = device instanceof VirtualSriovEthernetCard ? new SriovPortModel() : new PortModel();
        portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
        portModel.title = this.getVmTitle(vmSpec);
        if (vmSpec.provider != null) {
            portModel.vmValue = vmSpec.provider.getValue();
            portModel.id = UNBOUND_VM_KEY_PREFIX + vmSpec.provider.getValue() + device.key;
        }
        portModel.portStatus = PortStatus.NA;
        if (port != null) {
            if (port.key != null) {
                portModel.id = port.key;
            }
            portModel.portStatus = this.getPortConnectionStatus(port);
        }
        if (vmSpec.connectionState == VirtualMachine.ConnectionState.orphaned) {
            portModel.isOrphanedVm = true;
        }
        portModel.vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
        portModel.powerState = vmSpec.powerState;
        portModel.virtualDeviceKey = device.key;
        if (vmSpec.host != null) {
            portModel.hostValue = vmSpec.host.getValue();
        }
        if (includeMac) {
            portModel.macAddress = SwitchDiagramUtil.getMacAddress(port, device);
        }
        if (device instanceof VirtualSriovEthernetCard) {
            if (((VirtualSriovEthernetCard)device).sriovBacking != null && ((VirtualSriovEthernetCard)device).sriovBacking.physicalFunctionBacking != null) {
                portModel.physicalFunctionId = ((VirtualSriovEthernetCard)device).sriovBacking.physicalFunctionBacking.id;
            }
            portModel.virtualDeviceType = VirtualDeviceType.SRIOV_PASSTHROUGH.name();
        } else if (device instanceof VirtualE1000) {
            portModel.virtualDeviceType = VirtualDeviceType.E1000.name();
        } else if (device instanceof VirtualE1000e) {
            portModel.virtualDeviceType = VirtualDeviceType.E1000E.name();
        } else if (device instanceof VirtualVmxnet2) {
            portModel.virtualDeviceType = VirtualDeviceType.VMXNET2.name();
        } else if (device instanceof VirtualVmxnet3) {
            portModel.virtualDeviceType = VirtualDeviceType.VMXNET3.name();
        }
        portModel.activeUplinkPorts = this.getActiveUplinkPorts((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing);
        return portModel;
    }

    private String getVmTitle(SwitchDiagramVmSpec vmSpec) {
        String vmName = null;
        if (vmSpec != null) {
            boolean showSecondaryText = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
            vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
            if (showSecondaryText && vmName != null) {
                vmName = vmName + NetworkStringUtil.getString("SwitchDiagram.secondaryText");
            }
        }
        return vmName;
    }

    private void mapVmToPortView(ManagedObjectReference vm, PortModel portModel, Map<ManagedObjectReference, List<PortModel>> vmToPortView) {
        List<PortModel> vmPortModels = vmToPortView.get(vm);
        if (vmPortModels == null) {
            vmPortModels = new ArrayList<PortModel>();
            vmToPortView.put(vm, vmPortModels);
        }
        vmPortModels.add(portModel);
    }

    private String[] getActiveUplinkPorts(VirtualEthernetCard.DistributedVirtualPortBackingInfo portBackingInfo) {
        DistributedVirtualPort dvPort;
        String[] result = null;
        if (portBackingInfo != null && portBackingInfo.port != null && StringUtils.isNotEmpty((CharSequence)portBackingInfo.port.portKey) && (dvPort = this._portsMap.get(portBackingInfo.port.portKey)) != null) {
            if (this._nsxPortgroupKeys.contains(dvPort.portgroupKey)) {
                result = this._nsxUsedUplinksMap.get(dvPort.proxyHost);
            } else if (dvPort.config != null && dvPort.config.setting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
                VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy policy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPort.config.setting;
                if (policy.uplinkTeamingPolicy != null && policy.uplinkTeamingPolicy.uplinkPortOrder != null) {
                    result = policy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort;
                }
            }
        }
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    private void processPortViewsMacAddress(Map<ManagedObjectReference, List<PortModel>> vmToPortModelMap) {
        for (Map.Entry<ManagedObjectReference, List<PortModel>> entry : vmToPortModelMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (PortModel portModel : entry.getValue()) {
                if (portModel.macAddress != null || portModel.virtualDevice == null) continue;
                portModel.macAddress = SwitchDiagramUtil.getMacAddress(null, portModel.virtualDevice);
            }
        }
    }
}

