/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000;
import com.vmware.vim.binding.vim.vm.device.VirtualE1000e;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet2;
import com.vmware.vim.binding.vim.vm.device.VirtualVmxnet3;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovPortModel;
import com.vmware.vsphere.client.h5.network.switchdiagram.model.internal.VirtualDeviceType;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.VssDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramExternalPnicSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class VssDiagramPortgroupVmsBuilderImpl
implements VssDiagramPortgroupVmsBuilder {
    private SwitchDiagramVmSpec[] vmSpecs;
    private Map<String, PortGroupModel> portgroupsByNetworkName = new HashMap<String, PortGroupModel>();
    private Set<ManagedObjectReference> networkRefsSet = new HashSet<ManagedObjectReference>();

    public VssDiagramPortgroupVmsBuilderImpl(SwitchDiagramVmSpec[] vmSpecs, ManagedObjectReference[] networkRefs) {
        if (vmSpecs == null) {
            throw new IllegalArgumentException("vmSpecs cannot be null");
        }
        if (networkRefs == null) {
            throw new IllegalArgumentException("networkRefs cannot be null");
        }
        this.vmSpecs = vmSpecs;
        this.networkRefsSet.addAll(Arrays.asList(networkRefs));
    }

    public List<PortGroupModel> buildPortgroupVmsModels() {
        for (SwitchDiagramVmSpec vmSpec : this.vmSpecs) {
            if (ArrayUtils.isEmpty((Object[])vmSpec.devices)) continue;
            Map<ManagedObjectReference, List<VirtualDevice>> devicesPerNetwork = this.getDevicesPerNetwork(vmSpec.devices);
            for (ManagedObjectReference networkRef : this.networkRefsSet) {
                List<VirtualDevice> devices = devicesPerNetwork.get(networkRef);
                if (devices == null) continue;
                boolean includeMac = devices.size() > 1;
                for (VirtualDevice device : devices) {
                    PortGroupModel portGroup = this.getPortgroupByName(((VirtualEthernetCard.NetworkBackingInfo)device.backing).deviceName);
                    PortModel portModel = this.buildPortModel(device, vmSpec, includeMac);
                    portGroup.vmVnics.add(portModel);
                }
            }
        }
        Collection<PortGroupModel> portgroupModels = this.portgroupsByNetworkName.values();
        for (PortGroupModel portGroupModel : portgroupModels) {
            this.sortVms(portGroupModel.vmVnics);
        }
        return new ArrayList<PortGroupModel>(portgroupModels);
    }

    public List<SriovAdapterModel> buildExternalSriovPnicModels(SwitchDiagramExternalPnicSpec externalPnicSpec) {
        return SwitchDiagramUtil.buildExternalSriovPnicModels(externalPnicSpec, this.vmSpecs);
    }

    private PortModel buildPortModel(VirtualDevice networkAdapter, SwitchDiagramVmSpec vmSpec, boolean includeMac) {
        SriovPortModel portModel;
        if (networkAdapter instanceof VirtualSriovEthernetCard) {
            portModel = new SriovPortModel();
            if (((VirtualSriovEthernetCard)networkAdapter).sriovBacking != null && ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking != null) {
                portModel.physicalFunctionId = ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking.id;
            }
        } else {
            portModel = new PortModel();
        }
        portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
        portModel.id = vmSpec.provider.getValue() + Integer.toString(networkAdapter.key);
        portModel.virtualDeviceKey = networkAdapter.key;
        portModel.vmName = vmSpec.name;
        portModel.title = vmSpec.name;
        portModel.powerState = vmSpec.powerState;
        portModel.portStatus = VirtualMachine.PowerState.poweredOn.equals((Object)vmSpec.powerState) ? PortStatus.CONNECTED : PortStatus.DISCONNECTED;
        portModel.isOrphanedVm = VirtualMachine.ConnectionState.orphaned.equals((Object)vmSpec.connectionState);
        portModel.vmValue = vmSpec.provider.getValue();
        if (includeMac) {
            portModel.macAddress = ((VirtualEthernetCard)networkAdapter).macAddress;
        }
        if (networkAdapter instanceof VirtualSriovEthernetCard) {
            if (((VirtualSriovEthernetCard)networkAdapter).sriovBacking != null && ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking != null) {
                portModel.physicalFunctionId = ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking.id;
            }
            portModel.virtualDeviceType = VirtualDeviceType.SRIOV_PASSTHROUGH.name();
        } else if (networkAdapter instanceof VirtualE1000) {
            portModel.virtualDeviceType = VirtualDeviceType.E1000.name();
        } else if (networkAdapter instanceof VirtualE1000e) {
            portModel.virtualDeviceType = VirtualDeviceType.E1000E.name();
        } else if (networkAdapter instanceof VirtualVmxnet2) {
            portModel.virtualDeviceType = VirtualDeviceType.VMXNET2.name();
        } else if (networkAdapter instanceof VirtualVmxnet3) {
            portModel.virtualDeviceType = VirtualDeviceType.VMXNET3.name();
        }
        return portModel;
    }

    private Map<ManagedObjectReference, List<VirtualDevice>> getDevicesPerNetwork(VirtualDevice[] devices) {
        HashMap<ManagedObjectReference, List<VirtualDevice>> result = new HashMap<ManagedObjectReference, List<VirtualDevice>>();
        for (VirtualDevice device : devices) {
            if (device == null || !(device.backing instanceof VirtualEthernetCard.NetworkBackingInfo)) continue;
            VirtualEthernetCard.NetworkBackingInfo backing = (VirtualEthernetCard.NetworkBackingInfo)device.backing;
            if (backing.network == null || !this.networkRefsSet.contains(backing.network)) continue;
            ArrayList<VirtualDevice> devicesOnNetwork = (ArrayList<VirtualDevice>)result.get(backing.network);
            if (devicesOnNetwork == null) {
                devicesOnNetwork = new ArrayList<VirtualDevice>();
                result.put(backing.network, devicesOnNetwork);
            }
            devicesOnNetwork.add(device);
        }
        return result;
    }

    private PortGroupModel getPortgroupByName(String name) {
        PortGroupModel portGroup = this.portgroupsByNetworkName.get(name);
        if (portGroup == null) {
            portGroup = new PortGroupModel();
            portGroup.id = name;
            this.portgroupsByNetworkName.put(name, portGroup);
        }
        return portGroup;
    }

    private void sortVms(List<PortModel> vmVnics) {
        Collections.sort(vmVnics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vm1, PortModel vm2) {
                return vm1.vmName.compareToIgnoreCase(vm2.vmName);
            }
        });
    }
}

