/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vsphere.client.h5.network.host.pnic.PnicParser;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.model.NetworkPolicyData;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;

public class NetworkPolicyUtil {
    public static NetworkPolicyData.SecurityPolicies getSecurityPolicies(NetworkPolicy vSwitchNetworkPolicy, NetworkPolicy portgroupNetworkPolicy) {
        NetworkPolicyData.SecurityPolicies securityPolicies = new NetworkPolicyData.SecurityPolicies();
        boolean isPortgroupSecurityPolicyDefined = portgroupNetworkPolicy != null && portgroupNetworkPolicy.security != null;
        boolean isVSwitchSecurityPolicyDefined = vSwitchNetworkPolicy != null && vSwitchNetworkPolicy.security != null;
        boolean bl = securityPolicies.isPromiscuousModeOverriden = isPortgroupSecurityPolicyDefined && portgroupNetworkPolicy.security.allowPromiscuous != null;
        securityPolicies.allowPromiscuousMode = securityPolicies.isPromiscuousModeOverriden ? portgroupNetworkPolicy.security.allowPromiscuous : isVSwitchSecurityPolicyDefined && vSwitchNetworkPolicy.security.allowPromiscuous != false;
        boolean bl2 = securityPolicies.isForgedTransmitsOverriden = isPortgroupSecurityPolicyDefined && portgroupNetworkPolicy.security.forgedTransmits != null;
        securityPolicies.forgedTransmits = securityPolicies.isForgedTransmitsOverriden ? portgroupNetworkPolicy.security.forgedTransmits : isVSwitchSecurityPolicyDefined && vSwitchNetworkPolicy.security.forgedTransmits != false;
        boolean bl3 = securityPolicies.isMacChangesOverriden = isPortgroupSecurityPolicyDefined && portgroupNetworkPolicy.security.macChanges != null;
        securityPolicies.macChanges = securityPolicies.isMacChangesOverriden ? portgroupNetworkPolicy.security.macChanges : isVSwitchSecurityPolicyDefined && vSwitchNetworkPolicy.security.macChanges != false;
        return securityPolicies;
    }

    public static NetworkPolicyData.TrafficShapingPolicies getTrafficShapingPolicies(NetworkPolicy vSwitchNetworkPolicy, NetworkPolicy porgroupNetworkPolicy) {
        NetworkPolicyData.TrafficShapingPolicies trafficShapingPolicies = new NetworkPolicyData.TrafficShapingPolicies();
        if (porgroupNetworkPolicy != null && NetworkPolicyUtil.isTrafficShapingPolicyDefined(porgroupNetworkPolicy.shapingPolicy)) {
            NetworkPolicyUtil.setTrafficShapingPolicy(trafficShapingPolicies, porgroupNetworkPolicy.shapingPolicy, true);
        } else if (vSwitchNetworkPolicy != null && NetworkPolicyUtil.isTrafficShapingPolicyDefined(vSwitchNetworkPolicy.shapingPolicy)) {
            NetworkPolicyUtil.setTrafficShapingPolicy(trafficShapingPolicies, vSwitchNetworkPolicy.shapingPolicy, false);
        } else {
            trafficShapingPolicies.overridden = false;
            trafficShapingPolicies.enabled = false;
            trafficShapingPolicies.averageBandwidth = 100000L;
            trafficShapingPolicies.peakBandwidth = 100000L;
            trafficShapingPolicies.burstSize = 102400L;
        }
        return trafficShapingPolicies;
    }

    public static NetworkPolicyData.TeamingAndFailover getTeamingAndFailoverPolicies(NetworkPolicy vSwitchPolicy, NetworkPolicy portgroupPolicy, VirtualSwitch virtualSwitch, String[] nicTeamingPolicy, HostPnicDetailsData hostPnicDetailsData) {
        NetworkPolicyData.TeamingAndFailover teamingAndFailover = new NetworkPolicyData.TeamingAndFailover();
        teamingAndFailover.nicTeamingPolicy = nicTeamingPolicy;
        teamingAndFailover.loadBalancingOverridden = NetworkPolicyUtil.isLoadBalancingOverridden(portgroupPolicy);
        teamingAndFailover.loadBalancing = NetworkPolicyUtil.getLoadBalancing(vSwitchPolicy, portgroupPolicy);
        teamingAndFailover.failureDetectionOverridden = NetworkPolicyUtil.isFailureDetectionOverridden(portgroupPolicy);
        teamingAndFailover.checkBeacon = NetworkPolicyUtil.getFailureDetection(vSwitchPolicy, portgroupPolicy);
        teamingAndFailover.notifySwitchesOverridden = NetworkPolicyUtil.isNotifySwitchesOverridden(portgroupPolicy);
        teamingAndFailover.notifySwitches = NetworkPolicyUtil.getNotifySwitches(vSwitchPolicy, portgroupPolicy);
        teamingAndFailover.failbackOverridden = NetworkPolicyUtil.isRollingOrderOverridden(portgroupPolicy);
        teamingAndFailover.rollingOrder = NetworkPolicyUtil.getRollingOrder(vSwitchPolicy, portgroupPolicy);
        teamingAndFailover.failoverOrderOverridden = NetworkUtil.isNicOrderOverridden(portgroupPolicy);
        NetworkPolicy.NicOrderPolicy nicOrderPolicy = NetworkUtil.getNicOrder(portgroupPolicy, vSwitchPolicy);
        teamingAndFailover.pnics = PnicParser.getPnicWithDetails(hostPnicDetailsData, nicOrderPolicy, virtualSwitch);
        return teamingAndFailover;
    }

    private static void setTrafficShapingPolicy(NetworkPolicyData.TrafficShapingPolicies trafficShapingPolicies, NetworkPolicy.TrafficShapingPolicy policy, boolean isStatusOverriden) {
        trafficShapingPolicies.enabled = policy.enabled;
        trafficShapingPolicies.overridden = isStatusOverriden;
        trafficShapingPolicies.averageBandwidth = policy.averageBandwidth != null ? policy.averageBandwidth / 1000L : 100000L;
        trafficShapingPolicies.peakBandwidth = policy.peakBandwidth != null ? policy.peakBandwidth / 1000L : 100000L;
        trafficShapingPolicies.burstSize = policy.burstSize != null ? policy.burstSize / 1024L : 102400L;
    }

    private static boolean isTrafficShapingPolicyDefined(NetworkPolicy.TrafficShapingPolicy shapingPolicy) {
        return shapingPolicy != null && shapingPolicy.enabled != null;
    }

    private static boolean isLoadBalancingOverridden(NetworkPolicy portgroupPolicy) {
        return portgroupPolicy != null && portgroupPolicy.nicTeaming != null && portgroupPolicy.nicTeaming.policy != null;
    }

    private static boolean isFailureDetectionOverridden(NetworkPolicy portgroupPolicy) {
        return portgroupPolicy != null && portgroupPolicy.nicTeaming != null && portgroupPolicy.nicTeaming.failureCriteria != null && portgroupPolicy.nicTeaming.failureCriteria.checkBeacon != null;
    }

    private static boolean isNotifySwitchesOverridden(NetworkPolicy portgroupPolicy) {
        return portgroupPolicy != null && portgroupPolicy.nicTeaming != null && portgroupPolicy.nicTeaming.notifySwitches != null;
    }

    private static boolean isRollingOrderOverridden(NetworkPolicy portgroupPolicy) {
        return portgroupPolicy != null && portgroupPolicy.nicTeaming != null && portgroupPolicy.nicTeaming.rollingOrder != null;
    }

    private static String getLoadBalancing(NetworkPolicy vSwitchPolicy, NetworkPolicy portgroupPolicy) {
        String loadBalancing = null;
        if (NetworkPolicyUtil.isLoadBalancingOverridden(portgroupPolicy)) {
            loadBalancing = portgroupPolicy.nicTeaming.policy;
        } else if (vSwitchPolicy != null && vSwitchPolicy.nicTeaming != null) {
            loadBalancing = vSwitchPolicy.nicTeaming.policy;
        }
        return loadBalancing;
    }

    private static boolean getFailureDetection(NetworkPolicy vSwitchPolicy, NetworkPolicy portgroupPolicy) {
        if (NetworkPolicyUtil.isFailureDetectionOverridden(portgroupPolicy)) {
            return portgroupPolicy.nicTeaming.failureCriteria.checkBeacon;
        }
        if (vSwitchPolicy != null && vSwitchPolicy.nicTeaming != null && vSwitchPolicy.nicTeaming.failureCriteria != null && vSwitchPolicy.nicTeaming.failureCriteria.checkBeacon != null) {
            return vSwitchPolicy.nicTeaming.failureCriteria.checkBeacon;
        }
        return false;
    }

    private static boolean getNotifySwitches(NetworkPolicy vSwitchPolicy, NetworkPolicy portgroupPolicy) {
        if (NetworkPolicyUtil.isNotifySwitchesOverridden(portgroupPolicy)) {
            return portgroupPolicy.nicTeaming.notifySwitches;
        }
        if (vSwitchPolicy != null && vSwitchPolicy.nicTeaming != null && vSwitchPolicy.nicTeaming.notifySwitches != null) {
            return vSwitchPolicy.nicTeaming.notifySwitches;
        }
        return false;
    }

    private static boolean getRollingOrder(NetworkPolicy vSwitchPolicy, NetworkPolicy portgroupPolicy) {
        if (NetworkPolicyUtil.isRollingOrderOverridden(portgroupPolicy)) {
            return portgroupPolicy.nicTeaming.rollingOrder;
        }
        if (vSwitchPolicy != null && vSwitchPolicy.nicTeaming != null && vSwitchPolicy.nicTeaming.rollingOrder != null) {
            return vSwitchPolicy.nicTeaming.rollingOrder;
        }
        return false;
    }
}

