/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.StorageQueryManager;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.common.StorageOperationHostData;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreOperationData;
import com.vmware.vsphere.client.h5.storage.data.devices.StorageDeviceOperationData;
import com.vmware.vsphere.client.h5.storage.spec.devices.QueryHostsForStorageDeviceOperationSpec;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreOperationsPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DatastoreOperationsPropertyProvider.class);
    private static final String DS_HOST_MOUNT_PROP = "hostMount";
    private static final String DS_MOUNTED_HOST_REFS_PROP = "hostKey";
    private static final String DS_INFO_PROP = "info";
    private static final String DS_INFO_NAS_PROP = "info/nas";
    private static final String NAME_PROPERTY = "name";
    private static final String DATACENTER_PROP = "dc";
    private static final String HOST_POWER_STATE_PROPERTY = "runtime/powerState";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime/connectionState";
    private static final String HOST_CLUSTER_NAME_PROPERTY = "hostClusterName";
    private static final String HOST_VNICS = "config/network/vnic";
    private static final String HOST_NVME_VVOL_SUPPORTED_PROPERTY = "capability/nvmeVvolSupported";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String[] HOST_CONFIG_STORAGE_PRIV = new String[]{"Host.Config.Storage"};
    public static final String HOST_CAPABILITY_NFS3_SUPPORTED_PROP = "capability/nfsSupported";
    public static final String HOST_CAPABILITY_NFS41_SUPPORTED_PROP = "capability/nfs41Supported";
    public static final String HOST_CAPABILITY_VMKNIC_BINDING_SUPPORTED_PROP = "capability/vmknicBindingSupported";
    public static final String HOST_IN_DOMAIN_PROPERTY = "inDomain";
    public static final String HOST_NFS_KERBEROS_USER_PROP = "nfsKerberosUser";
    public static final String HOST_CAPABILITY_NFS41_KRB5I_SUPPORTED_PROP = "capability/nfs41Krb5iSupported";
    public static final String HOST_CAPABILITY_PERENNIALLY_RESERVED_SUPPORTED_PROP = "capability/markPerenniallyReservedSupported";
    private final QueryService _queryService;

    public DatastoreOperationsPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountVmfs")
    public DatastoreOperationData getAvailableHostsForMountVmfs(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo mountInfo) {
                return Boolean.FALSE.equals(mountInfo.mounted);
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForUnmount")
    public DatastoreOperationData getAvailableHostsForUnmount(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo mountInfo) {
                return Boolean.TRUE.equals(mountInfo.mounted);
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForUnmountNfs")
    public DatastoreOperationData getAvailableHostsForUnmountNfs(ManagedObjectReference dsRef) {
        return this.getAvailableHostsForVmfsMountUnmountOperation(dsRef, new HostMountPredicate(){

            @Override
            public boolean test(MountInfo hostMount) {
                return true;
            }
        });
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountNfs")
    public DatastoreOperationData getAvailableHostsForMountNfs(ManagedObjectReference dsRef, Boolean bindToVmknic) throws Exception {
        return this.getAvailableHostsForMount(dsRef, true, bindToVmknic);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastoreOperations", property="availableHostsForMountVvol")
    public DatastoreOperationData getAvailableHostsForMountVvol(ManagedObjectReference dsRef) throws Exception {
        return this.getAvailableHostsForMount(dsRef, false, false);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageDeviceOperations", property="availableHostsForDeviceUnmount")
    public StorageDeviceOperationData getAvailableHostsForDeviceUnmount(ManagedObjectReference hostRef, QueryHostsForStorageDeviceOperationSpec spec) throws Exception {
        StorageDeviceOperationHostValidator hostValidator = new StorageDeviceOperationHostValidator(hostRef);
        return this.getAvailableHostsForDeviceOperation(hostRef, spec, hostValidator);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageDeviceOperations", property="availableHostsForPerenniallyReserved")
    public StorageDeviceOperationData getAvailableHostsForPerenniallyReserved(ManagedObjectReference hostRef, QueryHostsForStorageDeviceOperationSpec spec) throws Exception {
        StorageDeviceOperationHostValidator hostValidator = new StorageDeviceOperationHostValidator(hostRef, HOST_CAPABILITY_PERENNIALLY_RESERVED_SUPPORTED_PROP);
        return this.getAvailableHostsForDeviceOperation(hostRef, spec, hostValidator);
    }

    private StorageDeviceOperationData getAvailableHostsForDeviceOperation(ManagedObjectReference hostRef, QueryHostsForStorageDeviceOperationSpec spec, HostValidator hostValidator) throws Exception {
        if (!VcServiceUtil.is68VcOrLaterByServerGuid((String)hostRef.getServerGuid(), (boolean)true) || spec == null || spec.storageDeviceId == null) {
            return StorageDeviceOperationData.emptyData((boolean)false);
        }
        VcService vcService = VimSessionUtil.getService((String)hostRef.getServerGuid());
        StorageQueryManager storageQueryManager = (StorageQueryManager)vcService.getManagedObject(vcService.getServiceInstanceContent().getStorageQueryManager());
        if (storageQueryManager == null) {
            return StorageDeviceOperationData.emptyData((boolean)false);
        }
        ManagedObjectReference[] hostRefs = storageQueryManager.queryHostsWithAttachedLun(spec.storageDeviceId);
        if (hostRefs == null || hostRefs.length <= 1) {
            return StorageDeviceOperationData.emptyData((boolean)false);
        }
        QueryCommand queryCommand = this._queryService.select(hostValidator.getHostPropertiesToRetrieve()).from(new String[]{HostSystem.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(hostRefs)).build();
        StorageDeviceOperationData result = new StorageDeviceOperationData();
        result.isBatchOperationSupported = true;
        result.availableHosts = this.buildHostData(queryCommand, hostValidator);
        if (result.availableHosts.length <= 1) {
            return StorageDeviceOperationData.emptyData((boolean)false);
        }
        return result;
    }

    private DatastoreOperationData getAvailableHostsForMount(ManagedObjectReference dsRef, boolean isNfs, Boolean bindToVmknic) throws Exception {
        QueryCommand queryCommand;
        Map dsProperties = QueryServiceUtil.queryProperties((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String[])new String[]{DATACENTER_PROP, DS_MOUNTED_HOST_REFS_PROP, DS_INFO_PROP});
        HostValidator hostValidator = isNfs ? new NfsHostMountValidator((NasDatastoreInfo)dsProperties.get(DS_INFO_PROP), bindToVmknic) : (dsProperties.get(DS_INFO_PROP) instanceof VvolDatastoreInfo ? new VvolHostMountValidator((VvolDatastoreInfo)dsProperties.get(DS_INFO_PROP)) : new HostValidator());
        ManagedObjectReference dcMor = (ManagedObjectReference)dsProperties.get(DATACENTER_PROP);
        Object[] mountedHostRefs = (Object[])dsProperties.get(DS_MOUNTED_HOST_REFS_PROP);
        if (mountedHostRefs == null) {
            mountedHostRefs = new ManagedObjectReference[]{};
        }
        if (dcMor == null) {
            return DatastoreOperationData.emptyData();
        }
        PropertyPredicate dcPredicate = new PropertyPredicate(DATACENTER_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dcMor);
        QueryCommand.Builder queryBuilder = this._queryService.select(hostValidator.getHostPropertiesToRetrieve()).from(new String[]{HostSystem.class.getSimpleName()});
        if (mountedHostRefs.length != 0) {
            PropertyPredicate hostNotMountedPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, Arrays.asList(mountedHostRefs));
            queryCommand = queryBuilder.where(LogicalOperator.AND, new PropertyPredicate[]{dcPredicate, hostNotMountedPredicate}).build();
        } else {
            queryCommand = queryBuilder.where(new PropertyPredicate[]{dcPredicate}).build();
        }
        return this.buildDatastoreOperationData(queryCommand, hostValidator);
    }

    private DatastoreOperationData getAvailableHostsForVmfsMountUnmountOperation(ManagedObjectReference dsRef, HostMountPredicate hostMountPredicate) {
        Datastore.HostMount[] dsHostMount = (Datastore.HostMount[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String)DS_HOST_MOUNT_PROP);
        if (dsHostMount == null) {
            return DatastoreOperationData.emptyData();
        }
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        for (Datastore.HostMount hostMount : dsHostMount) {
            if (!hostMountPredicate.test(hostMount.mountInfo)) continue;
            hostRefs.add(hostMount.key);
        }
        if (hostRefs.isEmpty()) {
            return DatastoreOperationData.emptyData();
        }
        HostValidator hostValidator = new HostValidator();
        QueryCommand queryCommand = this._queryService.select(hostValidator.getHostPropertiesToRetrieve()).from(new String[]{HostSystem.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, hostRefs).build();
        return this.buildDatastoreOperationData(queryCommand, hostValidator);
    }

    private DatastoreOperationData buildDatastoreOperationData(QueryCommand queryCommand, HostValidator hostValidator) {
        DatastoreOperationData result = new DatastoreOperationData();
        result.availableHosts = this.buildHostData(queryCommand, hostValidator);
        return result;
    }

    private StorageOperationHostData[] buildHostData(QueryCommand queryCommand, HostValidator hostValidator) {
        ResultSet resultSet = queryCommand.fetch();
        hostValidator.initialize(resultSet);
        ArrayList<StorageOperationHostData> result = new ArrayList<StorageOperationHostData>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            VirtualNic[] virtualNics;
            StorageOperationHostData hostData = new StorageOperationHostData();
            hostData.hostRef = (ManagedObjectReference)resourceItem.getKey();
            hostData.clusterName = (String)resourceItem.get(HOST_CLUSTER_NAME_PROPERTY);
            HostValidator.ValidationResult hostValidationResult = hostValidator.validate(resourceItem);
            hostData.formattedName = hostValidationResult.formattedHostName;
            hostData.hostName = hostValidationResult.hostName;
            hostData.isOperationAllowed = hostValidationResult.isOperationAllowed;
            hostData.compatibilityIssue = hostValidationResult.compatibilityIssue;
            if (resultSet.getProperties().contains(HOST_VNICS) && (virtualNics = (VirtualNic[])resourceItem.get(HOST_VNICS)) != null) {
                hostData.virtualNics = H5StorageUtil.filterDefaultTcpipStackVirtualNics((VirtualNic[])virtualNics);
            }
            if (hostValidationResult.excludeFromResult) continue;
            result.add(hostData);
        }
        return result.toArray(new StorageOperationHostData[result.size()]);
    }

    private static class HostValidator {
        private static final List<String> propertiesToRetrieve = Collections.unmodifiableList(Arrays.asList("name", "runtime/connectionState", "runtime/powerState", "grantedPrivileges", "hostClusterName"));

        private HostValidator() {
        }

        public List<String> getHostPropertiesToRetrieve() {
            return propertiesToRetrieve;
        }

        public void initialize(ResultSet resultSet) {
        }

        public ValidationResult validate(ResourceItem hostProperties) {
            String hostName = (String)hostProperties.get(DatastoreOperationsPropertyProvider.NAME_PROPERTY);
            if (HostValidator.isHostConnected(hostProperties)) {
                if (HostValidator.hasConfigStoragePrivilege(hostProperties)) {
                    return HostValidator.buildValidationResult(hostName, null);
                }
                return HostValidator.buildValidationResult(hostName, StorageStringUtil.getString("hostName.notEnoughPrivileges"));
            }
            String compatibilityIssue = H5StorageUtil.getHostStateIssue((HostSystem.ConnectionState)((HostSystem.ConnectionState)hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CONNECTION_STATE_PROPERTY)), (HostSystem.PowerState)((HostSystem.PowerState)hostProperties.get(DatastoreOperationsPropertyProvider.HOST_POWER_STATE_PROPERTY)));
            return HostValidator.buildValidationResult(hostName, compatibilityIssue);
        }

        protected static ValidationResult buildValidationResult(String hostName, String compatibilityIssue) {
            String formattedName = H5StorageUtil.appendIssue((String)hostName, (String)compatibilityIssue);
            return new ValidationResult(formattedName, hostName, compatibilityIssue);
        }

        protected static boolean isHostConnected(ResourceItem hostProperties) {
            return HostSystem.ConnectionState.connected.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CONNECTION_STATE_PROPERTY));
        }

        protected static boolean hasConfigStoragePrivilege(ResourceItem hostProperties) {
            return AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIV, (String[])((String[])hostProperties.get(DatastoreOperationsPropertyProvider.GRANTED_PRIVILEGES_PROP)));
        }

        public static final class ValidationResult {
            private String formattedHostName;
            private String hostName;
            private String compatibilityIssue;
            private boolean isOperationAllowed;
            private boolean excludeFromResult;

            public ValidationResult(String formattedHostName, String hostName, String compatibilityIssue) {
                this.formattedHostName = formattedHostName;
                this.hostName = hostName;
                this.compatibilityIssue = compatibilityIssue;
                this.isOperationAllowed = compatibilityIssue == null;
                this.excludeFromResult = false;
            }
        }
    }

    private static class StorageDeviceOperationHostValidator
    extends HostValidator {
        private ManagedObjectReference targetHost;
        private ManagedObjectReference targetHostDc;
        private List<String> propertiesToRetrieve;
        private String requiredHostCapability;

        @Override
        public List<String> getHostPropertiesToRetrieve() {
            if (this.propertiesToRetrieve == null) {
                this.propertiesToRetrieve = new ArrayList<String>(super.getHostPropertiesToRetrieve());
                this.propertiesToRetrieve.add(DatastoreOperationsPropertyProvider.DATACENTER_PROP);
                if (this.requiredHostCapability != null) {
                    this.propertiesToRetrieve.add(this.requiredHostCapability);
                }
            }
            return this.propertiesToRetrieve;
        }

        public StorageDeviceOperationHostValidator(ManagedObjectReference targetHost) {
            this(targetHost, null);
        }

        public StorageDeviceOperationHostValidator(ManagedObjectReference targetHost, String requiredHostCapability) {
            this.targetHost = targetHost;
            this.requiredHostCapability = requiredHostCapability;
        }

        @Override
        public void initialize(ResultSet resultSet) {
            for (ResourceItem hostItem : resultSet.getItems()) {
                if (!this.targetHost.equals(hostItem.getKey())) continue;
                this.targetHostDc = (ManagedObjectReference)hostItem.get(DatastoreOperationsPropertyProvider.DATACENTER_PROP);
            }
        }

        @Override
        public HostValidator.ValidationResult validate(ResourceItem hostProperties) {
            HostValidator.ValidationResult result = super.validate(hostProperties);
            if (result.isOperationAllowed && this.requiredHostCapability != null && !Boolean.TRUE.equals(hostProperties.get(this.requiredHostCapability))) {
                result.isOperationAllowed = false;
                result.compatibilityIssue = StorageStringUtil.getString("hostName.notSupported");
                result.formattedHostName = H5StorageUtil.appendIssue((String)result.hostName, (String)result.compatibilityIssue);
            }
            if (this.targetHostDc == null || !this.targetHostDc.equals(hostProperties.get(DatastoreOperationsPropertyProvider.DATACENTER_PROP))) {
                result.excludeFromResult = true;
            }
            return result;
        }
    }

    private static class NfsHostMountValidator
    extends HostValidator {
        private final NasDatastoreInfo dsInfo;
        private final Boolean bindToVmknic;
        private List<String> propertiesToRetrieve;
        private static final List<String> propertiesToRetrieveCommon = Collections.unmodifiableList(Arrays.asList("name", "runtime/connectionState", "runtime/powerState", "grantedPrivileges", "hostClusterName", "capability/nfsSupported", "capability/nfs41Supported", "capability/vmknicBindingSupported", "config/network/vnic"));
        private static final List<String> propertiesToRetrieveForKrbEnabledDs = Collections.unmodifiableList(Arrays.asList("nfsKerberosUser", "inDomain", "capability/nfs41Krb5iSupported"));

        private NfsHostMountValidator(NasDatastoreInfo dsInfo, Boolean bindTovmknic) {
            this.dsInfo = dsInfo;
            this.bindToVmknic = bindTovmknic;
        }

        @Override
        public List<String> getHostPropertiesToRetrieve() {
            if (this.propertiesToRetrieve == null) {
                this.propertiesToRetrieve = new ArrayList<String>();
                this.propertiesToRetrieve.addAll(propertiesToRetrieveCommon);
                if (this.isKerberosEnabledOnDatastore()) {
                    this.propertiesToRetrieve.addAll(propertiesToRetrieveForKrbEnabledDs);
                }
            }
            return this.propertiesToRetrieve;
        }

        @Override
        public HostValidator.ValidationResult validate(ResourceItem hostProperties) {
            HostValidator.ValidationResult superValidationResult = super.validate(hostProperties);
            if (superValidationResult.compatibilityIssue != null) {
                return superValidationResult;
            }
            String hostName = (String)hostProperties.get(DatastoreOperationsPropertyProvider.NAME_PROPERTY);
            if ("NFS".equals(this.dsInfo.nas.type)) {
                boolean isNfs3Supported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS3_SUPPORTED_PROP));
                if (!isNfs3Supported) {
                    return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.nfsv3NotSupported"));
                }
                boolean isVmknicBindingSupported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_VMKNIC_BINDING_SUPPORTED_PROP));
                if (Boolean.TRUE.equals(this.bindToVmknic) && !isVmknicBindingSupported) {
                    return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.nfsVmknicBindingNotSupported"));
                }
            } else if ("NFS41".equals(this.dsInfo.nas.type)) {
                boolean isNfs41Supported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS41_SUPPORTED_PROP));
                if (!isNfs41Supported) {
                    return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.nfsv41NotSupported"));
                }
                if (this.isKerberosEnabledOnDatastore()) {
                    boolean isInDomain = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_IN_DOMAIN_PROPERTY));
                    if (!isInDomain) {
                        return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.hostNotInDomain"));
                    }
                    Object hostNfsKrbUsr = hostProperties.get(DatastoreOperationsPropertyProvider.HOST_NFS_KERBEROS_USER_PROP);
                    if (hostNfsKrbUsr == null || hostNfsKrbUsr instanceof String && ((String)hostNfsKrbUsr).isEmpty()) {
                        return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.noCredentials"));
                    }
                    boolean isKrbi5Supported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_CAPABILITY_NFS41_KRB5I_SUPPORTED_PROP));
                    if (NasVolume.SecurityType.SEC_KRB5I.toString().equals(this.dsInfo.getNas().getSecurityType()) && !isKrbi5Supported) {
                        return NfsHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.nfsSelectHostsPage.krb5iNotSupported"));
                    }
                }
            }
            return superValidationResult;
        }

        private boolean isKerberosEnabledOnDatastore() {
            return NasVolume.SecurityType.SEC_KRB5.toString().equals(this.dsInfo.getNas().getSecurityType()) || NasVolume.SecurityType.SEC_KRB5I.toString().equals(this.dsInfo.getNas().getSecurityType());
        }
    }

    private static class VvolHostMountValidator
    extends HostValidator {
        private final VvolDatastoreInfo dsInfo;
        private List<String> propertiesToRetrieve;

        private VvolHostMountValidator(VvolDatastoreInfo dsInfo) {
            this.dsInfo = dsInfo;
        }

        @Override
        public List<String> getHostPropertiesToRetrieve() {
            if (this.propertiesToRetrieve == null) {
                this.propertiesToRetrieve = new ArrayList<String>();
                this.propertiesToRetrieve.addAll(super.getHostPropertiesToRetrieve());
                if ("NVMe".equals(this.dsInfo.vvolDS.protocolEndpointType)) {
                    this.propertiesToRetrieve.add(DatastoreOperationsPropertyProvider.HOST_NVME_VVOL_SUPPORTED_PROPERTY);
                }
            }
            return this.propertiesToRetrieve;
        }

        @Override
        public HostValidator.ValidationResult validate(ResourceItem hostProperties) {
            boolean isNvmeVvolSupported;
            HostValidator.ValidationResult superValidationResult = super.validate(hostProperties);
            if (superValidationResult.compatibilityIssue != null) {
                return superValidationResult;
            }
            if ("NVMe".equals(this.dsInfo.vvolDS.protocolEndpointType) && !(isNvmeVvolSupported = Boolean.TRUE.equals(hostProperties.get(DatastoreOperationsPropertyProvider.HOST_NVME_VVOL_SUPPORTED_PROPERTY)))) {
                String hostName = (String)hostProperties.get(DatastoreOperationsPropertyProvider.NAME_PROPERTY);
                return VvolHostMountValidator.buildValidationResult(hostName, StorageStringUtil.getString("addDatastoreWizard.vvolSelectHostsPage.nvmeNotSupported.issue"));
            }
            return superValidationResult;
        }
    }

    private static interface HostMountPredicate {
        public boolean test(MountInfo var1);
    }
}

