/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.model.ActionData;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.h5.storage.impl.DatastorePropertyProvider;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastorePropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String DATASTORE_INFO_PROPERTY = "info";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String DATASTORE_FREE_SPACE_PROPERTY = "info.freeSpace";
    private static final String DATASTORE_CAPACITY_PROPERTY = "summary.capacity";
    private static final String DATASTORE_UNCOMMITED_PROPERTY = "summary.uncommitted";
    private static final String DATASTORE_ACCESSIBLE_PROPERTY = "summary.accessible";
    private static final String DATASTORE_THIN_PROVISIONING_CAPABILITY = "capability.perFileThinProvisioningSupported";
    private static final String DATASTORE_IORM_SUPPORTED_CAPABILITY = "capability.storageIORMSupported";
    private static final String DATASTORE_VMDK_SUPPORTED_CAPABILITY = "capability.clusteredVmdkSupported";
    private static final String DATASTORE_IORM_CONFIG_PROPERTY = "iormConfiguration";
    private static final String VMFS_UNMAP_PRIORITY_PROP = "info.vmfs.unmapPriority";
    private static final String VMFS_UNMAP_BANDWIDTH_PROPERTY = "info.vmfs.unmapBandwidthSpec";
    private static final String NAMESPACE_PREFIX = "datastore:";
    private static final String GENERAL_PROPERTIES_DATA = "datastore:datastoreGeneralPropertiesData";
    private static final String GENERAL_CAPACITY_DATA = "datastore:datastoreGeneralCapacityData";
    private static final String GENERAL_CAPABILITIES_DATA = "datastore:datastoreGeneralCapabilitiesData";
    private static final String SPACE_RECLAMATION_DATA = "datastore:spaceReclamationDetailsData";
    private static final String FIXED_UNMAP_METHOD = "fixed";
    private static final String DYNAMIC_UNMAP_METHOD = "dynamic";
    private static final Log _logger = LogFactory.getLog(DatastorePropertyProviderAdapter.class);

    public DatastorePropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = obj;
            resultItem.properties = this.computePropertyValues(reqPropSet, sourcePropertyValuesMap, obj);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{GENERAL_PROPERTIES_DATA, GENERAL_CAPACITY_DATA, GENERAL_CAPABILITIES_DATA, SPACE_RECLAMATION_DATA};
        ti.derivedProperties = new DerivedPropertyInfo[]{DatastorePropertyProviderAdapter.newDerivedPropertyInfo(GENERAL_PROPERTIES_DATA, new String[]{DATASTORE_TYPE_PROPERTY, DATASTORE_INFO_PROPERTY}), DatastorePropertyProviderAdapter.newDerivedPropertyInfo(GENERAL_CAPACITY_DATA, new String[]{DATASTORE_FREE_SPACE_PROPERTY, DATASTORE_CAPACITY_PROPERTY, DATASTORE_UNCOMMITED_PROPERTY, DATASTORE_ACCESSIBLE_PROPERTY}), DatastorePropertyProviderAdapter.newDerivedPropertyInfo(GENERAL_CAPABILITIES_DATA, new String[]{DATASTORE_TYPE_PROPERTY, DATASTORE_THIN_PROVISIONING_CAPABILITY, DATASTORE_IORM_SUPPORTED_CAPABILITY, DATASTORE_IORM_CONFIG_PROPERTY, DATASTORE_VMDK_SUPPORTED_CAPABILITY}), DatastorePropertyProviderAdapter.newDerivedPropertyInfo(SPACE_RECLAMATION_DATA, new String[]{VMFS_UNMAP_PRIORITY_PROP, VMFS_UNMAP_BANDWIDTH_PROPERTY})};
        return new TypeInfo[]{ti};
    }

    private PropertyValue[] computePropertyValues(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (reqProps.contains(GENERAL_PROPERTIES_DATA)) {
            this.processGeneralPropertiesData(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(GENERAL_CAPACITY_DATA)) {
            this.processGeneralCapacityData(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(GENERAL_CAPABILITIES_DATA)) {
            this.processGeneralCapabilitiesData(propertyValuesMap, result, resourceObject);
        }
        if (reqProps.contains(SPACE_RECLAMATION_DATA)) {
            this.processSpaceReclamationData(propertyValuesMap, result, resourceObject);
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    private void processGeneralPropertiesData(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        String dsType = (String)propertyValuesMap.get(DATASTORE_TYPE_PROPERTY);
        Datastore.Info dsInfo = (Datastore.Info)propertyValuesMap.get(DATASTORE_INFO_PROPERTY);
        ArrayList<PropertyValueData> datastorePropertyItems = new ArrayList<PropertyValueData>();
        if (dsInfo != null) {
            DatastorePropertyProviderAdapter.populateDatastoreNameProperty(datastorePropertyItems, dsInfo);
        }
        if (dsInfo instanceof VmfsDatastoreInfo) {
            DatastorePropertyProviderAdapter.populateVmfsDatastoreProperties(datastorePropertyItems, (VmfsDatastoreInfo)dsInfo, dsType);
        } else {
            if (dsType != null) {
                DatastorePropertyProviderAdapter.populateDatastoreTypeProperty(datastorePropertyItems, dsType);
            }
            if (dsInfo instanceof NasDatastoreInfo) {
                DatastorePropertyProviderAdapter.populateNfsDatastoreProperties(datastorePropertyItems, (NasDatastoreInfo)dsInfo);
            }
        }
        propValues.add(this.createPropValue(GENERAL_PROPERTIES_DATA, datastorePropertyItems.toArray(new PropertyValueData[datastorePropertyItems.size()]), resourceObject));
    }

    private void processGeneralCapacityData(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Long uncommitedSpace;
        Long usedSpace;
        Long datastoreCapacity = (Long)propertyValuesMap.get(DATASTORE_CAPACITY_PROPERTY);
        Long freeSpace = (Long)propertyValuesMap.get(DATASTORE_FREE_SPACE_PROPERTY);
        Long provisionedSpace = usedSpace = Long.valueOf(datastoreCapacity - freeSpace);
        Boolean isAccessible = (Boolean)propertyValuesMap.get(DATASTORE_ACCESSIBLE_PROPERTY);
        if (isAccessible != null && isAccessible.booleanValue() && (uncommitedSpace = (Long)propertyValuesMap.get(DATASTORE_UNCOMMITED_PROPERTY)) != null) {
            provisionedSpace = provisionedSpace + uncommitedSpace;
        }
        PropertyValueData[] result = new PropertyValueData[]{DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.totalCapacity", FormatUtil.getStorageFormatted((Long)datastoreCapacity, (long)1L, (long)-1L)), DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.provisionedSpace", FormatUtil.getStorageFormatted((Long)provisionedSpace, (long)1L, (long)-1L)), DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.freeSpace", FormatUtil.getStorageFormatted((Long)freeSpace, (long)1L, (long)-1L))};
        propValues.add(this.createPropValue(GENERAL_CAPACITY_DATA, result, resourceObject));
    }

    private void processGeneralCapabilitiesData(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        ArrayList<PropertyValueData> result = new ArrayList<PropertyValueData>();
        String dsType = (String)propertyValuesMap.get(DATASTORE_TYPE_PROPERTY);
        if (H5StorageUtil.isVmfsDsType((String)dsType)) {
            result.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.thinProvisioning", H5StorageUtil.formatSupportedValue((Boolean)((Boolean)propertyValuesMap.get(DATASTORE_THIN_PROVISIONING_CAPABILITY)))));
        }
        DatastorePropertyProviderAdapter.populateIormProperties(result, (Boolean)propertyValuesMap.get(DATASTORE_IORM_SUPPORTED_CAPABILITY), (StorageResourceManager.IORMConfigInfo)propertyValuesMap.get(DATASTORE_IORM_CONFIG_PROPERTY));
        this.populateVmdkDatastoreProperties(result, (Boolean)propertyValuesMap.get(DATASTORE_VMDK_SUPPORTED_CAPABILITY), resourceObject);
        propValues.add(this.createPropValue(GENERAL_CAPABILITIES_DATA, result.toArray(new PropertyValueData[result.size()]), resourceObject));
    }

    private void processSpaceReclamationData(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        PropertyValueData[] result = null;
        VmfsVolume.UnmapBandwidthSpec unmapBandwidthSpec = (VmfsVolume.UnmapBandwidthSpec)propertyValuesMap.get(VMFS_UNMAP_BANDWIDTH_PROPERTY);
        if (unmapBandwidthSpec != null) {
            if (FIXED_UNMAP_METHOD.equals(unmapBandwidthSpec.policy)) {
                result = new PropertyValueData[]{DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.spaceReclamationPriority", StorageStringUtil.getString("datastore.manage.general.spaceReclamation.fixedValue")), DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.fixed.rate", StorageStringUtil.getString("datastore.manage.general.spaceReclamation.rateItemFormat", Long.toString(unmapBandwidthSpec.fixedValue)))};
            } else if (DYNAMIC_UNMAP_METHOD.equals(unmapBandwidthSpec.policy)) {
                result = new PropertyValueData[]{DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.spaceReclamationPriority", StorageStringUtil.getString("datastore.manage.general.spaceReclamation.dynamicValue")), DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.dynamic.minBandwidth", StorageStringUtil.getString("datastore.manage.general.spaceReclamation.rateItemFormat", Long.toString(unmapBandwidthSpec.dynamicMin))), DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.dynamic.maxBandwidth", StorageStringUtil.getString("datastore.manage.general.spaceReclamation.rateItemFormat", Long.toString(unmapBandwidthSpec.dynamicMax)))};
            }
        }
        if (result == null) {
            String unmapPriority = (String)propertyValuesMap.get(VMFS_UNMAP_PRIORITY_PROP);
            result = new PropertyValueData[]{DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.spaceReclamation.spaceReclamationPriority", "")};
            if (unmapPriority != null) {
                if (VmfsVolume.UnmapPriority.none.toString().equals(unmapPriority)) {
                    result[0].value = StorageStringUtil.getString("datastore.manage.general.spaceReclamation.spaceReclamationPriorityNoneDescription");
                } else {
                    String unmapPriorityLabel = StorageStringUtil.getString("vmfs.unmapPriority." + unmapPriority);
                    result[0].value = StorageStringUtil.getString("datastore.manage.general.spaceReclamation.spaceReclamationPriorityDescription", unmapPriorityLabel, unmapPriorityLabel.toLowerCase());
                }
            }
        }
        propValues.add(this.createPropValue(SPACE_RECLAMATION_DATA, result, resourceObject));
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String propertyName, String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = propertyName;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }

    private static void populateDatastoreTypeProperty(List<PropertyValueData> datastoreProperties, String dsType) {
        datastoreProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.type", H5StorageUtil.formatDatastoreType((String)dsType)));
    }

    private static void populateNfsDatastoreProperties(List<PropertyValueData> datastoreProperties, NasDatastoreInfo info) {
        String maxFileSize = FormatUtil.getStorageFormatted((Long)info.maxFileSize, (long)1L, (long)-1L);
        datastoreProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.maxFileSize", maxFileSize));
        if (info.maxVirtualDiskCapacity != null) {
            String maxVmdkSize = FormatUtil.getStorageFormatted((Long)info.maxVirtualDiskCapacity, (long)1L, (long)-1L);
            datastoreProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.maxVmdkSize", maxVmdkSize));
        }
    }

    private static void populateVmfsDatastoreProperties(List<PropertyValueData> datastoreProperties, VmfsDatastoreInfo info, String dsType) {
        String dsFileSystem = H5StorageUtil.isVsanDirectDatastore((String)dsType) ? StorageStringUtil.getString("datastore.vsand") : H5StorageUtil.formatVmfsVersion((VmfsVolume)info.vmfs);
        PropertyValueData fileSystemProp = DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.fileSystem", dsFileSystem);
        ArrayList<PropertyValueData> fileSystemPropNestedProperties = new ArrayList<PropertyValueData>();
        fileSystemPropNestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.type", dsFileSystem));
        String maxFileSize = FormatUtil.getStorageFormatted((Long)info.maxFileSize, (long)1L, (long)-1L);
        fileSystemPropNestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.maxFileSize", maxFileSize));
        String maxVmdkSize = FormatUtil.getStorageFormatted((Long)info.maxVirtualDiskCapacity, (long)1L, (long)-1L);
        fileSystemPropNestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.maxVmdkSize", maxVmdkSize));
        String blockSize = info.vmfs.blockSize != null ? FormatUtil.getStorageFormatted((Long)info.vmfs.blockSize.longValue(), (long)1024L, (long)-1L) : FormatUtil.getStorageFormatted((Long)Long.valueOf(info.vmfs.blockSizeMb), (long)0x100000L, (long)0x100000L);
        fileSystemPropNestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.blockSize", blockSize));
        if (info.vmfs.unmapGranularity != null) {
            String unmapGranularity = FormatUtil.getStorageFormatted((Long)((Object)info.vmfs.unmapGranularity), (long)1024L, (long)-1L);
            fileSystemPropNestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.unmapGranularity", unmapGranularity));
        }
        fileSystemProp.nestedProperties = fileSystemPropNestedProperties.toArray(new PropertyValueData[fileSystemPropNestedProperties.size()]);
        datastoreProperties.add(fileSystemProp);
        datastoreProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.driveType", H5StorageUtil.formatFlash((Boolean)info.vmfs.ssd)));
    }

    private static void populateDatastoreNameProperty(List<PropertyValueData> datastoreProperties, Datastore.Info info) {
        datastoreProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.properties.name", info.name));
    }

    private static void populateIormProperties(List<PropertyValueData> datastoreCapabilityProperties, Boolean iormSupportedCapability, StorageResourceManager.IORMConfigInfo iormConfigInfo) {
        String statsCollectionEnabled;
        String ioStatsExcluded;
        String iormMode;
        String iormStatus;
        String congestionThreshold = "";
        boolean includeCongestionThreshold = false;
        ActionData[] actions = new ActionData[]{};
        if (Boolean.TRUE.equals(iormSupportedCapability) && iormConfigInfo != null) {
            iormStatus = H5StorageUtil.formatEnabledValue((Boolean)iormConfigInfo.enabled);
            boolean isAutomaticMode = StorageResourceManager.CongestionThresholdMode.automatic.toString().equals(iormConfigInfo.congestionThresholdMode);
            iormMode = H5StorageUtil.formatIormMode((boolean)isAutomaticMode, (StorageResourceManager.IORMConfigInfo)iormConfigInfo);
            if (!isAutomaticMode) {
                includeCongestionThreshold = true;
                congestionThreshold = StorageStringUtil.getString("datastore.IORM.msThreshold", String.valueOf(iormConfigInfo.congestionThreshold));
            }
            boolean storageIORMStatsAggregationEnabled = iormConfigInfo.statsAggregationDisabled == null || iormConfigInfo.statsAggregationDisabled == false;
            ioStatsExcluded = H5StorageUtil.formatEnabledValue((Boolean)storageIORMStatsAggregationEnabled);
            statsCollectionEnabled = H5StorageUtil.formatEnabledValue((Boolean)iormConfigInfo.statsCollectionEnabled);
            actions = new ActionData[]{ActionData.newInstance((String)"vsphere.core.datastore.actions.configSIOC", (String)ResourceUtil.getString((String)"h5storageservice", (String)"generalEditAction.label", (ClassLoader)DatastorePropertyProvider.class.getClassLoader()))};
        } else {
            String naText = StorageStringUtil.getString("na");
            iormStatus = H5StorageUtil.formatSupportedValue((Boolean)false);
            iormMode = naText;
            congestionThreshold = naText;
            includeCongestionThreshold = true;
            ioStatsExcluded = naText;
            statsCollectionEnabled = naText;
        }
        ArrayList<PropertyValueData> nestedProperties = new ArrayList<PropertyValueData>();
        nestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormStatus", iormStatus));
        nestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormMode", iormMode));
        if (includeCongestionThreshold) {
            nestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormCongestionThreshold", congestionThreshold));
        }
        nestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.ioStatsExcluded", ioStatsExcluded));
        nestedProperties.add(DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.statsCollection", statsCollectionEnabled));
        PropertyValueData iormPropertyItem = DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.iormControl", iormStatus);
        iormPropertyItem.nestedProperties = nestedProperties.toArray(new PropertyValueData[nestedProperties.size()]);
        iormPropertyItem.actions = actions;
        datastoreCapabilityProperties.add(iormPropertyItem);
    }

    private void populateVmdkDatastoreProperties(List<PropertyValueData> datastoreCapabilityProperties, Boolean isClusteredVmdkSupported, Object resourceObject) {
        boolean isVmdkEnabled;
        if (!Boolean.TRUE.equals(isClusteredVmdkSupported)) {
            return;
        }
        try {
            isVmdkEnabled = this.isVmdkEnabled((ManagedObjectReference)resourceObject);
        }
        catch (Exception e) {
            _logger.error((Object)"Error while querying 'isVmdkEnabled' for datastore.", (Throwable)e);
            return;
        }
        PropertyValueData clustetredVmdkSupportedPropertyItem = DatastorePropertyProviderAdapter.newPropValueDataWithKey("datastore.manage.general.datastoreCapabilities.vmdkSupport", isVmdkEnabled ? this.getLocalizedValue("datastore.manage.general.datastoreCapabilities.enabledVmdkSupport") : this.getLocalizedValue("datastore.manage.general.datastoreCapabilities.disabledVmdkSupport"));
        ActionData[] actions = isVmdkEnabled ? new ActionData[]{ActionData.newInstance((String)"vsphere.core.datastore.actions.disableVmdkSupport", (String)this.getLocalizedValue("datastore.manage.general.datastoreCapabilities.disableVmdkSupport"))} : new ActionData[]{ActionData.newInstance((String)"vsphere.core.datastore.actions.enableVmdkSupport", (String)this.getLocalizedValue("datastore.manage.general.datastoreCapabilities.enableVmdkSupport"))};
        clustetredVmdkSupportedPropertyItem.actions = actions;
        datastoreCapabilityProperties.add(clustetredVmdkSupportedPropertyItem);
    }

    private String getLocalizedValue(String key) {
        return ResourceUtil.getString((String)"h5storageservice", (String)key, (ClassLoader)DatastorePropertyProvider.class.getClassLoader());
    }

    private boolean isVmdkEnabled(ManagedObjectReference datastoreRef) throws Exception {
        Datastore datastore = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreRef);
        return datastore.isClusteredVmdkEnabled();
    }

    private static PropertyValueData newPropValueDataWithKey(String labelKey, String value) {
        return PropertyValueData.newInstance((String)StorageStringUtil.getString(labelKey), (String)value);
    }
}

