/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.storage.data.datastore.HardwareAccelerationData;
import com.vmware.vsphere.client.h5.storage.data.datastore.HardwareAccelerationItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.HostFileSystemMountsData;
import com.vmware.vsphere.client.h5.storage.data.datastore.HostHardwareAccelerationItem;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostHardwareAccelerationPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(HostHardwareAccelerationPropertyProvider.class);
    private final QueryBindingService _queryBindingService;

    public HostHardwareAccelerationPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="storage", property="hostHardwareAccelerationForDatastore")
    public HardwareAccelerationItem getHostHardwareAccelerationForDatastore(ManagedObjectReference datastoreRef) {
        HardwareAccelerationData dataserviceResponse = (HardwareAccelerationData)this._queryBindingService.prepare(HardwareAccelerationData.class).fetch((Object)datastoreRef);
        HardwareAccelerationItem result = new HardwareAccelerationItem();
        result.summary = HardwareAccelerationItem.HardwareAccelerationSummary.SUPPORTED_ON_ALL_HOSTS;
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostMounts.length == 0 || dataserviceResponse.hostFileSystemMounts == null) {
            result.hostHardwareAccelerationItems = new HostHardwareAccelerationItem[0];
            return result;
        }
        ArrayList<HostHardwareAccelerationItem> hostItems = new ArrayList<HostHardwareAccelerationItem>();
        int hostSupportingHardwareAccelerationCount = 0;
        for (Datastore.HostMount hostMount : dataserviceResponse.hostMounts) {
            HostFileSystemMountsData hostFileSystemMounts = this.findHostData(hostMount.key, dataserviceResponse.hostFileSystemMounts);
            if (hostFileSystemMounts == null || hostFileSystemMounts.fileSystemMountInfos == null) {
                _logger.warn((Object)"Failed find hostMountInfo for host");
                continue;
            }
            FileSystemMountInfo fileSystemMountInfo = this.findFileSystemInfo(hostMount.mountInfo.path, hostFileSystemMounts);
            if (fileSystemMountInfo == null) {
                _logger.warn((Object)String.format("Host '%s' does not see mount point '%s'", hostMount.key.getValue(), hostMount.mountInfo.path));
                continue;
            }
            HostHardwareAccelerationItem currentHostItem = new HostHardwareAccelerationItem();
            currentHostItem.hardwareAccelerationSupport = this.getvStorageSupportStatus(fileSystemMountInfo);
            if (currentHostItem.hardwareAccelerationSupport == FileSystemMountInfo.VStorageSupportStatus.vStorageSupported) {
                ++hostSupportingHardwareAccelerationCount;
            }
            currentHostItem.hostName = hostFileSystemMounts.name;
            currentHostItem.hostRef = hostMount.key;
            hostItems.add(currentHostItem);
        }
        if (hostSupportingHardwareAccelerationCount == 0) {
            result.summary = HardwareAccelerationItem.HardwareAccelerationSummary.NOT_SUPPORTED_ON_ANY_HOST;
        } else if (hostSupportingHardwareAccelerationCount < hostItems.size()) {
            result.summary = HardwareAccelerationItem.HardwareAccelerationSummary.SUPPORTED_ON_SOME_HOSTS;
        }
        result.hostHardwareAccelerationItems = hostItems.toArray(new HostHardwareAccelerationItem[hostItems.size()]);
        return result;
    }

    private FileSystemMountInfo.VStorageSupportStatus getvStorageSupportStatus(FileSystemMountInfo fileSystemMountInfo) {
        if (StringUtils.isEmpty((String)fileSystemMountInfo.vStorageSupport)) {
            return FileSystemMountInfo.VStorageSupportStatus.vStorageUnsupported;
        }
        return FileSystemMountInfo.VStorageSupportStatus.valueOf((String)fileSystemMountInfo.vStorageSupport);
    }

    private FileSystemMountInfo findFileSystemInfo(String path, HostFileSystemMountsData currentData) {
        for (FileSystemMountInfo fileSystemMountInfo : currentData.fileSystemMountInfos) {
            if (!fileSystemMountInfo.mountInfo.path.equals(path)) continue;
            return fileSystemMountInfo;
        }
        _logger.error((Object)"Failed find fileSystemMountInfo for host");
        return null;
    }

    private HostFileSystemMountsData findHostData(ManagedObjectReference key, HostFileSystemMountsData[] hostsData) {
        for (HostFileSystemMountsData currentData : hostsData) {
            if (!currentData.provider.equals(key)) continue;
            return currentData;
        }
        return null;
    }
}

