/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl.adapters;

import com.vmware.vim.binding.vim.host.HbaCreateSpec;
import com.vmware.vim.binding.vim.host.NvmeConnectSpec;
import com.vmware.vim.binding.vim.host.NvmeDisconnectSpec;
import com.vmware.vim.binding.vim.host.NvmeDiscoverSpec;
import com.vmware.vim.binding.vim.host.NvmeDiscoveryLog;
import com.vmware.vim.binding.vim.host.NvmeOverFibreChannelParameters;
import com.vmware.vim.binding.vim.host.NvmeOverRdmaParameters;
import com.vmware.vim.binding.vim.host.NvmeOverTcpParameters;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.TcpHbaCreateSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.storage.model.adapter.DiscoverFCControllerData;
import com.vmware.vsphere.client.h5.storage.model.adapter.NvmeOverFCTransportParametersData;
import com.vmware.vsphere.client.h5.storage.spec.adapter.CreateNvmeOverRdmaAdapterSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.CreateNvmeOverTcpAdapterSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeControllerDisconnectSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverFibreChannelControllerConnectSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverFibreChannelControllerDiscoverSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverRdmaControllerConnectSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverRdmaControllerDiscoverSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverTcpControllerConnectSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.NvmeOverTcpControllerDiscoverSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.RemoveAdapterSpec;
import com.vmware.vsphere.client.h5.storage.spec.adapter.RemoveNvmeOverRdmaAdapterSpec;
import com.vmware.vsphere.client.storage.StorageDataService;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NvmeAdapterMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(NvmeAdapterMutationProvider.class);
    private final StorageDataService _storageDataService;
    private final String nullEmptyString = "%s cannot be null or empty.";
    private final String errorString = "NvmeAdapterMutationProvider: Error during %s:";

    public NvmeAdapterMutationProvider(StorageDataService storageDataService) {
        this._storageDataService = storageDataService;
    }

    public OperationResult apply(ManagedObjectReference hostRef, CreateNvmeOverRdmaAdapterSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.rdmaDeviceName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "RDMA device name"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.createNvmeOverRdmaAdapter(spec.rdmaDeviceName);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "CreateNvmeOverRdmaAdapterSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RemoveNvmeOverRdmaAdapterSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.hbaDeviceName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter device name"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.removeNvmeOverRdmaAdapter(spec.hbaDeviceName);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "RemoveNvmeOverRdmaAdapterSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NvmeOverRdmaControllerDiscoverSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.address)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "IP address"));
        }
        if (StringUtils.isEmpty((String)spec.hbaName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeDiscoverSpec discoverSpec = new NvmeDiscoverSpec();
            discoverSpec.hbaName = spec.hbaName;
            if (spec.rootDiscoveryController != null) {
                discoverSpec.rootDiscoveryController = spec.rootDiscoveryController;
            }
            NvmeOverRdmaParameters nvmeTransportParameters = new NvmeOverRdmaParameters();
            nvmeTransportParameters.address = spec.address;
            if (spec.addressFamily != null) {
                nvmeTransportParameters.addressFamily = spec.addressFamily;
            }
            if (spec.portNumber != null) {
                nvmeTransportParameters.portNumber = spec.portNumber;
            }
            discoverSpec.transportParameters = nvmeTransportParameters;
            discoverSpec.autoConnect = spec.autoConnect;
            NvmeDiscoveryLog nvmeDiscoverLog = storageSystem.discoverNvmeControllers(discoverSpec);
            if (nvmeDiscoverLog != null) {
                opResult.result = this.getUnusedControllers(nvmeDiscoverLog.getEntry());
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverRdmaControllerDiscoverSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NvmeOverFibreChannelControllerDiscoverSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.hbaName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
        }
        if (spec.nodeWorldWideName == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Node name"));
        }
        if (spec.portWorldWideName == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Port"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeDiscoverSpec discoverSpec = new NvmeDiscoverSpec();
            discoverSpec.hbaName = spec.hbaName;
            if (spec.rootDiscoveryController != null) {
                discoverSpec.rootDiscoveryController = spec.rootDiscoveryController;
            }
            NvmeOverFibreChannelParameters nvmeTransportParameters = new NvmeOverFibreChannelParameters();
            nvmeTransportParameters.nodeWorldWideName = Long.parseLong(spec.nodeWorldWideName, 16);
            nvmeTransportParameters.portWorldWideName = Long.parseLong(spec.portWorldWideName, 16);
            discoverSpec.transportParameters = nvmeTransportParameters;
            discoverSpec.autoConnect = spec.autoConnect;
            NvmeDiscoveryLog nvmeDiscoverLog = storageSystem.discoverNvmeControllers(discoverSpec);
            opResult.result = this.getUnusedFCControllers(nvmeDiscoverLog.getEntry());
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverFibreChannelControllerDiscoverSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NvmeOverTcpControllerDiscoverSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.address)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "IP address"));
        }
        if (StringUtils.isEmpty((String)spec.hbaName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
        }
        if (StringUtils.isEmpty((String)spec.digestVerification)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Digest verification"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeDiscoverSpec discoverSpec = new NvmeDiscoverSpec();
            discoverSpec.hbaName = spec.hbaName;
            if (spec.rootDiscoveryController != null) {
                discoverSpec.rootDiscoveryController = spec.rootDiscoveryController;
            }
            NvmeOverTcpParameters nvmeTransportParameters = new NvmeOverTcpParameters();
            nvmeTransportParameters.address = spec.address;
            nvmeTransportParameters.digestVerification = spec.digestVerification;
            if (spec.portNumber != null) {
                nvmeTransportParameters.portNumber = spec.portNumber;
            }
            discoverSpec.transportParameters = nvmeTransportParameters;
            discoverSpec.autoConnect = spec.autoConnect;
            NvmeDiscoveryLog nvmeDiscoverLog = storageSystem.discoverNvmeControllers(discoverSpec);
            if (nvmeDiscoverLog != null) {
                opResult.result = this.getUnusedControllers(nvmeDiscoverLog.getEntry());
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverTcpControllerDiscoverSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference hostRef, NvmeOverRdmaControllerConnectSpec ... specs) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        for (NvmeOverRdmaControllerConnectSpec spec : specs) {
            if (StringUtils.isEmpty((String)spec.hbaName)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
            }
            if (StringUtils.isEmpty((String)spec.subnqn)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Subnqn"));
            }
            if (!StringUtils.isEmpty((String)spec.address)) continue;
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Ip address"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeConnectSpec[] connectSpecs = new NvmeConnectSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                NvmeConnectSpec connectSpec = new NvmeConnectSpec();
                connectSpec.hbaName = specs[i].hbaName;
                connectSpec.subnqn = specs[i].subnqn;
                NvmeOverRdmaParameters nvmeTransportParameters = new NvmeOverRdmaParameters();
                nvmeTransportParameters.address = specs[i].address;
                if (specs[i].addressFamily != null) {
                    nvmeTransportParameters.addressFamily = specs[i].addressFamily;
                }
                if (specs[i].portNumber != null) {
                    nvmeTransportParameters.portNumber = specs[i].portNumber;
                }
                connectSpec.transportParameters = nvmeTransportParameters;
                if (specs[i].adminQueueSize != null) {
                    connectSpec.adminQueueSize = specs[i].adminQueueSize;
                }
                if (specs[i].keepAliveTimeout != null) {
                    connectSpec.keepAliveTimeout = specs[i].keepAliveTimeout;
                }
                if (specs[i].controllerId != null) {
                    connectSpec.controllerId = specs[i].controllerId;
                }
                connectSpecs[i] = connectSpec;
            }
            if (connectSpecs.length == 1) {
                storageSystem.connectNvmeController(connectSpecs[0]);
            } else {
                storageSystem.connectNvmeControllerEx(connectSpecs);
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverRdmaControllerConnectSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference hostRef, NvmeOverFibreChannelControllerConnectSpec ... specs) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        for (NvmeOverFibreChannelControllerConnectSpec spec : specs) {
            if (StringUtils.isEmpty((String)spec.hbaName)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
            }
            if (StringUtils.isEmpty((String)spec.subnqn)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Subnqn name"));
            }
            if (spec.nodeWorldWideName == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Node name"));
            }
            if (spec.portWorldWideName != null) continue;
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Port"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeConnectSpec[] connectSpecs = new NvmeConnectSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                NvmeConnectSpec connectSpec = new NvmeConnectSpec();
                connectSpec.hbaName = specs[i].hbaName;
                connectSpec.subnqn = specs[i].subnqn;
                NvmeOverFibreChannelParameters nvmeTransportParameters = new NvmeOverFibreChannelParameters();
                if (specs[i].isTransportDataAutoDiscovered) {
                    nvmeTransportParameters.nodeWorldWideName = Long.parseLong(specs[i].nodeWorldWideName);
                    nvmeTransportParameters.portWorldWideName = Long.parseLong(specs[i].portWorldWideName);
                } else {
                    nvmeTransportParameters.nodeWorldWideName = Long.parseLong(specs[i].nodeWorldWideName, 16);
                    nvmeTransportParameters.portWorldWideName = Long.parseLong(specs[i].portWorldWideName, 16);
                }
                connectSpec.transportParameters = nvmeTransportParameters;
                if (specs[i].adminQueueSize != null) {
                    connectSpec.adminQueueSize = specs[i].adminQueueSize;
                }
                if (specs[i].keepAliveTimeout != null) {
                    connectSpec.keepAliveTimeout = specs[i].keepAliveTimeout;
                }
                if (specs[i].controllerId != null) {
                    connectSpec.controllerId = specs[i].controllerId;
                }
                connectSpecs[i] = connectSpec;
            }
            if (connectSpecs.length == 1) {
                storageSystem.connectNvmeController(connectSpecs[0]);
            } else {
                storageSystem.connectNvmeControllerEx(connectSpecs);
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverFibreChannelControllerConnectSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference hostRef, NvmeOverTcpControllerConnectSpec ... specs) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        for (NvmeOverTcpControllerConnectSpec spec : specs) {
            if (StringUtils.isEmpty((String)spec.hbaName)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
            }
            if (StringUtils.isEmpty((String)spec.subnqn)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Subnqn"));
            }
            if (StringUtils.isEmpty((String)spec.address)) {
                throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Ip address"));
            }
            if (!StringUtils.isEmpty((String)spec.digestVerification)) continue;
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Digest verification"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeConnectSpec[] connectSpecs = new NvmeConnectSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                NvmeConnectSpec connectSpec = new NvmeConnectSpec();
                connectSpec.hbaName = specs[i].hbaName;
                connectSpec.subnqn = specs[i].subnqn;
                NvmeOverTcpParameters nvmeTransportParameters = new NvmeOverTcpParameters();
                nvmeTransportParameters.address = specs[i].address;
                nvmeTransportParameters.digestVerification = specs[i].digestVerification;
                if (specs[i].portNumber != null) {
                    nvmeTransportParameters.portNumber = specs[i].portNumber;
                }
                connectSpec.transportParameters = nvmeTransportParameters;
                if (specs[i].adminQueueSize != null) {
                    connectSpec.adminQueueSize = specs[i].adminQueueSize;
                }
                if (specs[i].keepAliveTimeout != null) {
                    connectSpec.keepAliveTimeout = specs[i].keepAliveTimeout;
                }
                if (specs[i].controllerId != null) {
                    connectSpec.controllerId = specs[i].controllerId;
                }
                connectSpecs[i] = connectSpec;
            }
            if (connectSpecs.length == 1) {
                storageSystem.connectNvmeController(connectSpecs[0]);
            } else {
                storageSystem.connectNvmeControllerEx(connectSpecs);
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeOverRdmaControllerConnectSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference hostRef, NvmeControllerDisconnectSpec ... specs) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        for (NvmeControllerDisconnectSpec spec : specs) {
            if (spec.controllerNumber == null && spec.subnqn == null) {
                throw new IllegalArgumentException("Controller number or subnqn must be set");
            }
            if (!StringUtils.isEmpty((String)spec.hbaName)) continue;
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter name"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            NvmeDisconnectSpec[] disconnectSpecs = new NvmeDisconnectSpec[specs.length];
            for (int i = 0; i < specs.length; ++i) {
                NvmeDisconnectSpec disconnectSpec = new NvmeDisconnectSpec();
                disconnectSpec.hbaName = specs[i].hbaName;
                if (specs[i].controllerNumber != null) {
                    disconnectSpec.controllerNumber = specs[i].controllerNumber;
                }
                if (specs[i].subnqn != null) {
                    disconnectSpec.subnqn = specs[i].subnqn;
                }
                disconnectSpecs[i] = disconnectSpec;
            }
            if (disconnectSpecs.length == 1) {
                storageSystem.disconnectNvmeController(disconnectSpecs[0]);
            } else {
                storageSystem.disconnectNvmeControllerEx(disconnectSpecs);
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "NvmeControllerDisconnectSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, CreateNvmeOverTcpAdapterSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.pnic)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "The device name of the associated physical NIC"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            TcpHbaCreateSpec hbaCreateSpec = new TcpHbaCreateSpec();
            hbaCreateSpec.pnic = spec.pnic;
            storageSystem.createSoftwareAdapter((HbaCreateSpec)hbaCreateSpec);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "CreateNvmeOverTcpAdapterSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RemoveAdapterSpec spec) {
        OperationResult opResult = new OperationResult();
        if (hostRef == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Host"));
        }
        opResult.entity = hostRef;
        if (StringUtils.isEmpty((String)spec.hbaDeviceName)) {
            throw new IllegalArgumentException(String.format("%s cannot be null or empty.", "Adapter device name"));
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.removeSoftwareAdapter(spec.hbaDeviceName);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("NvmeAdapterMutationProvider: Error during %s:", "RemoveAdapterSpec"), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private NvmeDiscoveryLog.Entry[] getUnusedControllers(NvmeDiscoveryLog.Entry[] entries) {
        ArrayList<NvmeDiscoveryLog.Entry> contrtollers = new ArrayList<NvmeDiscoveryLog.Entry>();
        if (entries != null) {
            for (NvmeDiscoveryLog.Entry entry : entries) {
                if (entry.connected || !NvmeDiscoveryLog.SubsystemType.nvm.toString().equals(entry.subsystemType)) continue;
                contrtollers.add(entry);
            }
        }
        return contrtollers.toArray(new NvmeDiscoveryLog.Entry[contrtollers.size()]);
    }

    private DiscoverFCControllerData[] getUnusedFCControllers(NvmeDiscoveryLog.Entry[] entries) {
        ArrayList<DiscoverFCControllerData> controllers = new ArrayList<DiscoverFCControllerData>();
        if (entries != null) {
            for (NvmeDiscoveryLog.Entry entry : entries) {
                if (entry.connected || !NvmeDiscoveryLog.SubsystemType.nvm.toString().equals(entry.subsystemType)) continue;
                DiscoverFCControllerData controllerData = new DiscoverFCControllerData();
                controllerData.subnqn = entry.subnqn;
                controllerData.controllerId = entry.controllerId;
                controllerData.subsystemType = entry.subsystemType;
                NvmeOverFCTransportParametersData controllerTransportParameters = new NvmeOverFCTransportParametersData();
                NvmeOverFibreChannelParameters transportParameters = (NvmeOverFibreChannelParameters)entry.transportParameters;
                controllerTransportParameters.nodeWorldWideName = String.valueOf(transportParameters.nodeWorldWideName);
                controllerTransportParameters.portWorldWideName = String.valueOf(transportParameters.portWorldWideName);
                controllerData.transportParameters = controllerTransportParameters;
                controllers.add(controllerData);
            }
        }
        return controllers.toArray(new DiscoverFCControllerData[controllers.size()]);
    }
}

