/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.sms.Task;
import com.vmware.vim.binding.sms.TaskInfo;
import com.vmware.vim.binding.sms.fault.CertificateNotTrusted;
import com.vmware.vim.binding.sms.provider.ProviderSpec;
import com.vmware.vim.binding.sms.provider.VasaProvider;
import com.vmware.vim.binding.sms.provider.VasaProviderSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.sms.BaseStorageProviderSpec;
import com.vmware.vsphere.client.sms.CertificateDetailsInfo;
import com.vmware.vsphere.client.sms.CertificateInfo;
import com.vmware.vsphere.client.sms.ReconnectStorageProviderSpec;
import com.vmware.vsphere.client.sms.RefreshStorageProviderCertificateSpec;
import com.vmware.vsphere.client.sms.ResyncVsanProvidersSpec;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.StorageProviderReauthenticateHostsSpec;
import com.vmware.vsphere.client.sms.StorageProviderReauthenticateVcSpec;
import com.vmware.vsphere.client.sms.StorageProviderRegisterSpec;
import com.vmware.vsphere.client.sms.StorageProviderSyncSpec;
import com.vmware.vsphere.client.sms.StorageProviderUnregisterSpec;
import com.vmware.vsphere.client.sms.StorageProviderUpgradeSpec;
import com.vmware.vsphere.client.sms.impl.SmsServiceFactory;
import com.vmware.vsphere.client.sms.impl.SmsTaskWaiter;
import com.vmware.vsphere.client.sms.util.SmsSessionUtil;
import com.vmware.vsphere.client.sms.util.SmsUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(SmsMutationProvider.class);
    private static final long SMS_TASK_TIMEOUT_IN_MS = 480000L;
    private final SmsServiceFactory _smsServiceFactory;

    public SmsMutationProvider(SmsServiceFactory smsServiceFactory) {
        this._smsServiceFactory = smsServiceFactory;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderRegisterSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootVcFolder;
        try {
            new URL(spec.providerUrl);
        }
        catch (MalformedURLException e) {
            _logger.error((Object)"Failed to register storage provider: invalid provider url", (Throwable)e);
            result.error = SmsUtil.getMethodFault(e);
            return result;
        }
        try {
            VasaProviderSpec vasaProviderSpec = SmsMutationProvider.createVasaProviderSpec(spec);
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            BlockingFuture future = new BlockingFuture();
            smsService.getStorageManager().registerProvider((ProviderSpec)vasaProviderSpec, (Future)future);
            Task registrationTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitRegistrationTaskToComplete(registrationTask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to register storage provider", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderSyncSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootVcFolder;
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            VasaProvider vasaProvider = (VasaProvider)smsService.getManagedObject(spec.vasaStorageProvider);
            BlockingFuture future = new BlockingFuture();
            vasaProvider.sync(null, (Future)future);
            Task syncTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(syncTask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to synchronize storage provider", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, ResyncVsanProvidersSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootVcFolder;
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            BlockingFuture future = new BlockingFuture();
            if (VcServiceUtil.is66VcOrLaterByServerGuid((String)rootVcFolder.getServerGuid())) {
                smsService.getStorageManager().resyncInternalVasaProvider((Future)future);
            } else {
                smsService.getStorageManager().resyncVsanProviders(spec.resyncSpec, (Future)future);
            }
            Task resyncTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(resyncTask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to resynchronize vsan storage providers", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, RefreshStorageProviderCertificateSpec spec) {
        return new StorageProviderMutationTemplateHolder(){

            @Override
            public void mutateStorageProvider() throws Exception {
                this.vasaProvider.refreshCertificate((Future)this.future);
            }

            @Override
            public void handleException(Exception exception) {
                _logger.error((Object)"Failed to refresh storage provider certificate", (Throwable)exception);
                this.result.error = SmsUtil.getMethodFault(exception);
            }
        }.mainMutationMethod(rootVcFolder, (BaseStorageProviderSpec)spec);
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, ReconnectStorageProviderSpec spec) {
        return new StorageProviderMutationTemplateHolder(){

            @Override
            public void mutateStorageProvider() throws Exception {
                this.vasaProvider.reconnect((Future)this.future);
            }

            @Override
            public void handleException(Exception exception) {
                _logger.error((Object)"Failed to reconnect storage provider ", (Throwable)exception);
                this.result.error = SmsUtil.getMethodFault(exception);
            }
        }.mainMutationMethod(rootVcFolder, (BaseStorageProviderSpec)spec);
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderUnregisterSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootVcFolder;
        this.removeInternal(result, rootVcFolder, spec);
        return result;
    }

    public OperationResult remove(ManagedObjectReference rootVcFolder, StorageProviderUnregisterSpec spec) {
        OperationResult result = new OperationResult();
        this.removeInternal(result, rootVcFolder, spec);
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderUpgradeSpec spec) {
        OperationResult result = new OperationResult();
        if (rootVcFolder == null || spec.upgradeSpec == null || StringUtils.isEmpty((CharSequence)spec.upgradeSpec.password) || StringUtils.isEmpty((CharSequence)spec.upgradeSpec.providerUid) || StringUtils.isEmpty((CharSequence)spec.upgradeSpec.username)) {
            throw new IllegalArgumentException("VC and upgradeSpec cannot be null.");
        }
        result.entity = rootVcFolder;
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            StorageManager storageManager = smsService.getStorageManager();
            BlockingFuture future = new BlockingFuture();
            storageManager.upgradeVASAProvider(spec.upgradeSpec, (Future)future);
            Task upgradeVASAProviderTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(upgradeVASAProviderTask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to upgrade the vasa storage provider.", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderReauthenticateVcSpec spec) {
        OperationResult result = new OperationResult();
        if (rootVcFolder == null || spec.vasaStorageProvider == null || StringUtils.isEmpty((CharSequence)spec.username) || StringUtils.isEmpty((CharSequence)spec.password)) {
            throw new IllegalArgumentException("VC and vasa provider`s username, password and MOR cannot be null.");
        }
        result.entity = rootVcFolder;
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            VasaProvider vasaProvider = (VasaProvider)smsService.getManagedObject(spec.vasaStorageProvider);
            BlockingFuture future = new BlockingFuture();
            vasaProvider.refreshVcClientAuthentication(spec.username, spec.password, (Future)future);
            Task reauthenticateVcTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(reauthenticateVcTask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to re-authenticate SMS client.", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootVcFolder, StorageProviderReauthenticateHostsSpec spec) {
        OperationResult result = new OperationResult();
        if (rootVcFolder == null) {
            throw new IllegalArgumentException("VC cannot be null.");
        }
        result.entity = rootVcFolder;
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            StorageManager storageManager = smsService.getStorageManager();
            BlockingFuture future = new BlockingFuture();
            storageManager.syncESXiClientCertificates(new String[0], (Future)future);
            Task syncESXiClientCertificatesTask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(syncESXiClientCertificatesTask, result, true);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to re-authenticate ESX clients.", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
        return result;
    }

    private void removeInternal(OperationResult result, ManagedObjectReference rootVcFolder, StorageProviderUnregisterSpec spec) {
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            BlockingFuture future = new BlockingFuture();
            smsService.getStorageManager().unregisterProvider(spec.uid, (Future)future);
            Task unregistertask = (Task)smsService.getManagedObject((ManagedObjectReference)future.get());
            SmsMutationProvider.waitTaskToComplete(unregistertask, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to unregister storage provider", (Throwable)ex);
            result.error = SmsUtil.getMethodFault(ex);
        }
    }

    private static VasaProviderSpec createVasaProviderSpec(StorageProviderRegisterSpec spec) throws Exception {
        VasaProviderSpec vasaProviderSpec = new VasaProviderSpec();
        vasaProviderSpec.name = spec.providerName;
        vasaProviderSpec.url = spec.providerUrl;
        vasaProviderSpec.username = spec.username;
        vasaProviderSpec.password = spec.password;
        vasaProviderSpec.certificate = null;
        if (spec.certificate != null && spec.certificate.length > 0) {
            try {
                X509Certificate cert = SmsMutationProvider.generateCertificateFromByteArray(spec.certificate);
                byte[] decodedCertificate = Base64.encodeBase64((byte[])cert.getEncoded());
                vasaProviderSpec.certificate = new String(decodedCertificate);
            }
            catch (Exception ex) {
                _logger.error((Object)"Invalid StorageProviderRegisterSpec: invalid certificate");
                throw SmsUtil.getLocalizedException("error.invalidCertificateFile", ex);
            }
        }
        return vasaProviderSpec;
    }

    private static void waitTaskToComplete(Task task, OperationResult opResult, boolean isInfiniteTimeout) throws Exception {
        TaskInfo taskInfo;
        SmsTaskWaiter taskWaiter = new SmsTaskWaiter(task);
        TaskInfo taskInfo2 = taskInfo = isInfiniteTimeout ? taskWaiter.waitTaskToComplete() : taskWaiter.waitTaskToComplete(480000L);
        if (taskInfo.error != null) {
            opResult.error = SmsUtil.getMethodFault(taskInfo.error);
        }
        opResult.result = taskInfo.result;
    }

    private static void waitTaskToComplete(Task task, OperationResult opResult) throws Exception {
        SmsMutationProvider.waitTaskToComplete(task, opResult, false);
    }

    private static void waitRegistrationTaskToComplete(Task task, OperationResult opResult) throws ExecutionException, InterruptedException, TimeoutException, CertificateException, NoSuchAlgorithmException, IOException {
        SmsTaskWaiter taskWaiter = new SmsTaskWaiter(task);
        TaskInfo taskInfo = taskWaiter.waitTaskToComplete(480000L);
        if (taskInfo.error instanceof CertificateNotTrusted) {
            opResult.result = SmsMutationProvider.getCertificateInfo((CertificateNotTrusted)taskInfo.error);
            opResult.error = SmsUtil.getMethodFault(taskInfo.error);
        } else {
            opResult.result = taskInfo.result;
            if (taskInfo.error != null) {
                opResult.error = SmsUtil.getMethodFault(taskInfo.error);
            }
        }
    }

    private static CertificateInfo getCertificateInfo(CertificateNotTrusted fault) throws CertificateException, IOException, NoSuchAlgorithmException {
        byte[] certificateData = Base64.decodeBase64((byte[])fault.getCertificate().getBytes());
        CertificateDetailsInfo certDetails = SmsUtil.extractCertificateDetails(fault.getCertificate());
        X509Certificate cert = SmsMutationProvider.generateCertificateFromByteArray(certificateData);
        CertificateInfo untrustedCertificateInfo = new CertificateInfo();
        untrustedCertificateInfo.certificate = certificateData;
        untrustedCertificateInfo.sslThumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)cert);
        untrustedCertificateInfo.details = certDetails;
        return untrustedCertificateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate generateCertificateFromByteArray(byte[] certificate) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate);){
            X509Certificate cert;
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(byteArrayInputStream);
            return x509Certificate;
        }
    }

    private abstract class StorageProviderMutationTemplateHolder {
        OperationResult result;
        SmsService smsService;
        VasaProvider vasaProvider;
        BlockingFuture<ManagedObjectReference> future;

        private StorageProviderMutationTemplateHolder() {
        }

        public OperationResult mainMutationMethod(ManagedObjectReference rootVcFolder, BaseStorageProviderSpec spec) {
            this.result = new OperationResult();
            this.result.entity = rootVcFolder;
            try {
                this.smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), SmsMutationProvider.this._smsServiceFactory);
                this.vasaProvider = (VasaProvider)this.smsService.getManagedObject(spec.vasaStorageProvider);
                this.future = new BlockingFuture();
                this.mutateStorageProvider();
                Task mutationTask = (Task)this.smsService.getManagedObject((ManagedObjectReference)this.future.get());
                SmsMutationProvider.waitTaskToComplete(mutationTask, this.result);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            return this.result;
        }

        public abstract void mutateStorageProvider() throws Exception;

        public abstract void handleException(Exception var1);
    }
}

