/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.util;

import com.vmware.vim.binding.sms.fault.AuthConnectionFailed;
import com.vmware.vim.binding.sms.fault.CertificateAuthorityFault;
import com.vmware.vim.binding.sms.fault.CertificateNotImported;
import com.vmware.vim.binding.sms.fault.CertificateNotTrusted;
import com.vmware.vim.binding.sms.fault.CertificateRefreshFailed;
import com.vmware.vim.binding.sms.fault.CertificateRevocationFailed;
import com.vmware.vim.binding.sms.fault.IncorrectUsernamePassword;
import com.vmware.vim.binding.sms.fault.InvalidCertificate;
import com.vmware.vim.binding.sms.fault.InvalidSession;
import com.vmware.vim.binding.sms.fault.InvalidUrl;
import com.vmware.vim.binding.sms.fault.MultipleSortSpecsNotSupported;
import com.vmware.vim.binding.sms.fault.NoCommonProviderForAllBackings;
import com.vmware.vim.binding.sms.fault.ProviderConnectionFailed;
import com.vmware.vim.binding.sms.fault.ProviderNotFound;
import com.vmware.vim.binding.sms.fault.ProviderRegistrationFault;
import com.vmware.vim.binding.sms.fault.ProviderSyncFailed;
import com.vmware.vim.binding.sms.fault.ProviderUnregistrationFault;
import com.vmware.vim.binding.sms.fault.ProxyRegistrationFailed;
import com.vmware.vim.binding.sms.fault.QueryExecutionFault;
import com.vmware.vim.binding.sms.fault.QueryNotSupported;
import com.vmware.vim.binding.sms.fault.ServiceNotInitialized;
import com.vmware.vim.binding.sms.fault.SyncInProgress;
import com.vmware.vim.binding.sms.fault.VmscProfileNotSupported;
import com.vmware.vim.binding.sms.fault.VsanProvidersResyncFailed;
import com.vmware.vim.binding.sms.fault.VvolRebindFault;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.sms.CertificateDetailsInfo;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsUtil {
    private static final String RESOURCE_BUNDLE_NAME = "SmsService";
    private static final String PEM_CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERTIFICATE_FOOTER = "-----END CERTIFICATE-----";
    private static final Log _logger = LogFactory.getLog(SmsUtil.class);
    private static final Map<Class<?>, String> FAULT_KEYS = new HashMap();

    public static Exception handleSmsError(Exception error) {
        if (FAULT_KEYS.containsKey(error.getClass())) {
            return SmsUtil.getLocalizedException(FAULT_KEYS.get(error.getClass()), error);
        }
        if (error.getCause() != null && FAULT_KEYS.containsKey(error.getCause().getClass())) {
            return SmsUtil.getLocalizedException(FAULT_KEYS.get(error.getCause().getClass()), error);
        }
        return error;
    }

    public static MethodFault getMethodFault(Exception ex) {
        return MixedUtil.getMethodFault((Throwable)SmsUtil.handleSmsError(ex));
    }

    public static Exception getLocalizedException(String key, Exception cause) {
        return new Exception(SmsUtil.getLocalizedString(key), cause);
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)SmsUtil.class.getClassLoader());
    }

    public static final CertificateDetailsInfo extractCertificateDetails(String certificateString) {
        if (StringUtils.isEmpty((CharSequence)certificateString)) {
            return null;
        }
        if (!certificateString.startsWith(PEM_CERTIFICATE_HEADER)) {
            certificateString = String.format("%s\n%s\n%s", PEM_CERTIFICATE_HEADER, certificateString, PEM_CERTIFICATE_FOOTER);
        }
        ByteArrayInputStream certificateStream = new ByteArrayInputStream(certificateString.getBytes());
        X509Certificate certificate = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)cf.generateCertificate(certificateStream);
        }
        catch (CertificateException certException) {
            _logger.error((Object)"Failed to retrieve certificate details: ", (Throwable)certException);
            return null;
        }
        CertificateDetailsInfo info = new CertificateDetailsInfo();
        info.subjectName = certificate.getSubjectX500Principal().getName();
        info.issuerName = certificate.getIssuerX500Principal().getName();
        info.version = certificate.getVersion();
        info.kind = certificate.getType();
        info.validFrom = certificate.getNotBefore();
        info.validTo = certificate.getNotAfter();
        info.algorithmName = certificate.getSigAlgName();
        info.publicKeyAlgorithmName = certificate.getPublicKey().getAlgorithm();
        return info;
    }

    static {
        FAULT_KEYS.put(AuthConnectionFailed.class, "error.authConnectionFailed");
        FAULT_KEYS.put(CertificateAuthorityFault.class, "error.certificateAuthorityFault");
        FAULT_KEYS.put(CertificateNotImported.class, "error.certificateNotImported");
        FAULT_KEYS.put(CertificateNotTrusted.class, "error.certificateNotTrusted");
        FAULT_KEYS.put(CertificateRefreshFailed.class, "error.certificateRefreshFailed");
        FAULT_KEYS.put(CertificateRevocationFailed.class, "error.CertificateRevocationFailed");
        FAULT_KEYS.put(IncorrectUsernamePassword.class, "error.incorrectUsernamePassword");
        FAULT_KEYS.put(InvalidCertificate.class, "error.invalidCertificate");
        FAULT_KEYS.put(InvalidSession.class, "error.invalidSession");
        FAULT_KEYS.put(InvalidUrl.class, "error.invalidUrl");
        FAULT_KEYS.put(MultipleSortSpecsNotSupported.class, "error.multipleSortSpecsNotSupported");
        FAULT_KEYS.put(NoCommonProviderForAllBackings.class, "error.noCommonProviderForAllBackings");
        FAULT_KEYS.put(ProviderConnectionFailed.class, "error.providerConnectionFailed");
        FAULT_KEYS.put(ProviderNotFound.class, "error.providerNotFound");
        FAULT_KEYS.put(ProviderRegistrationFault.class, "error.providerRegistrationFault");
        FAULT_KEYS.put(ProviderSyncFailed.class, "error.ProviderSyncFailed");
        FAULT_KEYS.put(ProviderUnregistrationFault.class, "error.ProviderUnregistrationFault");
        FAULT_KEYS.put(ProxyRegistrationFailed.class, "error.proxyRegistrationFailed");
        FAULT_KEYS.put(QueryExecutionFault.class, "error.queryExecutionFault");
        FAULT_KEYS.put(QueryNotSupported.class, "error.queryNotSupported");
        FAULT_KEYS.put(ServiceNotInitialized.class, "error.serviceNotInitialized");
        FAULT_KEYS.put(SyncInProgress.class, "error.syncInProgress");
        FAULT_KEYS.put(VmscProfileNotSupported.class, "error.vmscProfileNotSupported");
        FAULT_KEYS.put(VsanProvidersResyncFailed.class, "error.VsanProvidersResyncFailed");
        FAULT_KEYS.put(VvolRebindFault.class, "error.vvolRebindFault");
        FAULT_KEYS.put(AlreadyExists.class, "error.providerAlreadyExists");
        FAULT_KEYS.put(UnexpectedStatusCodeException.class, "error.serviceUnavailable");
        FAULT_KEYS.put(MalformedURLException.class, "error.invalidUrl");
    }
}

