/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class HostProfileCompressUtil {
    public static String unzip(byte[] compressed) throws Exception {
        if (compressed == null || compressed.length == 0) {
            throw new IllegalArgumentException("Cannot unzip null or empty bytes");
        }
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(compressed));){
            StringBuilder stringBuilder = new StringBuilder();
            byte[] buffer = new byte[1024];
            int read = 0;
            while (zis.getNextEntry() != null) {
                while ((read = zis.read(buffer, 0, 1024)) >= 0) {
                    stringBuilder.append(new String(buffer, 0, read, StandardCharsets.UTF_8));
                }
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static byte[] zip(String data) throws Exception {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Cannot zip null or empty strings");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                ZipEntry entry = new ZipEntry("zip");
                entry.setSize(data.getBytes().length);
                zos.putNextEntry(entry);
                zos.write(data.getBytes());
                zos.closeEntry();
                zos.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }
}

