/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.Version;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;

public class HostSystemPropertyProvider
implements PropertyProviderBean {
    private DataService _dataService;

    public HostSystemPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public Boolean getIsCreateProfileSupported(ManagedObjectReference entity) throws Exception {
        String hostVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)entity, (String)"config.product.version");
        Version version = new Version(hostVersion);
        return version.compareTo(new Version("4.0.0")) >= 0;
    }

    @type(value="HostSystem,ClusterComputeResource")
    public Boolean getCanAttachHostProfile(ManagedObjectReference entity) throws Exception {
        Boolean allowAttachOperation = true;
        ManagedObjectReference cluster = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)entity, (String)"cluster");
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)entity.getServerGuid());
        if (cluster != null) {
            allowAttachOperation = this.hasAssociatedHostProfile(profileManager, cluster) == false;
        }
        if (allowAttachOperation.booleanValue()) {
            allowAttachOperation = this.hasAssociatedHostProfile(profileManager, entity) == false;
        }
        return allowAttachOperation;
    }

    @type(value="HostSystem,ClusterComputeResource")
    public Boolean getCanChangeAssociatedHostProfile(ManagedObjectReference entity) throws Exception {
        Boolean result = true;
        ManagedObjectReference cluster = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)entity, (String)"cluster");
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)entity.getServerGuid());
        if (cluster != null) {
            result = this.hasAssociatedHostProfile(profileManager, cluster) == false;
        }
        if (result.booleanValue()) {
            result = this.hasAssociatedHostProfile(profileManager, entity);
        }
        return result;
    }

    private Boolean hasAssociatedHostProfile(ProfileManager profileManager, ManagedObjectReference entity) {
        Boolean result = false;
        ManagedObjectReference[] profiles = profileManager.findAssociatedProfile(entity);
        if (profiles != null) {
            for (ManagedObjectReference profile : profiles) {
                if (!profile.getType().equals(HostProfile.class.getSimpleName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

