/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vsphere.client.hostprofile.impl.ProfilePostProcessor;
import com.vmware.vsphere.client.hostprofile.util.ProcessUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PostProcessUtil {
    private static final Log _logger = LogFactory.getLog(PostProcessUtil.class);

    private PostProcessUtil() {
    }

    public static void convertLongValues(Policy policy, ParameterMetadata pm) {
        for (KeyAnyValue kav : policy.policyOption.parameter) {
            if (!kav.getKey().equalsIgnoreCase(pm.id.key)) continue;
            try {
                Long newValue = PostProcessUtil.convertObjectToLong(kav.getValue());
                kav.setValue((Object)newValue);
            }
            catch (Exception exc) {
                kav.setValue((Object)0L);
                String msg = PostProcessUtil.buildExceptionMessage(exc, pm);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private static Long convertObjectToLong(Object longObject) {
        if (longObject instanceof Double) {
            return ((Double)longObject).longValue();
        }
        if (longObject instanceof Integer) {
            return ((Integer)longObject).longValue();
        }
        if (longObject instanceof String) {
            return new Long((String)longObject);
        }
        if (longObject instanceof Long) {
            return (Long)longObject;
        }
        throw new IllegalArgumentException(longObject == null ? "Expected Long value is null" : "Expected Long value is " + longObject.getClass().getSimpleName());
    }

    private static String buildExceptionMessage(Exception nestedException, ParameterMetadata parMeta) {
        return "Parsing " + parMeta.id.label + " failed: " + nestedException.getMessage();
    }

    public static void convertStringArray(Policy policy, ParameterMetadata pm) {
        for (KeyAnyValue kav : policy.policyOption.parameter) {
            if (!kav.getKey().equalsIgnoreCase(pm.id.key)) continue;
            Object kavValue = kav.getValue();
            if (kavValue instanceof Object[]) {
                Object[] oldArray = (Object[])kav.getValue();
                String[] newArray = new String[oldArray.length];
                System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
                kav.setValue((Object)newArray);
                continue;
            }
            if (!(kavValue instanceof String)) continue;
            kav.setValue((Object)new String[]{(String)kavValue});
        }
    }

    public static KeyAnyValue[] convertToSingleParam(KeyAnyValue[] paramArray, ParameterMetadata parMeta) {
        KeyAnyValue[] emptyResult = new KeyAnyValue[]{};
        try {
            Class clazz = ProcessUtil.getParamMetaClass((ParameterMetadata)parMeta);
            if (clazz == null) {
                _logger.error((Object)"Failed to get ParameterMetadata class");
                return emptyResult;
            }
            Constructor ctor = clazz.getConstructor(new Class[0]);
            Object obj = ctor.newInstance(new Object[0]);
            for (KeyAnyValue kavParam : paramArray) {
                Field field;
                if (!ProcessUtil.isValidKeyAnyValue((KeyAnyValue)kavParam) || (field = PostProcessUtil.getField(clazz, kavParam.getKey())) == null) continue;
                PostProcessUtil.setObjectValue(field, obj, kavParam.getValue());
            }
            KeyAnyValueImpl result = new KeyAnyValueImpl();
            result.setKey(parMeta.id.key);
            result.setValue(obj);
            return new KeyAnyValue[]{result};
        }
        catch (Exception e) {
            _logger.error((Object)"convertToSingleParam failed", (Throwable)e);
            return emptyResult;
        }
    }

    private static void setObjectValue(Field field, Object object, Object value) {
        try {
            if (field.getType().equals(Long.class)) {
                if (value instanceof String) {
                    field.set(object, Long.parseLong((String)value));
                } else if (value instanceof Integer) {
                    field.set(object, (Integer)value);
                } else if (value instanceof Double) {
                    field.set(object, ((Double)value).longValue());
                }
            } else {
                field.set(object, value);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"setObjectValue failed", (Throwable)e);
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        if (clazz == null || StringUtils.isEmpty((CharSequence)fieldName)) {
            return null;
        }
        try {
            return clazz.getField(fieldName);
        }
        catch (Exception e) {
            _logger.error((Object)"getField failed", (Throwable)e);
            return null;
        }
    }

    public static void postProcessProfile(HostApplyProfile profile, PolicyMetadata[] policyMetadata) throws Exception {
        ProfilePostProcessor postProcessor = new ProfilePostProcessor(policyMetadata);
        postProcessor.process(profile);
    }
}

