/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import java.util.ArrayList;
import java.util.List;

public class ProfileWrapperUtil {
    public static void patchHostApplyProfileWrapperToBeMerged(ProfileWrapper rootProfileWrapper, boolean select) {
        if (rootProfileWrapper == null) {
            return;
        }
        List<ProfileWrapper> rootMostToBeMergedProfileWrappers = ProfileWrapperUtil.findRootMostToBeMergedProfileWrappers(rootProfileWrapper);
        for (ProfileWrapper profileWrapper : rootMostToBeMergedProfileWrappers) {
            ProfileWrapperUtil.setToBeMergedRecursive(profileWrapper, select, true);
        }
    }

    private static List<ProfileWrapper> findRootMostToBeMergedProfileWrappers(ProfileWrapper rootProfileWrapper) {
        ArrayList<ProfileWrapper> result = new ArrayList<ProfileWrapper>();
        ArrayList<ProfileWrapper> profileWrapperQueue = new ArrayList<ProfileWrapper>();
        profileWrapperQueue.add(rootProfileWrapper);
        while (profileWrapperQueue.size() > 0) {
            ProfileWrapper head = (ProfileWrapper)profileWrapperQueue.remove(0);
            if (head.obj instanceof ApplyProfile && Boolean.TRUE.equals(((ApplyProfile)head.obj).toBeMerged)) {
                result.add(head);
                continue;
            }
            if (head.children == null) continue;
            profileWrapperQueue.addAll(head.children);
        }
        return result;
    }

    private static void setToBeMergedRecursive(ProfileWrapper rootProfileWrapper, boolean selected, boolean skipRoot) {
        ArrayList<ProfileWrapper> profileWrapperQueue = new ArrayList<ProfileWrapper>();
        profileWrapperQueue.add(rootProfileWrapper);
        while (profileWrapperQueue.size() > 0) {
            ProfileWrapper head = (ProfileWrapper)profileWrapperQueue.remove(0);
            if ((head != rootProfileWrapper || !skipRoot) && head.obj instanceof ApplyProfile) {
                ((ApplyProfile)head.obj).toBeMerged = selected;
            }
            if (head.children == null) continue;
            profileWrapperQueue.addAll(head.children);
        }
    }
}

